----------------------------------------------------------------------- 
-- >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<< 
-- -------------------------------------------------------------------- 
-- Copyright (c) 2001 by Lattice Semiconductor Corporation 
-- -------------------------------------------------------------------- 
-- 
-- 
--                     Lattice Semiconductor Corporation 
--                     5555 NE Moore Court 
--                     Hillsboro, OR 97214 
--                     U.S.A 
-- 
--                     TEL: 1-800-Lattice (USA and Canada) 
--                          408-826-6000 (other locations) 
-- 
--                     web: http://www.latticesemi.com/ 
--                     email: techsupport@latticesemi.com 
-- 
-- -------------------------------------------------------------------- 
-- 
-- Simulation Library File for ispXPGA device 
-- 
-- -------------------------------------------------------------------- 
-- 
-- Revision History : 
-- $Header: R:/src/mod_kits/ispXPGA/VHDL/rcs/lava1.vhd 1.83 2004/03/25 18:48:30Z jli Exp $
-- Remove REN for MS;
-- Added arc for AS_LSB;
-- Modified the array element to pass MTI;
-- REV 1.1;
-- REV 1.2, changed the sympath from 20 bit to 2 bit for CDRX_10B12B;
-- REV 2.0: change RAMB256X18DSR & RAMB512X9DSR to not use CE as enable 
--          during write operations
-- REV 3.0: change cdrx_ss* and tx_ss* to compute half_period not using
--          the negedge. use posedge to posedge and divide it by two 
-- REV 4.0: change INIT values of RAM -- 20 bits longer than declared
-- REV 5.0: specify array_size (instead of open) in generic_map; eliminate
--          the second duplicated SC_SPRAM_16K_L module



LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.VITAL_timing.all;
USE IEEE.VITAL_primitives.all;
 
 
package VLOGTOVITAL_TABLES is
 
---------------------------------------------------------------------------------
-- Local type declaration
---------------------------------------------------------------------------------

    TYPE edge_table IS ARRAY (std_ulogic, std_ulogic) OF boolean ;

---------------------------------------------------------------------------------
-- Contants Specifications
-- posedge, negedge
---------------------------------------------------------------------------------
    CONSTANT POSEDGE : edge_table := (
    --      ---------------------------------------------------------
    --      |  U      X      0      1      Z      W      L      H      - |   |
    --      ---------------------------------------------------------
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, TRUE,  FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

    CONSTANT NEGEDGE : edge_table := (
    --      ---------------------------------------------------- -----
    --      |  U    X    0    1    Z    W    L    H    - |   |
    --      ---------------------------------------------------- -----
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | U |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | X |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 0 |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | 1 |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | Z |
            ( FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | W |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | L |
            ( FALSE, TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE ), -- | H |
            ( FALSE, FALSE, FALSE,FALSE, FALSE, FALSE, FALSE, FALSE, FALSE )  -- | - |
        );

        -------------------------------------------------------------------------------
        --State Table Declaration
        -------------------------------------------------------------------------------

	CONSTANT dfftab : VitalStateTableType := (
	-- D CLK R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1' ),
	( '-', '0', '1', '*', '1', '1' ),
	( '-', '1', '1', '*', '1', '1' ),
	( '1', '-', '0', '\', '0', 'X' ),---
	( '-', '0', '0', '\', '0', 'X' ),---
	( '-', '1', '0', '\', '0', 'X' ),---
	( '0', '-', '*', '1', '0', '0' ),
	( '-', '0', '*', '1', '0', '0' ),
	( '-', '1', '*', '1', '0', '0' ),
	( '0', '-', '\', '0', '1', 'X' ),--
	( '-', '0', '\', '0', '1', 'X' ),--
	( '-', '1', '\', '0', '1', 'X' ),--
	( '1', 'R', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '-', 'S' ),
	( '-', 'v', '-', '-', '-', 'S' ),
	( '0', 'r', '-', '-', '0', 'S' ),
	( '0', 'f', '-', '-', '0', 'S' ),
	( '1', 'r', '-', '-', '1', 'S' ),
	( '1', 'f', '-', '-', '1', 'S' ),
	( '*', '1', '-', '-', '-', 'S' ),
	( '*', '0', '-', '-', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


        -------------------------------------------------------------------------------
        --State Table Declaration
        -------------------------------------------------------------------------------

	CONSTANT dff_1tab : VitalStateTableType := (
	-- D CLK R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1' ),
	( '-', '1', '1', '*', '1', '1' ),
	( '-', '0', '1', '*', '1', '1' ),
	( '1', '-', '0', '\', '0', 'X' ),---
	( '-', '1', '0', '\', '0', 'X' ),---
	( '-', '0', '0', '\', '0', 'X' ),---
	( '0', '-', '*', '1', '0', '0' ),
	( '-', '1', '*', '1', '0', '0' ),
	( '-', '0', '*', '1', '0', '0' ),
	( '0', '-', '\', '0', '1', 'X' ),--
	( '-', '1', '\', '0', '1', 'X' ),--
	( '-', '0', '\', '0', '1', 'X' ),--
	( '1', 'F', '1', '1', '1', '1' ),
	( '0', 'F', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '-', 'S' ),
	( '-', 'v', '-', '-', '-', 'S' ),
	( '0', 'f', '-', '-', '0', 'S' ),
	( '0', 'r', '-', '-', '0', 'S' ),
	( '1', 'f', '-', '-', '1', 'S' ),
	( '1', 'r', '-', '-', '1', 'S' ),
	( '*', '0', '-', '-', '-', 'S' ),
	( '*', '1', '-', '-', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT latchtab : VitalStateTableType := (
	-- D LAT R S lstSt Q
	( '-', '-', '0', '1', '-', '0' ),
	( '-', '-', '1', '0', '-', '1' ),
	( '*', '0', '1', '1', '-', 'S' ),
	( '-', '\', '1', '1', '-', 'S' ),
	( '-', 'v', '1', '1', '-', 'S' ),
	( '-', 'f', '1', '1', '-', 'S' ),
	( '0', '^', '-', '1', '-', '0' ),
	( '1', '^', '1', '-', '-', '1' ),
	( '0', 'r', '1', '1', '0', '0' ),
	( '1', 'r', '1', '1', '1', '1' ),
	( '\', '1', '-', '1', '-', '0' ),
	( 'v', '1', '-', '1', '-', '0' ),
	( '/', '1', '1', '-', '-', '1' ),
	( '^', '1', '1', '-', '-', '1' ),
	( '0', '/', '-', '1', '-', '0' ),
	( '1', '/', '1', '-', '-', '1' ),
	( '-', '0', '1', '/', '-', 'S' ),
	( '-', '0', '1', '^', '-', 'S' ),
	( '-', '0', '/', '1', '-', 'S' ),
	( '-', '0', '^', '1', '-', 'S' ),
	( '0', '1', '-', '/', '-', '0' ),
	( '0', '1', '-', '^', '-', '0' ),
	( '1', '1', '/', '-', '-', '1' ),
	( '1', '1', '^', '-', '-', '1' ),
	( '1', '1', '1', '/', '-', '1' ),
	( '1', '1', '1', '^', '-', '1' ),
	( '0', '1', '/', '1', '-', '0' ),
	( '0', '1', '^', '1', '-', '0' ),
	( '/', 'X', '1', '-', '1', '1' ),
	( '^', 'X', '1', '-', '1', '1' ),
	( '\', 'X', '-', '1', '0', '0' ),
	( 'v', 'X', '-', '1', '0', '0' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT jkfftab : VitalStateTableType := (
	-- CLK J K S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '0' ),
	( '/', '1', '0', '1', '1', '-', '1' ),
	( '/', '1', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', '-', 'S' ),
	( 'B', '-', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT rsfftab : VitalStateTableType := (
	-- CLK RE SE S R lstSt Q
	( '-', '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '-', '1', '0', '-', '0' ),
	( '-', '1', '1', '/', '1', '-', 'S' ),
	( '-', '1', '1', '^', '1', '-', 'S' ),
	( '-', '1', '1', '1', '/', '-', 'S' ),
	( '-', '1', '1', '1', '^', '-', 'S' ),
	( '/', '0', '0', '1', '1', '-', 'S' ),
	( '/', '0', '1', '1', '1', '-', '1' ),
	( '/', '1', '0', '1', '1', '-', '0' ),
	( '\', '-', '-', '-', '-', '-', 'S' ),
	( 'R', '0', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '-', '1', '-', '0', 'S' ),
	( 'R', '-', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '0', '1', '1', '-', 'S' ),
	( 'f', '0', '-', '1', '-', '0', 'S' ),
	( 'f', '-', '0', '-', '1', '1', 'S' ),
	( 'X', '*', '0', '-', '1', '1', 'S' ),
	( 'X', '0', '*', '1', '-', '0', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'S', '/', '-', 'S' ),----
	( 'S', 'S', 'S', '/', 'S', '-', 'S' ),----
	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),----
	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ),
	( '-', '*', '-', '1', '1', '-', 'S' ),
	( '-', '-', '*', '1', '1', '-', 'S' ));


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT tfftab : VitalStateTableType := (
	-- CLK T S R lstSt Q
	( '-', '-', '0', '1', '-', '1' ),
	( '-', '-', '1', '0', '-', '0' ),
	( 'X', '0', '1', '-', '0', 'S' ),
	( '-', '-', '*', '1', '1', '1' ),
	( '-', '-', '1', '*', '0', '0' ),
	( '/', '0', '1', '1', '-', 'S' ),
	( '/', '1', '1', '1', '1', '0' ),
	( '/', '1', '1', '1', '0', '1' ),
	( '\', '-', '-', '-', '-', 'S' ),
	( 'B', '*', '-', '-', '-', 'S' ),
	( 'R', '0', '1', '1', '-', 'S' ),
	( 'R', '0', '1', '-', '0', 'S' ),
	( 'R', '0', '-', '1', '1', 'S' ),
	( 'v', '-', '-', '-', '-', 'S' ),
	( 'f', '0', '1', '1', '-', 'S' ),
	( 'f', '-', '-', '1', '1', 'S' ),
	( 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', '-', 'S' ) );


	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT dffcetab : VitalStateTableType := (
	-- D CLK R S CE lstSt Q
	( '-', '-', '0', '1', '-', '-', '0' ),
	( '-', '-', '1', '0', '-', '-', '1' ),
	( '-', '-', '1', '1', '0', '-', 'S' ),
	( '1', '/', '1', '-', '1', '-', '1' ),
	( '0', '/', '-', '1', '1', '-', '0' ),
	( '1', '-', '1', '*', '1', '1', '1' ),
	( '-', '0', '1', '*', '1', '1', '1' ),
	( '-', '1', '1', '*', '1', '1', '1' ),
	( '0', '-', '*', '1', '1', '0', '0' ),
	( '-', '0', '*', '1', '1', '0', '0' ),
	( '-', '1', '*', '1', '1', '0', '0' ),
	( '1', 'R', '1', '1', '1', '1', '1' ),
	( '0', 'R', '1', '1', '1', '0', '0' ),
	( '-', '\', '-', '-', '1', '-', 'S' ),
	( '-', 'v', '-', '-', '1', '-', 'S' ),
	( '0', 'r', '-', '-', '1', '0', 'S' ),
	( '0', 'f', '-', '-', '1', '0', 'S' ),
	( '1', 'r', '-', '-', '1', '1', 'S' ),
	( '1', 'f', '-', '-', '1', '1', 'S' ),
	( '*', '1', '-', '-', '1', '-', 'S' ),
	( '*', '0', '-', '-', '1', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
--	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
--	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( '-', '-', '1', '1', '*', '-', 'S' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );



	-------------------------------------------------------------------------------
	--State Table Declaration
	-------------------------------------------------------------------------------
	CONSTANT dffcebtab : VitalStateTableType := (
	-- D CLK R S CE lstSt Q
	( '-', '-', '0', '1', '-', '-', '0' ),
	( '-', '-', '1', '0', '-', '-', '1' ),
	( '-', '-', '1', '1', '1', '-', 'S' ),
	( '1', '/', '1', '-', '0', '-', '1' ),
	( '0', '/', '-', '1', '0', '-', '0' ),
	( '1', '-', '1', '*', '0', '1', '1' ),
	( '-', '0', '1', '*', '0', '1', '1' ),
	( '-', '1', '1', '*', '0', '1', '1' ),
	( '0', '-', '*', '1', '0', '0', '0' ),
	( '-', '0', '*', '1', '0', '0', '0' ),
	( '-', '1', '*', '1', '0', '0', '0' ),
	( '1', 'R', '1', '1', '0', '1', '1' ),
	( '0', 'R', '1', '1', '0', '0', '0' ),
	( '-', '\', '-', '-', '0', '-', 'S' ),
	( '-', 'v', '-', '-', '0', '-', 'S' ),
	( '0', 'r', '-', '-', '0', '0', 'S' ),
	( '0', 'f', '-', '-', '0', '0', 'S' ),
	( '1', 'r', '-', '-', '0', '1', 'S' ),
	( '1', 'f', '-', '-', '0', '1', 'S' ),
	( '*', '1', '-', '-', '0', '-', 'S' ),
	( '*', '0', '-', '-', '0', '-', 'S' ),
	( 'S', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'S', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'S', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'S', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'S', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'S', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'S', '-', 'S' ),
--	( 'S', 'S', 'S', 'S', 'f', '-', 'X' ),
--	( 'S', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'S', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'r', '-', 'X' ),
	( 'X', 'X', 'X', 'S', 'X', '-', 'S' ),
	( 'S', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'S', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'r', '-', 'X' ),
	( 'X', 'X', 'S', 'X', 'X', '-', 'S' ),
	( 'S', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'S', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'r', '-', 'X' ),
	( 'X', 'S', 'X', 'X', 'X', '-', 'S' ),
	( 'S', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'r', '-', 'X' ),
	( 'S', 'X', 'X', 'X', 'X', '-', 'S' ),
	( 'r', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'f', 'X', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'r', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'f', 'X', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'r', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'f', 'X', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'r', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'f', 'X', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'f', '-', 'X' ),
	( 'X', 'X', 'X', 'X', 'r', '-', 'X' ),
	( '-', '-', '1', '1', '*', '-', 'S' ),
	( 'X', 'X', 'X', 'X', 'X', '-', 'S' ) );

end VLOGTOVITAL_TABLES;


--------- RAM_PACKAGE ------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.all;
-- synopsys translate_off

library IEEE;
use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;
-- synopsys translate_on

package RAM_PACKAGE is

   SUBTYPE  data_word_typ_18        is std_logic_vector (17 downto 0);
   SUBTYPE  data_word_typ_9         is std_logic_vector (8 downto 0);
   SUBTYPE  address_type_8          is std_logic_vector (7 downto 0);
   SUBTYPE  address_type_9          is std_logic_vector (8 downto 0);
   TYPE     memory_array_typ_256    is array(0 to 255) of data_word_typ_18;
   TYPE     memory_array_typ_512    is array(0 to 511) of data_word_typ_9;

   CONSTANT x_data_18  : data_word_typ_18  := "XXXXXXXXXXXXXXXXXX";
   CONSTANT z_data_18  : data_word_typ_18  := "ZZZZZZZZZZZZZZZZZZ";
   CONSTANT x_add_8    : address_type_8    := "XXXXXXXX";

   CONSTANT x_data_9  : data_word_typ_9    := "XXXXXXXXX";
   CONSTANT z_data_9  : data_word_typ_9    := "ZZZZZZZZZ";
   CONSTANT x_add_9    : address_type_9    := "XXXXXXXXX";

   function VEC2INT	(v : std_logic_vector)	return integer;
   function BITX	(v : std_logic)		return boolean;
   function VECX	(v : std_logic_vector)	return boolean;

   function FillInit256	(v : std_logic_vector)	return memory_array_typ_256;
   function FillInit512	(v : std_logic_vector)	return memory_array_typ_512;

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT U : VitalTableSymbolType := 'X';

   CONSTANT RAM_RDATA_tab : VitalStateTableType := (
    ( L,  H,  x,  L ),
    ( H,  H,  x,  H ),
    ( x,  L,  x,  S ));
 
   CONSTANT RAMS_RDATA_tab : VitalStateTableType := (
    ( L,  L,  L,  x,  H,  x,  L ),
    ( L,  L,  x,  H,  H,  x,  L ),
    ( L,  H,  H,  x,  H,  x,  H ),
    ( L,  H,  x,  H,  H,  x,  H ),
    ( L,  x,  L,  L,  H,  x,  L ),
    ( L,  x,  H,  L,  H,  x,  H ),
    ( H,  x,  x,  x,  x,  x,  S ),
    ( x,  x,  x,  x,  L,  x,  S ));

   CONSTANT RAMS_RDATA_tab_H : VitalStateTableType := (
    ( H,  L,  L,  x,  L,  x,  L ),
    ( H,  L,  x,  H,  L,  x,  L ),
    ( H,  H,  H,  x,  L,  x,  H ),
    ( H,  H,  x,  H,  L,  x,  H ),
    ( H,  x,  L,  L,  L,  x,  L ),
    ( H,  x,  H,  L,  L,  x,  H ),
    ( L,  x,  x,  x,  x,  x,  S ),
    ( x,  x,  x,  x,  H,  x,  S ));

  function ADDR4_TO_INT (
      ADDRESS : in std_logic_vector(3 downto 0)
  ) return integer;
 
  function ADDR5_TO_INT (
      ADDRESS : in std_logic_vector(4 downto 0)
  ) return integer;

  function ADDR6_TO_INT (
      ADDRESS : in std_logic_vector(5 downto 0)
  ) return integer;
 
end RAM_PACKAGE;

-----------------------------------------------------------------------------
 
package body RAM_PACKAGE is
 
  function ADDR4_TO_INT (
      ADDRESS : in std_logic_vector(3 downto 0)
  ) return integer is
 
  variable I : integer;
 
  begin
    case ADDRESS is
      when "0000"  =>  I := 0;
      when "0001"  =>  I := 1;
      when "0010"  =>  I := 2;
      when "0011"  =>  I := 3;
      when "0100"  =>  I := 4;
      when "0101"  =>  I := 5;
      when "0110"  =>  I := 6;
      when "0111"  =>  I := 7;
      when "1000"  =>  I := 8;
      when "1001"  =>  I := 9;
      when "1010"  =>  I := 10;
      when "1011"  =>  I := 11;
      when "1100"  =>  I := 12;
      when "1101"  =>  I := 13;
      when "1110"  =>  I := 14;
      when "1111"  =>  I := 15;
      when others  =>  I := 0;
    end case;
    return I;
  end ADDR4_TO_INT;

  function ADDR5_TO_INT (
      ADDRESS : in std_logic_vector(4 downto 0)
  ) return integer is
 
  variable I : integer;
 
  begin
    case ADDRESS is
      when "00000"  =>  I := 0;
      when "00001"  =>  I := 1;
      when "00010"  =>  I := 2;
      when "00011"  =>  I := 3;
      when "00100"  =>  I := 4;
      when "00101"  =>  I := 5;
      when "00110"  =>  I := 6;
      when "00111"  =>  I := 7;
      when "01000"  =>  I := 8;
      when "01001"  =>  I := 9;
      when "01010"  =>  I := 10;
      when "01011"  =>  I := 11;
      when "01100"  =>  I := 12;
      when "01101"  =>  I := 13;
      when "01110"  =>  I := 14;
      when "01111"  =>  I := 15;
      when "10000"  =>  I := 16;
      when "10001"  =>  I := 17;
      when "10010"  =>  I := 18;
      when "10011"  =>  I := 19;
      when "10100"  =>  I := 20;
      when "10101"  =>  I := 21;
      when "10110"  =>  I := 22;
      when "10111"  =>  I := 23;
      when "11000"  =>  I := 24;
      when "11001"  =>  I := 25;
      when "11010"  =>  I := 26;
      when "11011"  =>  I := 27;
      when "11100"  =>  I := 28;
      when "11101"  =>  I := 29;
      when "11110"  =>  I := 30;
      when "11111"  =>  I := 31;
      when others   =>  I := 0;
    end case;
    return I;
  end ADDR5_TO_INT;

  function ADDR6_TO_INT (
      ADDRESS : in std_logic_vector(5 downto 0)
  ) return integer is
 
  variable I : integer;
 
  begin
    case ADDRESS is
      when "000000"  =>  I := 0;
      when "000001"  =>  I := 1;
      when "000010"  =>  I := 2;
      when "000011"  =>  I := 3;
      when "000100"  =>  I := 4;
      when "000101"  =>  I := 5;
      when "000110"  =>  I := 6;
      when "000111"  =>  I := 7;
      when "001000"  =>  I := 8;
      when "001001"  =>  I := 9;
      when "001010"  =>  I := 10;
      when "001011"  =>  I := 11;
      when "001100"  =>  I := 12;
      when "001101"  =>  I := 13;
      when "001110"  =>  I := 14;
      when "001111"  =>  I := 15;
      when "010000"  =>  I := 16;
      when "010001"  =>  I := 17;
      when "010010"  =>  I := 18;
      when "010011"  =>  I := 19;
      when "010100"  =>  I := 20;
      when "010101"  =>  I := 21;
      when "010110"  =>  I := 22;
      when "010111"  =>  I := 23;
      when "011000"  =>  I := 24;
      when "011001"  =>  I := 25;
      when "011010"  =>  I := 26;
      when "011011"  =>  I := 27;
      when "011100"  =>  I := 28;
      when "011101"  =>  I := 29;
      when "011110"  =>  I := 30;
      when "011111"  =>  I := 31;
      when "100000"  =>  I := 32;
      when "100001"  =>  I := 33;
      when "100010"  =>  I := 34;
      when "100011"  =>  I := 35;
      when "100100"  =>  I := 36;
      when "100101"  =>  I := 37;
      when "100110"  =>  I := 38;
      when "100111"  =>  I := 39;
      when "101000"  =>  I := 40;
      when "101001"  =>  I := 41;
      when "101010"  =>  I := 42;
      when "101011"  =>  I := 43;
      when "101100"  =>  I := 44;
      when "101101"  =>  I := 45;
      when "101110"  =>  I := 46;
      when "101111"  =>  I := 47;
      when "110000"  =>  I := 48;
      when "110001"  =>  I := 49;
      when "110010"  =>  I := 50;
      when "110011"  =>  I := 51;
      when "110100"  =>  I := 52;
      when "110101"  =>  I := 53;
      when "110110"  =>  I := 54;
      when "110111"  =>  I := 55;
      when "111000"  =>  I := 56;
      when "111001"  =>  I := 57;
      when "111010"  =>  I := 58;
      when "111011"  =>  I := 59;
      when "111100"  =>  I := 60;
      when "111101"  =>  I := 61;
      when "111110"  =>  I := 62;
      when "111111"  =>  I := 63;
      when others   =>  I := 0;
    end case;
    return I;
  end ADDR6_TO_INT;

  function FillInit256	(v : std_logic_vector)	return memory_array_typ_256 is
         variable  mem_slice : data_word_typ_18;
         variable  memory_a  : memory_array_typ_256;
      begin

      for I in 0 to 255 loop
         --  mem_slice   := v(i) & v(256+i) & v(2*256+i) & v(3*256+i) &
         --                 v(4*256+i) & v(5*256+i) & v(6*256+i) & v(7*256+i) &
         --                 v(8*256+i) & v(9*256+i) & v(10*256+i) & v(11*256+i) &
         --                 v(12*256+i) & v(13*256+i) & v(14*256+i) & v(15*256+i) &
         --                 v(16*256+i) & v(17*256+i); 
         --  mem_slice   := v(17*256+i) & v(16*256+i) & v(15*256+i) & v(14*256+i) &
         --                 v(13*256+i) & v(12*256+i) & v(11*256+i) & v(10*256+i) &
         --                 v(9*256+i) & v(8*256+i) & v(7*256+i) & v(6*256+i) &
         --                 v(5*256+i) & v(4*256+i) & v(3*256+i) & v(2*256+i) &
         --                 v(1*256+i) & v(i); 
           mem_slice   := v(255-i) & v(256+255-i) & v(2*256+255-i) & v(3*256+255-i) &
                          v(4*256+255-i) & v(5*256+255-i) & v(6*256+255-i) & v(7*256+255-i) &
                          v(8*256+255-i) & v(9*256+255-i) & v(10*256+255-i) & v(11*256+255-i) &
                          v(12*256+255-i) & v(13*256+255-i) & v(14*256+255-i) & v(15*256+255-i) &
                          v(16*256+255-i) & v(17*256+255-i); 
           memory_a(i) := mem_slice;
      end loop;
           return memory_a;
  end FillInit256;

  function FillInit512	(v : std_logic_vector)	return memory_array_typ_512 is
         variable  mem_slice : data_word_typ_9;
         variable  memory_a  : memory_array_typ_512;
      begin

      for I in 0 to 511 loop
           --mem_slice   := v(i) & v(512+i) & v(2*512+i) & v(3*512+i) &
           --               v(4*512+i) & v(5*512+i) & v(6*512+i) & v(7*512+i) &
           --               v(8*512+i); 
           --mem_slice   := v(8*512+i) & v(7*512+i) & v(6*512+i) & v(5*512+i) &
           --               v(4*512+i) & v(3*512+i) & v(2*512+i) & v(1*512+i) &
           --               v(i); 
           mem_slice   := v(511-i) & v(512+511-i) & v(2*512+511-i) & v(3*512+511-i) &
                          v(4*512+511-i) & v(5*512+511-i) & v(6*512+511-i) & v(7*512+511-i) &
                          v(8*512+511-i); 
           memory_a(i) := mem_slice;
      end loop;
           return memory_a;
  end FillInit512;

  function VEC2INT           (v: std_logic_vector) return integer is
      variable result: integer := 0;
      variable addition: integer := 1;
   begin
      for b in v'reverse_range loop
         if v (b) = '1' then
            result := result + addition;
         end if;
         addition := addition * 2;
      end loop;
      return result;
   end VEC2INT;

   function VECX              (v: std_logic_vector) return boolean is
   begin
      for b in v'range loop
         if bitX (v (b)) then
            return true;
         end if;
      end loop;
      return false;
   end VECX;

   function BITX              (v: std_logic) return boolean is
   begin
      case v is
         when 'X'    => return true;
         when others => return false;
      end case;
   end BITX;

end RAM_PACKAGE;
--------------------------end RAM_PACKAGE----------------------------------
----- VITAL model for cell B_KEEPER -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.VITAL_Timing.all;

entity B_KEEPER is
  generic( InstancePath: STRING := "*");
  port(X : inout STD_ULOGIC);
  attribute VITAL_LEVEL0 of B_KEEPER : entity is TRUE;
end B_KEEPER;

architecture VITAL of B_KEEPER is

   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   signal X_ipd : std_ulogic := 'L';

begin

   process (X)
   begin
       if (X'event) then
           if (X = '1') then
               X_ipd <= 'H';
           elsif (X = '0') then
               X_ipd <= 'L';
           end if;
       end if;
   end process;
 
   X <= X_ipd;

end VITAL;

configuration CFG_VITAL of B_KEEPER is
   for VITAL
   end for;
end CFG_VITAL;

----- VITAL model for cell SPLL -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SPLL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      IN_FREQ: STRING := "100.0";
      CLK_OUT_TO_PIN: STRING := "OFF";
      WAKE_ON_LOCK: STRING := "OFF";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SPLL : entity is FALSE;
end SPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of SPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CLK_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => CLK_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "CLK_OUT",
       OutTemp => O_zd,
       Paths => (0 => (CLK_IN_ipd'last_event, tpd_CLK_IN_CLK_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_SPLL_VITAL of SPLL is 
        for VITAL
        end for; 
end CFG_SPLL_VITAL;

----- VITAL model for cell STDPLL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library LAVA1;
use LAVA1.components.all;

-- entity declaration --
entity STDPLL is
   generic(
      IN_FREQ  : string  := "100.0";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      SECDIV   : string  := "1";
      lock_cyc : integer := 2;
      PLL_DLY  : string  := "1";
      CLK_OUT_TO_PIN  : string  := "OFF";
      WAKE_ON_LOCK  : string  := "OFF";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_IN_CLK_OUT             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tpd_CLK_IN_PLL_LOCK             :	VitalDelayType01 := (0.00 ns, 0.00 ns);
      tipd_CLK_IN             :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN                         :	in    STD_ULOGIC;
      CLK_OUT                        :	out   STD_ULOGIC;
      PLL_LOCK                       :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLL : entity is FALSE;
end STDPLL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
use LAVA1.components.all;
architecture VITAL of STDPLL is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);

  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 0.25 ns * str2real(pll_dly);

BEGIN

   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
     END IF;
     END IF;
 
  WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 THEN
        if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	          
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	END LOOP;
      else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
      end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
end process;

process
begin
   wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1) then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay;

    PLL_LOCK <= PLL_LOCK_plus when tpd >= 0 ns else
                PLL_LOCK_minus;
               


end VITAL;

configuration CFG_STDPLL_VITAL of STDPLL is 
        for VITAL
        end for; 
end CFG_STDPLL_VITAL;

----- VITAL model for cell STDPLLX -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
library LAVA1;
use LAVA1.components.all;

-- entity declaration --
entity STDPLLX is
   generic(
      IN_FREQ  : string  := "100.0";
      CLK_OUT_TO_PIN  : string  := "OFF";
      WAKE_ON_LOCK  : string  := "OFF";
      PLL_FBK_ATTRIBUTE : string := "CLKTREE";
      MULT     : string  := "1";
      DIV      : string  := "1";
      POST     : string  := "1";
      LOCK_CYC : integer := 2;
      SECDIV   : string   := "1";
      PLL_DLY  : string  := "1";
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_PLL_RST_PLL_LOCK :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_CLK_OUT :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_PLL_LOCK :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_CLK_IN_SEC_OUT :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_CLK_IN    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_FBK   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PLL_RST   :	VitalDelayType01 := (0.000 ns, 0.000 ns));
   port(
      CLK_IN            : in    STD_ULOGIC;
      PLL_FBK           : in    STD_ULOGIC;
      PLL_RST           : in    STD_ULOGIC := '0';
      CLK_OUT           : out   STD_ULOGIC;
      SEC_OUT           : out   STD_ULOGIC;
      PLL_LOCK          : out   STD_ULOGIC);
attribute VITAL_LEVEL0 of STDPLLX : entity is FALSE;
end STDPLLX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
use LAVA1.components.all;


architecture VITAL of STDPLLX is
  attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

  SIGNAL CLK_IN_ipd	 : STD_ULOGIC := 'X';
  SIGNAL PLL_RST_ipd	 : STD_ULOGIC := 'X';

  CONSTANT input_frequency : REAL := str2real(in_freq);
  SIGNAL start_inclk : STD_LOGIC ;
  SIGNAL clklock_half_period : TIME :=100 ns;
  SIGNAL clklock_half_period1 : TIME :=100 ns;
  SIGNAL clklock_half_period0 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly1 : TIME :=100 ns;
  SIGNAL clklock_half_period_minus_dly0 : TIME :=100 ns;
  SIGNAL secd_delay_minus1 : TIME :=100 ns;
  SIGNAL secd_delay_minus0 : TIME :=100 ns;
  SIGNAL clklock_rising_edge_count : INTEGER := 0 ;
  SIGNAL clklock_falling_edge_count : INTEGER := 0 ;
  SIGNAL clklock_last_rising_edge : TIME ;
  SIGNAL clklock_last_falling_edge : TIME ;

  SIGNAL clock_count : INTEGER := -1 ;
  SIGNAL clklock_lock : BOOLEAN := TRUE;
  SIGNAL CLK_OUT_sig_d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_not  : std_logic := '0';
  SIGNAL CLK_OUT_sig_3d  : std_logic := '0';
  SIGNAL CLK_OUT_sig_d_start  : std_logic := '0';
  SIGNAL CLK_OUT_start  : std_logic := '0';
  SIGNAL CLK_OUT_plus_delay : std_logic := '0';
  SIGNAL SEC_OUT_sig_d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_not  : std_logic := '0';
  SIGNAL SEC_OUT_sig_3d  : std_logic := '0';
  SIGNAL SEC_OUT_sig_d_start  : std_logic := '0';
  SIGNAL SEC_OUT_start  : std_logic := '0';
  SIGNAL SEC_OUT_plus_delay : std_logic := '0';
  SIGNAL CLK_OUT_sig1 : std_logic := '0';
  SIGNAL PLL_LOCK_plus : std_logic := '0';
  SIGNAL PLL_LOCK_minus : std_logic := '0';

  CONSTANT secdiv_p: integer := str2int(secdiv);
  CONSTANT clockboost: integer := str2int(mult) / str2int(div);
  CONSTANT tpd: time := 0.25 ns * str2int(pll_dly);
  SIGNAL  PLL_RST_int  : STD_LOGIC;

BEGIN
   PLL_RST_int <= PLL_RST_ipd WHEN (PLL_RST_ipd = '0' or PLL_RST_ipd = '1') else
                  '0';
   WireDelay : block
   begin
   VitalWireDelay (CLK_IN_ipd, CLK_IN, tipd_CLK_IN);
   VitalWireDelay (PLL_RST_ipd, PLL_RST, tipd_PLL_RST);
   end block;

edge_count: PROCESS
     VARIABLE input_cycle : REAL;
     VARIABLE real_cycle : REAL;
BEGIN
       clklock_half_period <= (clklock_half_period0 + clklock_half_period1)/2;

   WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='1');	   
     clklock_rising_edge_count <= clklock_rising_edge_count +1;
     IF clklock_rising_edge_count = 0 THEN
        clklock_last_rising_edge <= NOW;	
	start_inclk <= CLK_IN_ipd;
     ELSE
     IF clklock_rising_edge_count = 1 THEN
       clklock_half_period0 <= (NOW - clklock_last_falling_edge)* real(str2int(div))/real(str2int(mult));
	input_cycle := 1000.0 / input_frequency;
	real_cycle := REAL( (NOW - clklock_last_rising_edge) / 1 ns);
	IF ( real_cycle < 0.9 * input_cycle OR
	     real_cycle > 1.1 * input_cycle ) THEN
  	      	ASSERT TRUE 
  		REPORT " Input_Frequency Violation "
  		SEVERITY WARNING;
  		clklock_lock <= FALSE;
        END IF;
       clklock_half_period_minus_dly0 <= (NOW - clklock_last_falling_edge) + tpd;
        secd_delay_minus0 <= clklock_half_period0 * secdiv_p + tpd;
     END IF;
     END IF;
 
   WAIT UNTIL (CLK_IN_ipd'EVENT AND CLK_IN_ipd='0');
     clklock_falling_edge_count <= clklock_falling_edge_count +1;	  	
     IF clklock_falling_edge_count = 0 THEN	
	clklock_last_falling_edge <= NOW;
	clklock_half_period1 <= (NOW - clklock_last_rising_edge)* real(str2int(div))/real(str2int(mult)); 
     ELSIF clklock_falling_edge_count = 1 THEN
        clklock_half_period_minus_dly1 <= (NOW - clklock_last_rising_edge) + tpd;
        secd_delay_minus1 <= clklock_half_period1 * secdiv_p + tpd;
     END IF;
END PROCESS edge_count;

toggle: PROCESS
BEGIN

     WAIT ON clklock_rising_edge_count;
     IF clklock_rising_edge_count > lock_cyc + 1 and PLL_RST_int ='0' THEN
         if(clockboost >1) then
	   FOR i IN 1 TO (2*clockboost) LOOP 	        
		clock_count <= clock_count + 1;
		WAIT FOR clklock_half_period;
	   END LOOP;
        else  
		clock_count <= clock_count + 1;
		WAIT FOR (clklock_half_period);
        end if;
     ELSE
	clock_count <= 0;
     END IF;
END PROCESS toggle;


gen_pll_lock_plus:process
begin
     wait until (clock_count=1);
          PLL_LOCK_plus <= '1';
end process;

gen_pll_lock_minus:process
begin
     wait until (clock_count=3);
          PLL_LOCK_minus <= '1';
end process;

process
begin 
    wait until clock_count = 1;
    CLK_OUT_sig_d_start <='1';
    SEC_OUT_sig_d_start <='1';
end process;

process
begin
    wait until CLK_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not;
     wait for clklock_half_period0;
   CLK_OUT_sig_d_not <= not CLK_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if (clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_int = '0') then
       CLK_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  CLK_OUT_start = '1'; LOOP
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d;
     wait for clklock_half_period1;
      CLK_OUT_sig_3d <= not CLK_OUT_sig_3d ;
     wait for clklock_half_period0;
     END LOOP;
end process;

process
begin
   wait until SEC_OUT_sig_d_start = '1'; LOOP
     wait for clklock_half_period1 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not;
     wait for clklock_half_period0 * secdiv_p;
   SEC_OUT_sig_d_not <= not SEC_OUT_sig_d_not ;
   END LOOP;
end process;

process(clklock_falling_edge_count)
begin
   if(clklock_falling_edge_count >= lock_cyc + 1 and PLL_RST_int = '0') then
        SEC_OUT_start <= '1' after clklock_half_period_minus_dly0;
   end if;
end process;

process
begin
   wait until  SEC_OUT_start = '1'; LOOP
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d;
     wait for clklock_half_period1 * secdiv_p;
      SEC_OUT_sig_3d <= not SEC_OUT_sig_3d ;
     wait for clklock_half_period0 * secdiv_p;
     END LOOP;
end process;

    CLK_OUT_sig_d <= CLK_OUT_sig_d_start and not CLK_OUT_sig_d_not; 

    CLK_OUT_plus_delay <= CLK_OUT_sig_d after tpd when tpd >= 0 ns else
                          CLK_OUT_sig_3d; 

    CLK_OUT <= CLK_OUT_plus_delay and not PLL_RST_int;

    PLL_LOCK <= PLL_LOCK_plus and not PLL_RST_int when tpd >= 0 ns else
                PLL_LOCK_minus and  not PLL_RST_int;

    SEC_OUT_sig_d <= SEC_OUT_sig_d_start and not SEC_OUT_sig_d_not; 

    SEC_OUT_plus_delay <= SEC_OUT_sig_d after tpd when tpd >= 0 ns else
                          SEC_OUT_sig_3d; 

    SEC_OUT <= SEC_OUT_plus_delay and not PLL_RST_int;

end VITAL;

configuration CFG_STDPLLX_VITAL of STDPLLX is 
        for VITAL
        end for; 
end CFG_STDPLLX_VITAL;

----- VITAL model for cell DFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity DFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFF : entity is TRUE;
end DFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFF is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFF",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFF_VITAL of DFF is 
        for VITAL
        end for; 
end CFG_DFF_VITAL;


----- VITAL model for cell DFF_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFF_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFF_1 : entity is TRUE;
end DFF_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFF_1 is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY;  

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFF_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFF_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

      CLK_inverted := (NOT CLK_dly);
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_inverted, R,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFF_1_VITAL of DFF_1 is 
        for VITAL
        end for; 
end CFG_DFF_1_VITAL;


----- VITAL model for cell DFFCB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge        :	VitalDelayType := 4.400 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCB : entity is TRUE;
end DFFCB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCB is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCB",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCB",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          HeaderMsg               => InstancePath & "/DFFCB",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_dly, R,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCB_VITAL of DFFCB is 
        for VITAL
        end for; 
end CFG_DFFCB_VITAL;



----- VITAL model for cell DFFCB_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCB_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      R_DELAY : TIME := 2 ns;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge        :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCB_1 : entity is TRUE;
end DFFCB_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCB_1 is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R              : STD_ULOGIC := '0';

begin

   R <= '1' after R_DELAY; 

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCB_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_negedge,
          TimingData              => Tmkr_CE_CLK_negedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_negedge,
          SetupLow                => tsetup_CE_CLK_noedge_negedge,
          HoldHigh                => thold_CE_CLK_noedge_negedge,
          HoldLow                 => thold_CE_CLK_noedge_negedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCB_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          HeaderMsg               => InstancePath & "/DFFCB_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      CLK_inverted := (NOT CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_negedge or Tviol_CE_CLK_negedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_inverted, R, '1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCB_1_VITAL of DFFCB_1 is 
        for VITAL
        end for; 
end CFG_DFFCB_1_VITAL;

----- VITAL model for cell DFFCBR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBR : entity is TRUE;
end DFFCBR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((R_CLK_dly) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((R_CLK_dly) AND NOT (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCBR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_posedge or Tviol_CE_CLK_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_CLK_dly,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBR_VITAL of DFFCBR is 
        for VITAL
        end for; 
end CFG_DFFCBR_VITAL;

----- VITAL model for cell DFFCBRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge 		:	VitalDelayType := 0.000 ns;
      tpw_R_posedge 		:	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBRH : entity is TRUE;
end DFFCBRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd		 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R				: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R				: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_R_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFCBRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND NOT (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCBRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_posedge or Tviol_CE_CLK_posedge or Tviol_R_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_dly,R_inverted,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBRH_VITAL of DFFCBRH is 
        for VITAL
        end for; 
end CFG_DFFCBRH_VITAL;


----- VITAL model for cell DFFCBRH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBRH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge 		:	VitalDelayType := 0.000 ns;
      tpw_R_negedge 		:	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_negedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBRH_1 : entity is TRUE;
end DFFCBRH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBRH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R				: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R				: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_negedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_negedge,
          TimingData              => Tmkr_CE_CLK_negedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_negedge,
          SetupLow                => tsetup_CE_CLK_noedge_negedge,
          HoldHigh                => thold_CE_CLK_noedge_negedge,
          HoldLow                 => thold_CE_CLK_noedge_negedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_negedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_negedge,
          Removal                 => thold_R_CLK_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_R_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath & "/DFFCBRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND NOT (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCBRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_negedge or Tviol_CE_CLK_negedge or Tviol_R_CLK_CE_EQ_1_negedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      CLK_inverted := (NOT CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_inverted,R_inverted,'1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBRH_1_VITAL of DFFCBRH_1 is 
        for VITAL
        end for; 
end CFG_DFFCBRH_1_VITAL;


----- VITAL model for cell DFFCBSRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBSRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SR_CLK_noedge_posedge   :	VitalDelayType := 0.100 ns;
      thold_SR_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge   :  VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SR_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SR                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CE                             :	in    STD_ULOGIC;
      SR                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBSRH : entity is TRUE;
end DFFCBSRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBSRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SR_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SR_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SR_ipd, SR, tipd_SR);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SR_CLK_dly, SR_ipd, tisd_SR_CLK);

   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, SR_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SR_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SR_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SR_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_SR_CLK_CE_EQ_1_posedge,
          TestSignal              => SR_CLK_dly,
          TestSignalName          => "SR",
          TestDelay               => tisd_SR_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SR_CLK_noedge_posedge,
          SetupLow                => tsetup_SR_CLK_noedge_posedge,
          HoldHigh                => thold_SR_CLK_noedge_posedge,
          HoldLow                 => thold_SR_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          HeaderMsg               => InstancePath &"/DFFCBSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalAND2(NOT(SR_CLK_dly) ,  D_CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_in_zd, CLK_dly, '1','1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBSRH_VITAL of DFFCBSRH is 
        for VITAL
        end for; 
end CFG_DFFCBSRH_VITAL;

----- VITAL model for cell DFFCBSRH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBSRH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SR_CLK_noedge_negedge   :	VitalDelayType := 0.100 ns;
      thold_SR_CLK_noedge_negedge    :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_negedge   :VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_negedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SR_CLK                    :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                    :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SR                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CE                             :	in    STD_ULOGIC;
      SR                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBSRH_1 : entity is TRUE;
end DFFCBSRH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBSRH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SR_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SR_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SR_ipd, SR, tipd_SR);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SR_CLK_dly, SR_ipd, tisd_SR_CLK);

   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, SR_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SR_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SR_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SR_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_SR_CLK_CE_EQ_1_negedge,
          TestSignal              => SR_CLK_dly,
          TestSignalName          => "SR",
          TestDelay               => tisd_SR_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SR_CLK_noedge_negedge,
          SetupLow                => tsetup_SR_CLK_noedge_negedge,
          HoldHigh                => thold_SR_CLK_noedge_negedge,
          HoldLow                 => thold_SR_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_negedge,
          TimingData              => Tmkr_CE_CLK_negedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_negedge,
          SetupLow                => tsetup_CE_CLK_noedge_negedge,
          HoldHigh                => thold_CE_CLK_noedge_negedge,
          HoldLow                 => thold_CE_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          HeaderMsg               => InstancePath &"/DFFCBSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      CLK_inverted := NOT(CLK_dly);
      D_in_zd := VitalAND2(NOT(SR_CLK_dly) ,  D_CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_negedge or Tviol_CE_CLK_negedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_in_zd, CLK_inverted, '1','1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBSRH_1_VITAL of DFFCBSRH_1 is 
        for VITAL
        end for; 
end CFG_DFFCBSRH_1_VITAL;

----- VITAL model for cell DFFCBSSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBSSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SS_CLK_noedge_posedge   :	VitalDelayType := 0.100 ns;
      thold_SS_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge   :  VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SS_CLK                    :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                    :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CE                             :	in    STD_ULOGIC;
      SS                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBSSH : entity is TRUE;
end DFFCBSSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBSSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SS_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SS_ipd, SS, tipd_SS);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SS_CLK_dly, SS_ipd, tisd_SS_CLK);

   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, SS_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SS_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SS_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SS_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_SS_CLK_CE_EQ_1_posedge,
          TestSignal              => SS_CLK_dly,
          TestSignalName          => "SS",
          TestDelay               => tisd_SS_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SS_CLK_noedge_posedge,
          SetupLow                => tsetup_SS_CLK_noedge_posedge,
          HoldHigh                => thold_SS_CLK_noedge_posedge,
          HoldLow                 => thold_SS_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          HeaderMsg               => InstancePath &"/DFFCBSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalOR2(SS_CLK_dly ,  D_CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_in_zd, CLK_dly, '1','1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBSSH_VITAL of DFFCBSSH is 
        for VITAL
        end for; 
end CFG_DFFCBSSH_VITAL;



----- VITAL model for cell DFFCBSSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBSSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SS_CLK_noedge_negedge   :	VitalDelayType := 0.100 ns;
      thold_SS_CLK_noedge_negedge    :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_negedge   :  VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_negedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SS_CLK                    :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                    :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CE                             :	in    STD_ULOGIC;
      SS                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBSSH_1 : entity is TRUE;
end DFFCBSSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBSSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SS_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SS_ipd, SS, tipd_SS);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SS_CLK_dly, SS_ipd, tisd_SS_CLK);

   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, SS_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SS_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SS_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SS_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_SS_CLK_CE_EQ_1_negedge,
          TestSignal              => SS_CLK_dly,
          TestSignalName          => "SS",
          TestDelay               => tisd_SS_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SS_CLK_noedge_negedge,
          SetupLow                => tsetup_SS_CLK_noedge_negedge,
          HoldHigh                => thold_SS_CLK_noedge_negedge,
          HoldLow                 => thold_SS_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_negedge,
          TimingData              => Tmkr_CE_CLK_negedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_negedge,
          SetupLow                => tsetup_CE_CLK_noedge_negedge,
          HoldHigh                => thold_CE_CLK_noedge_negedge,
          HoldLow                 => thold_CE_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) ='0',
          HeaderMsg               => InstancePath &"/DFFCBSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      CLK_inverted := NOT(CLK_dly);
      D_in_zd := VitalOR2(SS_CLK_dly ,  D_CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_negedge or Tviol_CE_CLK_negedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_in_zd, CLK_inverted, '1','1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBSSH_1_VITAL of DFFCBSSH_1 is 
        for VITAL
        end for; 
end CFG_DFFCBSSH_1_VITAL;



----- VITAL model for cell DFFCBRSS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DFFCBRSS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBRSS : entity is TRUE;
end DFFCBRSS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBRSS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_ANB_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE D_int : STD_ULOGIC ;
   VARIABLE S_inverted : STD_ULOGIC ;
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((R_CLK_dly) AND NOT (CE_ipd) AND (S_CLK_dly)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TO_X01((S_CLK_dly) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_ANB_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TO_X01((R_CLK_dly) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((R_CLK_dly) AND NOT (CE_ipd) AND (S_CLK_dly)) = '1',
          HeaderMsg               => InstancePath & "/DFFCBRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1_posedge or Tviol_CE_CLK_posedge or Tviol_R_CLK_CE_EQ_1_ANB_S_EQ_1_posedge or Tviol_S_CLK_CE_EQ_1_ANB_R_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_1_ANB_S_EQ_1;
      S_inverted := VitalINV (S_CLK_dly);
      D_int := VitalOR2 (D_CLK_dly,S_inverted);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_int, CLK_dly, R_CLK_dly, '1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBRSS_VITAL of DFFCBRSS is 
        for VITAL
        end for; 
end CFG_DFFCBRSS_VITAL;

----- VITAL model for cell DFFCBRSSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBRSSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tpw_R_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBRSSH : entity is TRUE;
end DFFCBRSSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBRSSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_ANB_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE D_int : STD_ULOGIC := '0';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND NOT (CE_ipd) AND ((NOT S_CLK_dly))) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_ANB_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_S_CLK_noedge_posedge,
          SetupLow                => tsetup_S_CLK_noedge_posedge,
          HoldHigh                => thold_S_CLK_noedge_posedge,
          HoldLow                 => thold_S_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCBRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(((NOT R_CLK_dly)) AND (NOT (CE_ipd)) AND ((NOT S_CLK_dly))) = '1',
          HeaderMsg               => InstancePath & "/DFFCBRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0_posedge or Tviol_CE_CLK_posedge or Tviol_R_CLK_CE_EQ_1_ANB_S_EQ_0_posedge or Tviol_S_CLK_CE_EQ_1_ANB_R_EQ_0_posedge or Pviol_CLK_CE_EQ_1_ANB_R_EQ_0_ANB_S_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      D_int := VitalOR2 (D_CLK_dly,S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_int, CLK_dly, R_inverted, '1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBRSSH_VITAL of DFFCBRSSH is 
        for VITAL
        end for; 
end CFG_DFFCBRSSH_VITAL;

----- VITAL model for cell DFFCBS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBS : entity is TRUE;
end DFFCBS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((S_CLK_dly) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_posedge_posedge,
          SetupLow                => tsetup_CE_CLK_posedge_posedge,
          HoldHigh                => thold_CE_CLK_posedge_posedge,
          HoldLow                 => thold_CE_CLK_posedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((S_CLK_dly) AND NOT (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCBS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_1_posedge or Tviol_CE_CLK_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1',S_CLK_dly, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBS_VITAL of DFFCBS is 
        for VITAL
        end for; 
end CFG_DFFCBS_VITAL;

----- VITAL model for cell DFFCBSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tpw_S_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBSH : entity is TRUE;
end DFFCBSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCBSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND NOT (CE_ipd)) = '0',
          HeaderMsg               => InstancePath & "/DFFCBSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_posedge or Tviol_CE_CLK_posedge or Tviol_S_CLK_CE_EQ_1_posedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_dly,'1', S_inverted, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBSH_VITAL of DFFCBSH is 
        for VITAL
        end for; 
end CFG_DFFCBSH_VITAL;


----- VITAL model for cell DFFCBSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_CE_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge :	VitalDelayType := 0.000 ns;
      tpw_S_negedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_negedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBSH_1 : entity is TRUE;
end DFFCBSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, S_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_negedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_ANB_S_EQ_0_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND NOT (CE_ipd)) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_negedge,
          TimingData              => Tmkr_CE_CLK_negedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_negedge,
          SetupLow                => tsetup_CE_CLK_noedge_negedge,
          HoldHigh                => thold_CE_CLK_noedge_negedge,
          HoldLow                 => thold_CE_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_S_CLK_CE_EQ_1_negedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_negedge,
          Removal                 => thold_S_CLK_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFCBSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_CE_EQ_1_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND NOT (CE_ipd)) = '1',
          HeaderMsg               => InstancePath & "/DFFCBSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_CE_EQ_1_ANB_S_EQ_0_negedge or Tviol_CE_CLK_negedge or Tviol_S_CLK_CE_EQ_1_negedge or Pviol_CLK_CE_EQ_1_ANB_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_CLK_dly);
      CLK_inverted := (NOT CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_CLK_dly, CLK_inverted,'1', S_inverted, CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBSH_1_VITAL of DFFCBSH_1 is 
        for VITAL
        end for; 
end CFG_DFFCBSH_1_VITAL;


----- VITAL model for cell DFFR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFR : entity is TRUE;
end DFFR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((R_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_1_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
              D_CLK_dly, CLK_dly, R_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFR_VITAL of DFFR is 
        for VITAL
        end for; 
end CFG_DFFR_VITAL;

----- VITAL model for cell DFFRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 0.000 ns;
      tpw_R_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRH : entity is TRUE;
end DFFRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_posedge,
          TimingData              => Tmkr_R_CLK_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_0_posedge or Tviol_R_CLK_posedge or Pviol_CLK_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, R_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRH_VITAL of DFFRH is 
        for VITAL
        end for; 
end CFG_DFFRH_VITAL;



----- VITAL model for cell DFFRH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFRH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge         :	VitalDelayType := 0.000 ns;
      tpw_R_negedge         :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge             :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRH_1 : entity is TRUE;
end DFFRH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFRH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_negedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01((R_CLK_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_negedge,
          TimingData              => Tmkr_R_CLK_negedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_negedge,
          Removal                 => thold_R_CLK_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(R_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_R_EQ_0_negedge or Tviol_R_CLK_negedge or Pviol_CLK_R_EQ_0 or Pviol_R;
      R_inverted := (NOT R_CLK_dly);
      CLK_inverted := (NOT CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dff_1tab,
        DataIn => (
               D_CLK_dly, CLK_inverted, R_inverted, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRH_1_VITAL of DFFRH_1 is 
        for VITAL
        end for; 
end CFG_DFFRH_1_VITAL;


----- VITAL model for cell DFFSRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SR_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_SR_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SR_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SR                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SR                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSRH : entity is TRUE;
end DFFSRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFSRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SR_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SR_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SR_ipd, SR, tipd_SR);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SR_CLK_dly, SR_ipd, tisd_SR_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, SR_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFFSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalAND2 (NOT(SR_CLK_dly) , D_CLK_dly);
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_in_zd, CLK_dly, '1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSRH_VITAL of DFFSRH is 
        for VITAL
        end for; 
end CFG_DFFSRH_VITAL;


----- VITAL model for cell DFFSRH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSRH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SR_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_SR_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SR_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SR                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SR                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSRH_1 : entity is TRUE;
end DFFSRH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFSRH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SR_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SR_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SR_ipd, SR, tipd_SR);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SR_CLK_dly, SR_ipd, tisd_SR_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, SR_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFFSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalAND2(NOT(SR_CLK_dly), D_CLK_dly);
      CLK_inverted := (NOT CLK_dly);
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_in_zd, CLK_inverted, '1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSRH_1_VITAL of DFFSRH_1 is 
        for VITAL
        end for; 
end CFG_DFFSRH_1_VITAL;



----- VITAL model for cell DFFRSS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DFFRSS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge  :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRSS : entity is TRUE;
end DFFRSS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFRSS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_1_ANB_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_1_ANB_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_1_ANB_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_1_ANB_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE NOT_S_zd : STD_ULOGIC := '0';
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_1_ANB_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_1_ANB_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((S_CLK_dly) AND (R_CLK_dly)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_1_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_posedge_posedge,
          Removal                 => thold_R_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_R_EQ_1_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_1_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TO_X01(R_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_1_ANB_S_EQ_1,
          PeriodData              => PInfo_CLK_R_EQ_1_ANB_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(( (S_CLK_dly) ) AND ( (R_CLK_dly) )) = '1',
          HeaderMsg               => InstancePath & "/DFFRSS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        NOT_S_zd := VitalINV (S_CLK_dly);
        D_in_zd := VitalOR2 (NOT_S_zd , D_CLK_dly);

      Violation := Tviol_D_CLK_R_EQ_1_ANB_S_EQ_1_posedge or Tviol_R_CLK_S_EQ_1_posedge or Tviol_S_CLK_R_EQ_1_posedge or Pviol_CLK_R_EQ_1_ANB_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_in_zd, CLK_dly, R_CLK_dly, '1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRSS_VITAL of DFFRSS is 
        for VITAL
        end for; 
end CFG_DFFRSS_VITAL;

----- VITAL model for cell DFFRSSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFRSSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge :	VitalDelayType := 0.000 ns;
      tpw_R_posedge :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge  :	VitalDelayType := 0.000 ns;
      trecovery_R_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_CLK_negedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_S_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_R_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFRSSH : entity is TRUE;
end DFFRSSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFRSSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (R_ipd, R, tipd_R);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (R_CLK_dly, R_ipd, tisd_R_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, R_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_R_EQ_0_ANB_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_R_EQ_0_ANB_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_R_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_R_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_R_EQ_0_ANB_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_R	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_R_EQ_0_ANB_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_R	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';


   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_R_EQ_0_ANB_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_R_EQ_0_ANB_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_R_CLK_S_EQ_0_posedge,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_R_CLK_negedge_posedge,
          Removal                 => thold_R_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TO_X01((NOT S_CLK_dly)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_S_CLK_R_EQ_0_posedge,
          TimingData              => Tmkr_S_CLK_R_EQ_0_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_S_CLK_noedge_posedge,
          SetupLow                => tsetup_S_CLK_noedge_posedge,
          HoldHigh                => thold_S_CLK_noedge_posedge,
          HoldLow                 => thold_S_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((NOT R_CLK_dly)) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_R,
          PeriodData              => PInfo_R,
          TestSignal              => R_CLK_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_R_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_R_EQ_0_ANB_S_EQ_0,
          PeriodData              => PInfo_CLK_R_EQ_0_ANB_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(((NOT S_CLK_dly)) AND ((NOT R_CLK_dly))) = '1',
          HeaderMsg               => InstancePath & "/DFFRSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------

        D_in_zd := VitalOR2 (S_CLK_dly , D_CLK_dly);

      Violation := Tviol_D_CLK_R_EQ_0_ANB_S_EQ_0_posedge or Tviol_S_CLK_R_EQ_0_posedge or Pviol_CLK_R_EQ_0_ANB_S_EQ_0 or Tviol_R_CLK_S_EQ_0_posedge or Pviol_R;
      S_inverted := (NOT S_CLK_dly);
      R_inverted := (NOT R_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_in_zd, CLK_dly, R_inverted, '1' ));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (R_CLK_dly'last_event, tpd_R_Q, TRUE),
                 1 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 2 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFRSSH_VITAL of DFFRSSH is 
        for VITAL
        end for; 
end CFG_DFFRSSH_VITAL;

----- VITAL model for cell DFFS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_posedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_posedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFS : entity is TRUE;
end DFFS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(S_CLK_dly) = '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_posedge_posedge,
          Removal                 => thold_S_CLK_posedge_posedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_1,
          PeriodData              => PInfo_CLK_S_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((S_CLK_dly) ) = '1',
          HeaderMsg               => InstancePath & "/DFFS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_1_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFS_VITAL of DFFS is 
        for VITAL
        end for; 
end CFG_DFFS_VITAL;

----- VITAL model for cell DFFSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge         :	VitalDelayType := 0.000 ns;
      tpw_S_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSH : entity is TRUE;
end DFFSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_0_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_0_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_0_posedge,
          TimingData              => Tmkr_D_CLK_S_EQ_0_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_posedge,
          TimingData              => Tmkr_S_CLK_posedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_posedge,
          Removal                 => thold_S_CLK_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_0_posedge or Tviol_S_CLK_posedge or Pviol_CLK_S_EQ_0;
      S_inverted := (NOT S_CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_dly, '1', S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSH_VITAL of DFFSH is 
        for VITAL
        end for; 
end CFG_DFFSH_VITAL;


----- VITAL model for cell DFFSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge         :	VitalDelayType := 0.000 ns;
      tpw_S_negedge         :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge             :	VitalDelayType := 0.000 ns;
      trecovery_S_CLK_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_CLK_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_S_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSH_1 : entity is TRUE;
end DFFSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (S_CLK_dly, S_ipd, tisd_S_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, S_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_S_EQ_0_negedge,
          TimingData              => Tmkr_D_CLK_S_EQ_0_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01((S_CLK_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_CLK_negedge,
          TimingData              => Tmkr_S_CLK_negedge,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          Recovery                => trecovery_S_CLK_negedge_negedge,
          Removal                 => thold_S_CLK_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_CLK_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_CLK,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_negedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DFFSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_S_EQ_0,
          PeriodData              => PInfo_CLK_S_EQ_0,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(S_CLK_dly ) = '0',
          HeaderMsg               => InstancePath & "/DFFSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK_S_EQ_0_negedge or Tviol_S_CLK_negedge or Pviol_CLK_S_EQ_0;
      S_inverted := (NOT S_CLK_dly);
      CLK_inverted := (NOT CLK_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_CLK_dly, CLK_inverted, '1', S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (S_CLK_dly'last_event, tpd_S_Q, TRUE),
                 1 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSH_1_VITAL of DFFSH_1 is 
        for VITAL
        end for; 
end CFG_DFFSH_1_VITAL;


----- VITAL model for cell DFFSSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SS_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_SS_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SS_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SS                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSSH : entity is TRUE;
end DFFSSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFSSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SS_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SS_ipd, SS, tipd_SS);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SS_CLK_dly, SS_ipd, tisd_SS_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, SS_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFFSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalOR2(SS_CLK_dly, D_CLK_dly);
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_in_zd, CLK_dly, '1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSSH_VITAL of DFFSSH is 
        for VITAL
        end for; 
end CFG_DFFSSH_VITAL;



----- VITAL model for cell DFFSSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFSSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SS_CLK_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_SS_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SS_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SS                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFSSH_1 : entity is TRUE;
end DFFSSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFSSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SS_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SS_ipd, SS, tipd_SS);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SS_CLK_dly, SS_ipd, tisd_SS_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, SS_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE CLK_inverted : STD_ULOGIC := 'X';
   VARIABLE D_in_zd : STD_ULOGIC := '1';
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFFSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalOR2(SS_CLK_dly, D_CLK_dly);
      CLK_inverted := (NOT CLK_dly);
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_in_zd, CLK_inverted, '1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFSSH_1_VITAL of DFFSSH_1 is 
        for VITAL
        end for; 
end CFG_DFFSSH_1_VITAL;




----- VITAL model for cell DFFLSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFLSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SD_CLK_noedge_posedge   :	VitalDelayType := 0.100 ns;
      thold_SD_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tsetup_LD_CLK_noedge_posedge   :	VitalDelayType := 0.100 ns;
      thold_LD_CLK_noedge_posedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SD_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_LD_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LD                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFLSH : entity is TRUE;
end DFFLSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFLSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SD_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL LD_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (LD_ipd, LD, tipd_LD);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SD_CLK_dly, SD_ipd, tisd_SD_CLK);
   VitalSignalDelay (LD_CLK_dly, LD_ipd, tisd_LD_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, SD_CLK_dly, LD_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SD_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tviol_LD_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_LD_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SD_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_SD_MUX : STD_ULOGIC := 'X';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_posedge,
          TimingData              => Tmkr_D_CLK_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SD_CLK_posedge,
          TimingData              => Tmkr_SD_CLK_posedge,
          TestSignal              => SD_CLK_dly,
          TestSignalName          => "SD",
          TestDelay               => tisd_SD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SD_CLK_noedge_posedge,
          SetupLow                => tsetup_SD_CLK_noedge_posedge,
          HoldHigh                => thold_SD_CLK_noedge_posedge,
          HoldLow                 => thold_SD_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_LD_CLK_posedge,
          TimingData              => Tmkr_LD_CLK_posedge,
          TestSignal              => LD_CLK_dly,
          TestSignalName          => "LD",
          TestDelay               => tisd_LD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_LD_CLK_noedge_posedge,
          SetupLow                => tsetup_LD_CLK_noedge_posedge,
          HoldHigh                => thold_LD_CLK_noedge_posedge,
          HoldLow                 => thold_LD_CLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFFLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_SD_MUX := VitalMUX2
		     (data0 => D_CLK_dly, 
		      data1 => SD_CLK_dly,
		      dselect => LD_CLK_dly);
      Violation := Tviol_D_CLK_posedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_SD_MUX, CLK_dly, '1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFLSH_VITAL of DFFLSH is 
        for VITAL
        end for; 
end CFG_DFFLSH_VITAL;

----- VITAL model for cell DFFLSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFLSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge    :	VitalDelayType := 0.200 ns;
      thold_D_CLK_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SD_CLK_noedge_negedge   :	VitalDelayType := 0.200 ns;
      thold_SD_CLK_noedge_negedge    :	VitalDelayType := 0.000 ns;
      tsetup_LD_CLK_noedge_negedge   :	VitalDelayType := 0.200 ns;
      thold_LD_CLK_noedge_negedge    :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge                :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SD_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_LD_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LD                             :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFLSH_1 : entity is TRUE;
end DFFLSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFLSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SD_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL LD_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (LD_ipd, LD, tipd_LD);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SD_CLK_dly, SD_ipd, tisd_SD_CLK);
   VitalSignalDelay (LD_CLK_dly, LD_ipd, tisd_LD_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CLK_dly, D_CLK_dly, SD_CLK_dly, LD_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SD_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tviol_LD_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_LD_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SD_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_SD_MUX : STD_ULOGIC := 'X';
   VARIABLE CLK_inverted : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_negedge,
          TimingData              => Tmkr_D_CLK_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SD_CLK_negedge,
          TimingData              => Tmkr_SD_CLK_negedge,
          TestSignal              => SD_CLK_dly,
          TestSignalName          => "SD",
          TestDelay               => tisd_SD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SD_CLK_noedge_negedge,
          SetupLow                => tsetup_SD_CLK_noedge_negedge,
          HoldHigh                => thold_SD_CLK_noedge_negedge,
          HoldLow                 => thold_SD_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_LD_CLK_negedge,
          TimingData              => Tmkr_LD_CLK_negedge,
          TestSignal              => LD_CLK_dly,
          TestSignalName          => "LD",
          TestDelay               => tisd_LD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_LD_CLK_noedge_negedge,
          SetupLow                => tsetup_LD_CLK_noedge_negedge,
          HoldHigh                => thold_LD_CLK_noedge_negedge,
          HoldLow                 => thold_LD_CLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK,
          PeriodData              => PInfo_CLK,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DFFLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      CLK_inverted := VitalINV(CLK_dly);
      D_SD_MUX := VitalMUX2
		     (data0 => D_CLK_dly, 
		      data1 => SD_CLK_dly,
		      dselect => LD_CLK_dly);
      Violation := Tviol_D_CLK_negedge or Pviol_CLK;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dfftab,
        DataIn => (
               D_SD_MUX, CLK_inverted, '1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFLSH_1_VITAL of DFFLSH_1 is 
        for VITAL
        end for; 
end CFG_DFFLSH_1_VITAL;

----- VITAL model for cell DFFCBLSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBLSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_SD_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_SD_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_LD_CLK_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_LD_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_posedge        :	VitalDelayType := 0.000 ns;
      tperiod_CLK_posedge            :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SD_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_LD_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LD                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      SD                              :	in    STD_ULOGIC;
      LD                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBLSH : entity is TRUE;
end DFFCBLSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBLSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SD_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL LD_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LD_ipd, LD, tipd_LD);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SD_CLK_dly, SD_ipd, tisd_SD_CLK);
   VitalSignalDelay (LD_CLK_dly, LD_ipd, tisd_LD_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, SD_CLK_dly, LD_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SD_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SD_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_LD_CLK_CE_EQ_1_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_LD_CLK_CE_EQ_1_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_posedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_posedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_MUX_SD : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_posedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_posedge,
          SetupLow                => tsetup_D_CLK_noedge_posedge,
          HoldHigh                => thold_D_CLK_noedge_posedge,
          HoldLow                 => thold_D_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SD_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_SD_CLK_CE_EQ_1_posedge,
          TestSignal              => SD_CLK_dly,
          TestSignalName          => "SD",
          TestDelay               => tisd_SD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SD_CLK_noedge_posedge,
          SetupLow                => tsetup_SD_CLK_noedge_posedge,
          HoldHigh                => thold_SD_CLK_noedge_posedge,
          HoldLow                 => thold_SD_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_LD_CLK_CE_EQ_1_posedge,
          TimingData              => Tmkr_LD_CLK_CE_EQ_1_posedge,
          TestSignal              => LD_CLK_dly,
          TestSignalName          => "LD",
          TestDelay               => tisd_LD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_LD_CLK_noedge_posedge,
          SetupLow                => tsetup_LD_CLK_noedge_posedge,
          HoldHigh                => thold_LD_CLK_noedge_posedge,
          HoldLow                 => thold_LD_CLK_noedge_posedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_posedge,
          TimingData              => Tmkr_CE_CLK_posedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_posedge,
          SetupLow                => tsetup_CE_CLK_noedge_posedge,
          HoldHigh                => thold_CE_CLK_noedge_posedge,
          HoldLow                 => thold_CE_CLK_noedge_posedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DFFCBLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_posedge,
          PulseWidthHigh          => tpw_CLK_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          HeaderMsg               => InstancePath & "/DFFCBLSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_MUX_SD := VitalMUX2(
			    data0 => D_CLK_dly,
			    data1 => SD_CLK_dly,
			    dselect => LD_CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_posedge or Tviol_CE_CLK_posedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_MUX_SD, CLK_dly,'1','1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBLSH_VITAL of DFFCBLSH is 
        for VITAL
        end for; 
end CFG_DFFCBLSH_VITAL;

----- VITAL model for cell DFFCBLSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DFFCBLSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_CLK_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tsetup_SD_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_SD_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tsetup_LD_CLK_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_LD_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tsetup_CE_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      thold_CE_CLK_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_CLK_negedge        :	VitalDelayType := 0.000 ns;
      tperiod_CLK_negedge            :	VitalDelayType := 0.000 ns;
      ticd_CLK                       :	VitalDelayType := 0.000 ns;
      tisd_D_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_SD_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_LD_CLK                     :	VitalDelayType := 0.000 ns;
      tisd_CE_CLK                     :	VitalDelayType := 0.000 ns;
      tipd_CE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LD                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CE                             :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      SD                              :	in    STD_ULOGIC;
      LD                              :	in    STD_ULOGIC;
      CLK                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DFFCBLSH_1 : entity is TRUE;
end DFFCBLSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DFFCBLSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D_ipd	         : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL SD_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL LD_CLK_dly	 : STD_ULOGIC := 'X';
   SIGNAL CE_CLK_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CE_ipd, CE, tipd_CE);
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LD_ipd, LD, tipd_LD);
   VitalWireDelay (CLK_ipd, CLK, tipd_CLK);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (CLK_dly, CLK_ipd, ticd_CLK);
   VitalSignalDelay (D_CLK_dly, D_ipd, tisd_D_CLK);
   VitalSignalDelay (SD_CLK_dly, SD_ipd, tisd_SD_CLK);
   VitalSignalDelay (LD_CLK_dly, LD_ipd, tisd_LD_CLK);
   VitalSignalDelay (CE_CLK_dly, CE_ipd, tisd_CE_CLK);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CE_ipd, CLK_dly, D_CLK_dly, SD_CLK_dly, LD_CLK_dly, CE_CLK_dly)

   -- timing check results
   VARIABLE Tviol_D_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SD_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SD_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_LD_CLK_CE_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_LD_CLK_CE_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_CE_CLK_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_CE_CLK_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_CLK_CE_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_CLK_CE_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 4);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_MUX_SD : STD_ULOGIC := '0';
   VARIABLE CLK_inverted : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_D_CLK_CE_EQ_1_negedge,
          TestSignal              => D_CLK_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_D_CLK_noedge_negedge,
          SetupLow                => tsetup_D_CLK_noedge_negedge,
          HoldHigh                => thold_D_CLK_noedge_negedge,
          HoldLow                 => thold_D_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SD_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_SD_CLK_CE_EQ_1_negedge,
          TestSignal              => SD_CLK_dly,
          TestSignalName          => "SD",
          TestDelay               => tisd_SD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_SD_CLK_noedge_negedge,
          SetupLow                => tsetup_SD_CLK_noedge_negedge,
          HoldHigh                => thold_SD_CLK_noedge_negedge,
          HoldLow                 => thold_SD_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_LD_CLK_CE_EQ_1_negedge,
          TimingData              => Tmkr_LD_CLK_CE_EQ_1_negedge,
          TestSignal              => LD_CLK_dly,
          TestSignalName          => "LD",
          TestDelay               => tisd_LD_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_LD_CLK_noedge_negedge,
          SetupLow                => tsetup_LD_CLK_noedge_negedge,
          HoldHigh                => thold_LD_CLK_noedge_negedge,
          HoldLow                 => thold_LD_CLK_noedge_negedge,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE_CLK_negedge,
          TimingData              => Tmkr_CE_CLK_negedge,
          TestSignal              => CE_CLK_dly,
          TestSignalName          => "CE",
          TestDelay               => tisd_CE_CLK,
          RefSignal               => CLK_dly,
          RefSignalName          => "CLK",
          RefDelay                => ticd_CLK,
          SetupHigh               => tsetup_CE_CLK_noedge_negedge,
          SetupLow                => tsetup_CE_CLK_noedge_negedge,
          HoldHigh                => thold_CE_CLK_noedge_negedge,
          HoldLow                 => thold_CE_CLK_noedge_negedge,
          CheckEnabled            => TRUE, 
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DFFCBLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_CLK_CE_EQ_1,
          PeriodData              => PInfo_CLK_CE_EQ_1,
          TestSignal              => CLK_dly,
          TestSignalName          => "CLK",
          TestDelay               => ticd_CLK,
          Period                  => tperiod_CLK_negedge,
          PulseWidthHigh          => tpw_CLK_negedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(CE_ipd) = '0',
          HeaderMsg               => InstancePath & "/DFFCBLSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      CLK_inverted := VitalINV(CLK_dly);
      D_MUX_SD := VitalMUX2(
			    data0 => D_CLK_dly,
			    data1 => SD_CLK_dly,
			    dselect => LD_CLK_dly);
      Violation := Tviol_D_CLK_CE_EQ_1_negedge or Tviol_CE_CLK_negedge or Pviol_CLK_CE_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => dffcebtab,
        DataIn => (
               D_MUX_SD, CLK_inverted,'1','1', CE_CLK_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (CLK_dly'last_event, tpd_CLK_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DFFCBLSH_1_VITAL of DFFCBLSH_1 is 
        for VITAL
        end for; 
end CFG_DFFCBLSH_1_VITAL;



----- VITAL model for cell DLAT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DLAT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLAT : entity is TRUE;
end DLAT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLAT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DLAT",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLAT_VITAL of DLAT is 
        for VITAL
        end for; 
end CFG_DLAT_VITAL;


----- VITAL model for cell DLAT_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DLAT_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLAT_1 : entity is TRUE;
end DLAT_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLAT_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE LAT_inverted : STD_ULOGIC := 'X';
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName           => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_posedge,
          SetupLow                => tsetup_D_LAT_noedge_posedge,
          HoldHigh                => thold_D_LAT_noedge_posedge,
          HoldLow                 => thold_D_LAT_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DLAT_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DLAT_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      LAT_inverted := (NOT LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_inverted,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLAT_1_VITAL of DLAT_1 is 
        for VITAL
        end for; 
end CFG_DLAT_1_VITAL;



----- VITAL model for cell DLATR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_R_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_posedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATR : entity is TRUE;
end DLATR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TO_X01(R_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_posedge_negedge,
          Removal                 => thold_R_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_1,
          PeriodData              => PInfo_LAT_R_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(R_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_1_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, R_LAT_dly,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATR_VITAL of DLATR is 
        for VITAL
        end for; 
end CFG_DLATR_VITAL;

----- VITAL model for cell DLATRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 0.000 ns;
      tpw_R_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_R_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRH : entity is TRUE;
end DLATRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TO_X01((R_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_negedge,
          Removal                 => thold_R_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((R_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_0_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_0;
      R_inverted := (NOT R_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,R_inverted,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRH_VITAL of DLATRH is 
        for VITAL
        end for; 
end CFG_DLATRH_VITAL;


----- VITAL model for cell DLATRH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATRH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_R_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 0.000 ns;
      tpw_R_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_R_LAT_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_R_LAT_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_R_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_R                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      R                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATRH_1 : entity is TRUE;
end DLATRH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATRH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL R_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL R_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (R_ipd, R, tipd_R);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (R_LAT_dly, R_ipd, tisd_R_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, R_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_R_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_R_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_R_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_R_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_R_EQ_0	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_R_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE R_inverted : STD_ULOGIC := 'X';
   VARIABLE LAT_inverted : STD_ULOGIC := 'X';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_R_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_R_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_posedge,
          SetupLow                => tsetup_D_LAT_noedge_posedge,
          HoldHigh                => thold_D_LAT_noedge_posedge,
          HoldLow                 => thold_D_LAT_noedge_posedge,
          CheckEnabled            => TO_X01((R_LAT_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DLATRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_R_LAT_negedge,
          TimingData              => Tmkr_R_LAT_negedge,
          TestSignal              => R_LAT_dly,
          TestSignalName          => "R",
          TestDelay               => tisd_R_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_R_LAT_negedge_posedge,
          Removal                 => thold_R_LAT_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DLATRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_R_EQ_0,
          PeriodData              => PInfo_LAT_R_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((R_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_R_EQ_0_negedge or Tviol_R_LAT_negedge or Pviol_LAT_R_EQ_0;
      R_inverted := (NOT R_LAT_dly);
      LAT_inverted := (NOT LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_inverted, R_inverted,'1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (R_LAT_dly'last_event, tpd_R_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATRH_1_VITAL of DLATRH_1 is 
        for VITAL
        end for; 
end CFG_DLATRH_1_VITAL;


----- VITAL model for cell DLATSRH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DLATSRH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SR_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SR_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_SR_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_SR_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SR                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SR                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSRH : entity is TRUE;
end DLATSRH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATSRH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SR_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL SR_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SR_ipd, SR, tipd_SR);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (SR_LAT_dly, SR_ipd, tisd_SR_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, SR_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SR_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SR_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SR_LAT_negedge,
          TimingData              => Tmkr_SR_LAT_negedge,
          TestSignal              => SR_LAT_dly,
          TestSignalName          => "SR",
          TestDelay               => tisd_SR_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_SR_LAT_noedge_negedge,
          SetupLow                => tsetup_SR_LAT_noedge_negedge,
          HoldHigh                => thold_SR_LAT_noedge_negedge,
          HoldLow                 => thold_SR_LAT_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DLATSRH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalAND2(NOT(SR_LAT_dly), D_LAT_dly);
      Violation := Tviol_D_LAT_negedge or Pviol_LAT or Tviol_SR_LAT_negedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_in_zd, LAT_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSRH_VITAL of DLATSRH is 
        for VITAL
        end for; 
end CFG_DLATSRH_VITAL;

----- VITAL model for cell DLATSRH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DLATSRH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SR_LAT_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_SR_LAT_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_SR_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SR                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SR                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSRH_1 : entity is TRUE;
end DLATSRH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATSRH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SR_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL SR_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SR_ipd, SR, tipd_SR);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (SR_LAT_dly, SR_ipd, tisd_SR_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, SR_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SR_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SR_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE LAT_inverted : STD_ULOGIC := 'X';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName           => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_posedge,
          SetupLow                => tsetup_D_LAT_noedge_posedge,
          HoldHigh                => thold_D_LAT_noedge_posedge,
          HoldLow                 => thold_D_LAT_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SR_LAT_negedge,
          TimingData              => Tmkr_SR_LAT_negedge,
          TestSignal              => SR_LAT_dly,
          TestSignalName          => "SR",
          TestDelay               => tisd_SR_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_SR_LAT_noedge_posedge,
          SetupLow                => tsetup_SR_LAT_noedge_posedge,
          HoldHigh                => thold_SR_LAT_noedge_posedge,
          HoldLow                 => thold_SR_LAT_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DLATSRH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalAND2(NOT(SR_LAT_dly),  D_LAT_dly);
      LAT_inverted := NOT(LAT_dly);
      Violation := Tviol_D_LAT_negedge or Pviol_LAT or Tviol_SR_LAT_negedge;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_in_zd, LAT_inverted,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSRH_1_VITAL of DLATSRH_1 is 
        for VITAL
        end for; 
end CFG_DLATSRH_1_VITAL;



----- VITAL model for cell DLATS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_posedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_posedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATS : entity is TRUE;
end DLATS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_1_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_1_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_1	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_1	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_1_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_1_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TO_X01(S_LAT_dly) = '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_posedge_negedge,
          Removal                 => thold_S_LAT_posedge_negedge,
          ActiveLow               => TRUE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_1,
          PeriodData              => PInfo_LAT_S_EQ_1,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01(S_LAT_dly ) = '1',
          HeaderMsg               => InstancePath & "/DLATS",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_1_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_1;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly,'1', S_LAT_dly));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATS_VITAL of DLATS is 
        for VITAL
        end for; 
end CFG_DLATS_VITAL;

----- VITAL model for cell DLATSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 0.000 ns;
      tpw_S_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_negedge_negedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_negedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSH : entity is TRUE;
end DLATSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TO_X01((S_LAT_dly)) = '0',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_negedge,
          Removal                 => thold_S_LAT_negedge_negedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_0,
          PeriodData              => PInfo_LAT_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((S_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_0_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_dly, '1',S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSH_VITAL of DLATSH is 
        for VITAL
        end for; 
end CFG_DLATSH_VITAL;


----- VITAL model for cell DLATSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;



-- entity declaration --
entity DLATSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_posedge :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_posedge :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge         :	VitalDelayType := 0.000 ns;
      tpw_S_posedge         :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge             :	VitalDelayType := 0.000 ns;
      trecovery_S_LAT_negedge_posedge :	VitalDelayType := 0.100 ns;
      thold_S_LAT_negedge_posedge    :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_S_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      S                              :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSH_1 : entity is TRUE;
end DLATSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL S_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   VitalWireDelay (S_ipd, S, tipd_S);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (S_LAT_dly, S_ipd, tisd_S_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, S_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_S_EQ_0_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_S_EQ_0_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_S_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_S_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT_S_EQ_0	: STD_ULOGIC := '0';
   VARIABLE Pviol_S	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT_S_EQ_0	: VitalPeriodDataType := VitalPeriodDataInit;
   VARIABLE PInfo_S	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE S_inverted : STD_ULOGIC := 'X';
   VARIABLE LAT_inverted : STD_ULOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_S_EQ_0_negedge,
          TimingData              => Tmkr_D_LAT_S_EQ_0_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_posedge,
          SetupLow                => tsetup_D_LAT_noedge_posedge,
          HoldHigh                => thold_D_LAT_noedge_posedge,
          HoldLow                 => thold_D_LAT_noedge_posedge,
          CheckEnabled            => TO_X01((S_LAT_dly)) = '0',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DLATSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalRecoveryRemovalCheck (
          Violation               => Tviol_S_LAT_negedge,
          TimingData              => Tmkr_S_LAT_negedge,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          Recovery                => trecovery_S_LAT_negedge_posedge,
          Removal                 => thold_S_LAT_negedge_posedge,
          ActiveLow               => FALSE,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/DLATSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_S,
          PeriodData              => PInfo_S,
          TestSignal              => S_LAT_dly,
          TestSignalName          => "S",
          TestDelay               => tisd_S_LAT,
          Period                  => 0 ns,
          PulseWidthHigh          => 0 ns,
          PulseWidthLow           => tpw_S_posedge,
          CheckEnabled            => TRUE, 
          HeaderMsg               => InstancePath & "/DLATSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT_S_EQ_0,
          PeriodData              => PInfo_LAT_S_EQ_0,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TO_X01((S_LAT_dly) ) = '0',
          HeaderMsg               => InstancePath & "/DLATSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_LAT_S_EQ_0_negedge or Tviol_S_LAT_negedge or Pviol_LAT_S_EQ_0 or Pviol_S;
      S_inverted := (NOT S_LAT_dly);
      LAT_inverted := (NOT LAT_dly);
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_LAT_dly, LAT_inverted, '1',S_inverted));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE),
                 2 => (S_LAT_dly'last_event, tpd_S_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSH_1_VITAL of DLATSH_1 is 
        for VITAL
        end for; 
end CFG_DLATSH_1_VITAL;

----- VITAL model for cell DLATSSH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DLATSSH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SS_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tsetup_SS_LAT_noedge_negedge    :	VitalDelayType := 0.100 ns;
      thold_SS_LAT_noedge_negedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_SS_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SS                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSSH : entity is TRUE;
end DLATSSH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATSSH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL SS_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SS_ipd, SS, tipd_SS);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (SS_LAT_dly, SS_ipd, tisd_SS_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, SS_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_negedge,
          SetupLow                => tsetup_D_LAT_noedge_negedge,
          HoldHigh                => thold_D_LAT_noedge_negedge,
          HoldLow                 => thold_D_LAT_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DLATSSH",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      D_in_zd := VitalOR2(SS_LAT_dly , D_LAT_dly);
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_in_zd, LAT_dly,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSSH_VITAL of DLATSSH is 
        for VITAL
        end for; 
end CFG_DLATSSH_VITAL;

----- VITAL model for cell DLATSSH_1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

LIBRARY LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;


-- entity declaration --
entity DLATSSH_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_D_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SS_Q                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LAT_Q                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_LAT_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_D_LAT_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tsetup_SS_LAT_noedge_posedge    :	VitalDelayType := 0.100 ns;
      thold_SS_LAT_noedge_posedge     :	VitalDelayType := 0.000 ns;
      tperiod_LAT_posedge            :	VitalDelayType := 0.000 ns;
      tpw_LAT_posedge                :	VitalDelayType := 0.000 ns;
      ticd_LAT                       :	VitalDelayType := 0.000 ns;
      tisd_D_LAT                     :	VitalDelayType := 0.000 ns;
      tisd_SS_LAT                     :	VitalDelayType := 0.000 ns;
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SS                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LAT                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SS                              :	in    STD_ULOGIC;
      LAT                            :	in    STD_ULOGIC;
      Q                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DLATSSH_1 : entity is TRUE;
end DLATSSH_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of DLATSSH_1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL D_LAT_dly	 : STD_ULOGIC := 'X';
   SIGNAL SS_LAT_dly	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SS_ipd, SS, tipd_SS);
   VitalWireDelay (LAT_ipd, LAT, tipd_LAT);
   end block;
   ----------------------
   --  INPUT SIGNAL DELAYs
   ----------------------
   SignalDelay : block
   begin
   VitalSignalDelay (LAT_dly, LAT_ipd, ticd_LAT);
   VitalSignalDelay (D_LAT_dly, D_ipd, tisd_D_LAT);
   VitalSignalDelay (SS_LAT_dly, SS_ipd, tisd_SS_LAT);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LAT_dly, D_LAT_dly, SS_LAT_dly)

   -- timing check results
   VARIABLE Tviol_D_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_D_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Tviol_SS_LAT_negedge	: STD_ULOGIC := '0';
   VARIABLE Tmkr_SS_LAT_negedge	: VitalTimingDataType := VitalTimingDataInit;
   VARIABLE Pviol_LAT	: STD_ULOGIC := '0';
   VARIABLE PInfo_LAT	: VitalPeriodDataType := VitalPeriodDataInit;

   -- functionality results
   VARIABLE Violation : STD_ULOGIC := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(0 to 3);
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);
   VARIABLE D_in_zd : STD_ULOGIC := '0';
   VARIABLE LAT_inverted : STD_ULOGIC := '0';

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: VitalGlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalSetupHoldCheck (
          Violation               => Tviol_D_LAT_negedge,
          TimingData              => Tmkr_D_LAT_negedge,
          TestSignal              => D_LAT_dly,
          TestSignalName          => "D",
          TestDelay               => tisd_D_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_D_LAT_noedge_posedge,
          SetupLow                => tsetup_D_LAT_noedge_posedge,
          HoldHigh                => thold_D_LAT_noedge_posedge,
          HoldLow                 => thold_D_LAT_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalSetupHoldCheck (
          Violation               => Tviol_SS_LAT_negedge,
          TimingData              => Tmkr_SS_LAT_negedge,
          TestSignal              => SS_LAT_dly,
          TestSignalName          => "SS",
          TestDelay               => tisd_SS_LAT,
          RefSignal               => LAT_dly,
          RefSignalName          => "LAT",
          RefDelay                => ticd_LAT,
          SetupHigh               => tsetup_SS_LAT_noedge_posedge,
          SetupLow                => tsetup_SS_LAT_noedge_posedge,
          HoldHigh                => thold_SS_LAT_noedge_posedge,
          HoldLow                 => thold_SS_LAT_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/DLATSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
         VitalPeriodPulseCheck (
          Violation               => Pviol_LAT,
          PeriodData              => PInfo_LAT,
          TestSignal              => LAT_dly,
          TestSignalName          => "LAT",
          TestDelay               => ticd_LAT,
          Period                  => tperiod_LAT_posedge,
          PulseWidthHigh          => tpw_LAT_posedge,
          PulseWidthLow           => 0 ns,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/DLATSSH_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      LAT_inverted := VitalINV(LAT_dly);
      D_in_zd := VitalOR2(SS_LAT_dly , D_LAT_dly);
      Violation := Tviol_D_LAT_negedge or Pviol_LAT;
      VitalStateTable(
        Result => Q_zd,
        PreviousDataIn => PrevData_Q,
        StateTable => latchtab,
        DataIn => (
               D_in_zd, LAT_inverted,'1','1'));
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => Q,
       GlitchData => Q_GlitchData,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_LAT_dly'last_event, tpd_D_Q, TRUE),
                 1 => (LAT_dly'last_event, tpd_LAT_Q, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_DLATSSH_1_VITAL of DLATSSH_1 is 
        for VITAL
        end for; 
end CFG_DLATSSH_1_VITAL;

----- VITAL model for cell LUT1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LUT1 is
   generic(
      TimingChecksOn: Boolean := TRUE;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      INIT                           :	bit_vector);

   port(
      O                              :	out   STD_ULOGIC;
      I0                             :	in    STD_ULOGIC);
attribute VITAL_LEVEL0 of LUT1 : entity is TRUE;
end LUT1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of LUT1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => To_StdLogicVector(INIT),
                  dselect => (0 => I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnEvent,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LUT1_V of LUT1 is
   for VITAL 
   end for;
end CFG_LUT1_V;


----- VITAL model for cell LUT2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LUT2 is
   generic(
      TimingChecksOn: Boolean := TRUE;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      INIT                           :	bit_vector);

   port(
      O                              :	out   STD_ULOGIC;
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC);
attribute VITAL_LEVEL0 of LUT2 : entity is TRUE;
end LUT2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of LUT2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => To_StdLogicVector(INIT),
                  dselect => (I1_ipd, I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnEvent,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LUT2_V of LUT2 is
   for VITAL 
   end for;
end CFG_LUT2_V;

----- CELL LUT3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LUT3 is
   generic(
      TimingChecksOn: Boolean := TRUE;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      INIT                           :	bit_vector);

   port(
      O                              :	out   STD_ULOGIC;
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC);
attribute VITAL_LEVEL0 of LUT3 : entity is TRUE;
end LUT3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of LUT3 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => To_StdLogicVector(INIT),
                  dselect => (I2_ipd, I1_ipd, I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE)),
       Mode => OnEvent,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LUT3_V of LUT3 is
   for VITAL
   end for;
end CFG_LUT3_V;

----- CELL LUT4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LUT4 is
   generic(
      TimingChecksOn: Boolean := TRUE;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      INIT                           :	bit_vector);

   port(
      O                              :	out   STD_ULOGIC;
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC);
attribute VITAL_LEVEL0 of LUT4 : entity is TRUE;
end LUT4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
architecture VITAL of LUT4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => To_StdLogicVector(INIT),
                  dselect => (I3_ipd, I2_ipd, I1_ipd, I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE)),
       Mode => OnEvent,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LUT4_V of LUT4 is
   for VITAL
   end for;
end CFG_LUT4_V;

----- CELL LUT5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LUT5 is
   generic(
      TimingChecksOn: Boolean := TRUE;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      INIT                           :	bit_vector);

   port(
      O                              :	out   STD_ULOGIC;
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC);
attribute VITAL_LEVEL0 of LUT5 : entity is TRUE;
end LUT5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of LUT5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => To_StdLogicVector(INIT),
                  dselect => (I4_ipd, I3_ipd, I2_ipd, I1_ipd, I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I2_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE)),
       Mode => OnEvent,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LUT5_V of LUT5 is
   for VITAL
   end for;
end CFG_LUT5_V;

----- CELL LUT6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LUT6 is
   generic(
      TimingChecksOn: Boolean := TRUE;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      INIT                           :	bit_vector);

   port(
      O                              :	out   STD_ULOGIC;
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC);
attribute VITAL_LEVEL0 of LUT6 : entity is TRUE;
end LUT6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of LUT6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => To_StdLogicVector(INIT),
                  dselect => (I5_ipd, I4_ipd, I3_ipd, I2_ipd, I1_ipd, I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I2_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE)),
       Mode => OnEvent,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LUT6_V of LUT6 is
   for VITAL
   end for;
end CFG_LUT6_V;


----- CELL AS_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity AS_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of AS_LSB : entity is TRUE;
end AS_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of AS_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd, AS_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (B0_ipd) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       (((NOT ((AS_ipd) XOR (CIN_ipd)))) AND (A0_ipd)) OR (((NOT ((AS_ipd)
         XOR (B0_ipd)))) AND (A0_ipd)) OR (((NOT ((AS_ipd) XOR (CIN_ipd))))
         AND ((NOT ((AS_ipd) XOR (B0_ipd)))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_AS_LSB_VITAL of AS_LSB is
   for VITAL
   end for;
end CFG_AS_LSB_VITAL;


----- CELL BI_DIR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BI_DIR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_IO                      :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_IO                      :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tpd_IO_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_IO                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BI_DIR : entity is TRUE;
end BI_DIR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of BI_DIR is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (IO_ipd, IO, tipd_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd, IO_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS IO_zd : STD_LOGIC is Results(1);
   ALIAS O_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF0 (data => I0_ipd,
              enable => (NOT OE_ipd));
      O_zd := TO_X01(IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_IO), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_IO), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (IO_ipd'last_event, tpd_IO_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_BI_DIR_VITAL of BI_DIR is
   for VITAL
   end for;
end CFG_BI_DIR_VITAL;


----- CELL BUFEI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFEI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_O                       :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFEI : entity is TRUE;
end BUFEI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of BUFEI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I0_ipd,
              enable => OE_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;

end VITAL;

configuration CFG_BUFEI_VITAL of BUFEI is
   for VITAL
   end for;
end CFG_BUFEI_VITAL;

----- CELL CCU_BUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CI                             :	in    STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BUF : entity is TRUE;
end CCU_BUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CI_ipd, CI, tipd_CI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => O_GlitchData,
       OutSignalName => "COUT",
       OutTemp => O_zd,
       Paths => (0 => (CI_ipd'last_event, tpd_CI_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BUF_VITAL of CCU_BUF is
   for VITAL
   end for;
end CFG_CCU_BUF_VITAL;

----- CELL CCU_OUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_OUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_OUT : entity is TRUE;
end CCU_OUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_OUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CI_ipd, CI, tipd_CI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (CI_ipd'last_event, tpd_CI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_OUT_VITAL of CCU_OUT is
   for VITAL
   end for;
end CFG_CCU_OUT_VITAL;


----- CELL FT_BUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity FT_BUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of FT_BUF : entity is TRUE;
end FT_BUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of FT_BUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_FT_BUF_VITAL of FT_BUF is
   for VITAL
   end for;
end CFG_FT_BUF_VITAL;

----- CELL BUFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFF : entity is TRUE;
end BUFF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of BUFF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_BUFF_VITAL of BUFF is
   for VITAL
   end for;
end CFG_BUFF_VITAL;


----- CELL BUFTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_O                       :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTH : entity is TRUE;
end BUFTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of BUFTH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I0_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;

end VITAL;

configuration CFG_BUFTH_VITAL of BUFTH is
   for VITAL
   end for;
end CFG_BUFTH_VITAL;


----- CELL BUFTI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_O                       :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTI : entity is TRUE;
end BUFTI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of BUFTI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I0_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;

end VITAL;

configuration CFG_BUFTI_VITAL of BUFTI is
   for VITAL
   end for;
end CFG_BUFTI_VITAL;


----- CELL BUFTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BUFTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_O                       :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BUFTL : entity is TRUE;
end BUFTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of BUFTL is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I0_ipd,
              enable => OE_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;

end VITAL;

configuration CFG_BUFTL_VITAL of BUFTL is
   for VITAL
   end for;
end CFG_BUFTL_VITAL;


----- CELL CCU_ABS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_ABS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_PN_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_PN_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PN                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      PN                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_ABS : entity is TRUE;
end CCU_ABS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_ABS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL PN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (PN_ipd, PN, tipd_PN);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, PN_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (((CIN_ipd) XOR ((NOT D_ipd))) AND (PN_ipd)) OR ((D_ipd) AND ((NOT
         PN_ipd)));
      COUT_zd := (CIN_ipd) AND ((NOT D_ipd)) AND (PN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (PN_ipd'last_event, tpd_PN_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (PN_ipd'last_event, tpd_PN_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_ABS_VITAL of CCU_ABS is
   for VITAL
   end for;
end CFG_CCU_ABS_VITAL;


----- CELL CCU_ADD -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_ADD is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_ADD : entity is TRUE;
end CCU_ADD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_ADD is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (B0_ipd) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((B0_ipd) AND (A0_ipd)) OR ((CIN_ipd) AND
         (B0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_ADD_VITAL of CCU_ADD is
   for VITAL
   end for;
end CFG_CCU_ADD_VITAL;

----- CELL CCU_GEN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_GEN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_GEN : entity is TRUE;
end CCU_GEN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_GEN is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (B0_ipd) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((B0_ipd) AND (A0_ipd)) OR ((CIN_ipd) AND
         (B0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_GEN_VITAL of CCU_GEN is
   for VITAL
   end for;
end CFG_CCU_GEN_VITAL;


----- CELL CCU_GEN1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_GEN1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_GEN1 : entity is TRUE;
end CCU_GEN1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_GEN1 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (B0_ipd) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((B0_ipd) AND (A0_ipd)) OR ((CIN_ipd) AND
         (B0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_GEN1_VITAL of CCU_GEN1 is
   for VITAL
   end for;
end CFG_CCU_GEN1_VITAL;

----- CELL CCU_GEN2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_GEN2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      D                              :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_GEN2 : entity is TRUE;
end CCU_GEN2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_GEN2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (B0_ipd) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((B0_ipd) AND (A0_ipd)) OR ((CIN_ipd) AND
         (B0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_GEN2_VITAL of CCU_GEN2 is
   for VITAL
   end for;
end CFG_CCU_GEN2_VITAL;

----- CELL CCU_SUB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_SUB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_SUB : entity is TRUE;
end CCU_SUB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_SUB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (NOT(B0_ipd)) XOR (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (A0_ipd)) OR ((NOT(B0_ipd)) AND (A0_ipd)) OR ((CIN_ipd) AND
         (NOT(B0_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_SUB_VITAL of CCU_SUB is
   for VITAL
   end for;
end CFG_CCU_SUB_VITAL;


----- CELL CCU_ADD_2S -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_ADD_2S is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SEL_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SEL_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SEL                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      SEL                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_ADD_2S : entity is TRUE;
end CCU_ADD_2S;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_ADD_2S is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SEL_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (SEL_ipd, SEL, tipd_SEL);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, SEL_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := ((NOT A0_ipd) AND SEL_ipd) XOR B0_ipd XOR CIN_ipd;
      COUT_zd :=((NOT A0_ipd) AND SEL_ipd AND B0_ipd) OR ((NOT A0_ipd) AND SEL_ipd AND CIN_ipd) OR (CIN_ipd AND B0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => P_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
		 2 => (SEL_ipd'last_event, tpd_SEL_S0, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
		 2 => (SEL_ipd'last_event, tpd_SEL_COUT, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_ADD_2S_VITAL of CCU_ADD_2S is
   for VITAL
   end for;
end CFG_CCU_ADD_2S_VITAL;

----- CELL CCU_MULT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_MULT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      P                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_MULT : entity is TRUE;
end CCU_MULT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_MULT is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (B1_ipd, B1, tipd_B1);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, A1_ipd, B1_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd := ((B0_ipd) AND (A0_ipd)) XOR ((B1_ipd) AND (A1_ipd)) XOR (CIN_ipd);
      COUT_zd :=
       (A0_ipd AND B0_ipd AND A1_ipd AND B1_ipd) OR (A0_ipd AND B0_ipd AND CIN_ipd) OR (A1_ipd AND B1_ipd AND CIN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_P, TRUE),
		 1 => (A1_ipd'last_event, tpd_A1_P, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_P, TRUE),
		 3 => (B1_ipd'last_event, tpd_B1_P, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
		 1 => (A1_ipd'last_event, tpd_A1_COUT, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
		 3 => (B1_ipd'last_event, tpd_B1_COUT, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_MULT_VITAL of CCU_MULT is
   for VITAL
   end for;
end CFG_CCU_MULT_VITAL;

----- CELL CCU_AGB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_AGB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_AGB : entity is TRUE;
end CCU_AGB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_AGB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS COUT_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      COUT_zd :=
       ((CIN_ipd) AND ((NOT ((B0_ipd) XOR (A0_ipd))))) OR (((NOT B0_ipd))
         AND (A0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_AGB_VITAL of CCU_AGB is
   for VITAL
   end for;
end CFG_CCU_AGB_VITAL;


----- CELL CCU_AGBS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_AGBS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC;
      S0                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_AGBS : entity is TRUE;
end CCU_AGBS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_AGBS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS COUT_zd : STD_LOGIC is Results(1);
   ALIAS S0_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;
   VARIABLE S0_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      COUT_zd :=
       ((CIN_ipd) AND ((NOT ((B0_ipd) XOR (A0_ipd))))) OR (((NOT B0_ipd))
         AND (A0_ipd));
      S0_zd := ((NOT B0_ipd)) XOR (A0_ipd) XOR (CIN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_AGBS_VITAL of CCU_AGBS is
   for VITAL
   end for;
end CFG_CCU_AGBS_VITAL;


----- CELL CCU_AS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_AS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_AS : entity is TRUE;
end CCU_AS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_AS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, B0_ipd, CIN_ipd, AS_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       ((((NOT AS_ipd)) AND ((NOT B0_ipd))) OR ((AS_ipd) AND (B0_ipd))) XOR
         (A0_ipd) XOR (CIN_ipd);
      COUT_zd :=
       (((((NOT AS_ipd)) AND ((NOT B0_ipd))) OR ((AS_ipd) AND (B0_ipd))) AND
         ((CIN_ipd) OR (A0_ipd))) OR ((CIN_ipd) AND (A0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_S0, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_AS_VITAL of CCU_AS is
   for VITAL
   end for;
end CFG_CCU_AS_VITAL;


----- CELL CCU_BTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SH_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SH_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SH                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_NOP                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      D0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      SH                             :	in    STD_ULOGIC;
      NOP                            :	in    STD_ULOGIC;
      P                              :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BTH : entity is TRUE;
end CCU_BTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BTH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SH_ipd	 : STD_ULOGIC := 'X';
   SIGNAL NOP_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (D0_ipd, D0, tipd_D0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   VitalWireDelay (SH_ipd, SH, tipd_SH);
   VitalWireDelay (NOP_ipd, NOP, tipd_NOP);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, A1_ipd, D0_ipd, CIN_ipd, AS_ipd, SH_ipd, NOP_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd :=
       ((NOP_ipd) AND (D0_ipd)) OR (((NOT NOP_ipd)) AND ((AS_ipd) XOR
         (((SH_ipd) AND (A1_ipd)) OR (((NOT SH_ipd)) AND (A0_ipd))) XOR
         (D0_ipd) XOR (CIN_ipd)));
      COUT_zd :=
       ((CIN_ipd) AND (D0_ipd)) OR (((CIN_ipd) OR (D0_ipd)) AND ((AS_ipd)
         XOR (((SH_ipd) AND (A1_ipd)) OR (((NOT SH_ipd)) AND (A0_ipd)))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_P, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_P, TRUE),
                 2 => (D0_ipd'last_event, tpd_D0_P, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_P, TRUE),
                 4 => (AS_ipd'last_event, tpd_AS_P, TRUE),
                 5 => (SH_ipd'last_event, tpd_SH_P, TRUE),
                 6 => (NOP_ipd'last_event, tpd_NOP_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_COUT, TRUE),
                 2 => (D0_ipd'last_event, tpd_D0_COUT, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 4 => (AS_ipd'last_event, tpd_AS_COUT, TRUE),
                 5 => (SH_ipd'last_event, tpd_SH_COUT, TRUE),
                 6 => (NOP_ipd'last_event, tpd_NOP_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BTH_VITAL of CCU_BTH is
   for VITAL
   end for;
end CFG_CCU_BTH_VITAL;


----- CELL CCU_BTH_LSTC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BTH_LSTC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_ADD_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_ADD_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADD                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      ADD                            :	in    STD_ULOGIC;
      P                              :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BTH_LSTC : entity is TRUE;
end CCU_BTH_LSTC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BTH_LSTC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL ADD_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (ADD_ipd, ADD, tipd_ADD);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, A1_ipd, CIN_ipd, ADD_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd := (A0_ipd) XOR ((ADD_ipd) AND (A1_ipd)) XOR (CIN_ipd);
      COUT_zd :=
       ((ADD_ipd) AND (A1_ipd) AND (CIN_ipd)) OR ((CIN_ipd) AND (A0_ipd)) OR
         ((ADD_ipd) AND (A1_ipd) AND (A0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_P, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_P, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_P, TRUE),
                 3 => (ADD_ipd'last_event, tpd_ADD_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 3 => (ADD_ipd'last_event, tpd_ADD_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BTH_LSTC_VITAL of CCU_BTH_LSTC is
   for VITAL
   end for;
end CFG_CCU_BTH_LSTC_VITAL;


----- CELL CCU_BTH_TC_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BTH_TC_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SH_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SH_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SH                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_NOP                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      SH                             :	in    STD_ULOGIC;
      NOP                            :	in    STD_ULOGIC;
      P                              :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BTH_TC_LSB : entity is TRUE;
end CCU_BTH_TC_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BTH_TC_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SH_ipd	 : STD_ULOGIC := 'X';
   SIGNAL NOP_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   VitalWireDelay (SH_ipd, SH, tipd_SH);
   VitalWireDelay (NOP_ipd, NOP, tipd_NOP);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, A1_ipd, CIN_ipd, AS_ipd, SH_ipd, NOP_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd :=
       ((NOT NOP_ipd)) AND ((AS_ipd) XOR (((SH_ipd) AND (A1_ipd)) OR (((NOT
         SH_ipd)) AND (A0_ipd))) XOR (CIN_ipd));
      COUT_zd :=
       (CIN_ipd) AND ((AS_ipd) XOR (((SH_ipd) AND (A1_ipd)) OR (((NOT
         SH_ipd)) AND (A0_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_P, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_P, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_P, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_P, TRUE),
                 4 => (SH_ipd'last_event, tpd_SH_P, TRUE),
                 5 => (NOP_ipd'last_event, tpd_NOP_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_COUT, TRUE),
                 4 => (SH_ipd'last_event, tpd_SH_COUT, TRUE),
                 5 => (NOP_ipd'last_event, tpd_NOP_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BTH_TC_LSB_VITAL of CCU_BTH_TC_LSB is
   for VITAL
   end for;
end CFG_CCU_BTH_TC_LSB_VITAL;


----- CELL CCU_BTH_TC_MSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BTH_TC_MSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_NOP                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      D0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      NOP                            :	in    STD_ULOGIC;
      P                              :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BTH_TC_MSB : entity is TRUE;
end CCU_BTH_TC_MSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BTH_TC_MSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL D0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL NOP_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (D0_ipd, D0, tipd_D0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   VitalWireDelay (NOP_ipd, NOP, tipd_NOP);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, D0_ipd, CIN_ipd, AS_ipd, NOP_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd :=
       ((NOP_ipd) AND (D0_ipd)) OR (((NOT NOP_ipd)) AND ((AS_ipd) XOR
         (A0_ipd) XOR (D0_ipd) XOR (CIN_ipd)));
      COUT_zd :=
       ((CIN_ipd) AND ((A0_ipd) XOR (AS_ipd))) OR ((D0_ipd) AND ((A0_ipd)
         XOR (AS_ipd))) OR ((CIN_ipd) AND (D0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_P, TRUE),
                 1 => (D0_ipd'last_event, tpd_D0_P, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_P, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_P, TRUE),
                 4 => (NOP_ipd'last_event, tpd_NOP_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (D0_ipd'last_event, tpd_D0_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 3 => (AS_ipd'last_event, tpd_AS_COUT, TRUE),
                 4 => (NOP_ipd'last_event, tpd_NOP_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BTH_TC_MSB_VITAL of CCU_BTH_TC_MSB is
   for VITAL
   end for;
end CFG_CCU_BTH_TC_MSB_VITAL;


----- CELL CCU_BTH_UNS_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BTH_UNS_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_A0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_A1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_A1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      A0                             :	in    STD_ULOGIC;
      A1                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      P                              :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BTH_UNS_LSB : entity is TRUE;
end CCU_BTH_UNS_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BTH_UNS_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL A0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL A1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (A0_ipd, A0, tipd_A0);
   VitalWireDelay (A1_ipd, A1, tipd_A1);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (B1_ipd, B1, tipd_B1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (A0_ipd, A1_ipd, CIN_ipd, B0_ipd, B1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd :=
       ((B1_ipd) AND (A1_ipd)) XOR ((B0_ipd) AND (A0_ipd)) XOR (CIN_ipd);
      COUT_zd :=
       ((B1_ipd) AND (A1_ipd) AND (CIN_ipd)) OR ((B0_ipd) AND (A0_ipd) AND
         (CIN_ipd)) OR ((B1_ipd) AND (A1_ipd) AND (B0_ipd) AND (A0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_P, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_P, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_P, TRUE),
                 3 => (B1_ipd'last_event, tpd_B1_P, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (A0_ipd'last_event, tpd_A0_COUT, TRUE),
                 1 => (A1_ipd'last_event, tpd_A1_COUT, TRUE),
                 2 => (B0_ipd'last_event, tpd_B0_COUT, TRUE),
                 3 => (B1_ipd'last_event, tpd_B1_COUT, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BTH_UNS_LSB_VITAL of CCU_BTH_UNS_LSB is
   for VITAL
   end for;
end CFG_CCU_BTH_UNS_LSB_VITAL;


----- CELL CCU_BTH_UNS_MSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_BTH_UNS_MSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_D0_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_P                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_P                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_AS_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_NOP_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AS                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_NOP                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      AS                             :	in    STD_ULOGIC;
      NOP                            :	in    STD_ULOGIC;
      P                              :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_BTH_UNS_MSB : entity is TRUE;
end CCU_BTH_UNS_MSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_BTH_UNS_MSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';
   SIGNAL AS_ipd	 : STD_ULOGIC := 'X';
   SIGNAL NOP_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D0_ipd, D0, tipd_D0);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   VitalWireDelay (AS_ipd, AS, tipd_AS);
   VitalWireDelay (NOP_ipd, NOP, tipd_NOP);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D0_ipd, CIN_ipd, AS_ipd, NOP_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS P_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE P_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      P_zd :=
       (((D0_ipd) XOR (AS_ipd) XOR (CIN_ipd)) AND ((NOT NOP_ipd))) OR
         ((NOP_ipd) AND (D0_ipd));
      COUT_zd :=
       ((CIN_ipd) AND (AS_ipd)) OR ((CIN_ipd) AND (D0_ipd)) OR ((D0_ipd) AND
         (AS_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P,
       GlitchData => P_GlitchData,
       OutSignalName => "P",
       OutTemp => P_zd,
       Paths => (0 => (D0_ipd'last_event, tpd_D0_P, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_P, TRUE),
                 2 => (AS_ipd'last_event, tpd_AS_P, TRUE),
                 3 => (NOP_ipd'last_event, tpd_NOP_P, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D0_ipd'last_event, tpd_D0_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
                 2 => (AS_ipd'last_event, tpd_AS_COUT, TRUE),
                 3 => (NOP_ipd'last_event, tpd_NOP_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_BTH_UNS_MSB_VITAL of CCU_BTH_UNS_MSB is
   for VITAL
   end for;
end CFG_CCU_BTH_UNS_MSB_VITAL;


----- CELL CCU_DC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_DC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_DC : entity is TRUE;
end CCU_DC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_DC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (NOT((CIN_ipd) XOR (D_ipd)));
      COUT_zd := (CIN_ipd) OR (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_DC_VITAL of CCU_DC is
   for VITAL
   end for;
end CFG_CCU_DC_VITAL;

----- CELL CCU_UC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UC : entity is TRUE;
end CCU_UC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := ((CIN_ipd) XOR (D_ipd));
      COUT_zd := (CIN_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UC_VITAL of CCU_UC is
   for VITAL
   end for;
end CFG_CCU_UC_VITAL;


----- CELL CCU_DCP -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_DCP is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_SD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_S0                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_COUT                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOAD                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LOAD                           :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_DCP : entity is TRUE;
end CCU_DCP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_DCP is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LOAD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LOAD_ipd, LOAD, tipd_LOAD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SD_ipd, LOAD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (NOT((CIN_ipd) XOR  (((NOT LOAD_ipd) AND (D_ipd)) OR ((LOAD_ipd)
         AND (SD_ipd)))));
      COUT_zd :=((CIN_ipd) OR (((NOT LOAD_ipd) AND (D_ipd)) OR ((LOAD_ipd)
         AND (SD_ipd))));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (SD_ipd'last_event, tpd_SD_S0, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_S0, TRUE),
                 2 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (LOAD_ipd'last_event, tpd_LOAD_COUT, TRUE),
                 1 => (SD_ipd'last_event, tpd_SD_COUT, TRUE),
                 2 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_DCP_VITAL of CCU_DCP is
   for VITAL
   end for;
end CFG_CCU_DCP_VITAL;

----- CELL CCU_RCD_AS -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_RCD_AS is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_B2_COUT                    :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tpd_B2_AS                      :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_B2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      B2                             :	in    STD_ULOGIC;
      AS                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of CCU_RCD_AS : entity is TRUE;
end CCU_RCD_AS;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_RCD_AS is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL B2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (B2_ipd, B2, tipd_B2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior_AS : process (B2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(B2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------

      VitalPathDelay01 (
       OutSignal => AS,
       GlitchData => O_GlitchData,
       OutSignalName => "AS",
       OutTemp => O_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_AS, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

   VITALBehavior_COUT : process (B2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(B2_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------

      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => O_GlitchData,
       OutSignalName => "COUT",
       OutTemp => O_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_RCD_AS_VITAL of CCU_RCD_AS is
   for VITAL
   end for;
end CFG_CCU_RCD_AS_VITAL;

----- CELL CCU_RCD -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_RCD is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_B0_AS                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_AS                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B2_AS                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_SH                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_SH                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B2_SH                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B0_NOP                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_NOP                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B2_NOP                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      B0                             :	in    STD_ULOGIC;
      B1                             :	in    STD_ULOGIC;
      B2                             :	in    STD_ULOGIC;
      AS                             :	out   STD_ULOGIC;
      SH                             :	out   STD_ULOGIC;
      NOP                            :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_RCD : entity is TRUE;
end CCU_RCD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_RCD is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL B0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (B0_ipd, B0, tipd_B0);
   VitalWireDelay (B1_ipd, B1, tipd_B1);
   VitalWireDelay (B2_ipd, B2, tipd_B2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (B0_ipd, B1_ipd, B2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 3) := (others => 'X');
   ALIAS AS_zd : STD_LOGIC is Results(1);
   ALIAS SH_zd : STD_LOGIC is Results(2);
   ALIAS NOP_zd : STD_LOGIC is Results(3);

   -- output glitch detection variables
   VARIABLE AS_GlitchData	: VitalGlitchDataType;
   VARIABLE SH_GlitchData	: VitalGlitchDataType;
   VARIABLE NOP_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      AS_zd := TO_X01(B2_ipd);
      SH_zd :=
       ((B1_ipd) AND ((NOT B2_ipd)) AND (B0_ipd)) OR (((NOT B1_ipd)) AND
         (B2_ipd) AND ((NOT B0_ipd)));
      NOP_zd :=
       ((B1_ipd) AND (B2_ipd) AND (B0_ipd)) OR (((NOT B1_ipd)) AND ((NOT
         B2_ipd)) AND ((NOT B0_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => AS,
       GlitchData => AS_GlitchData,
       OutSignalName => "AS",
       OutTemp => AS_zd,
       Paths => (0 => (B0_ipd'last_event, tpd_B0_AS, TRUE),
                 1 => (B1_ipd'last_event, tpd_B1_AS, TRUE),
                 2 => (B2_ipd'last_event, tpd_B2_AS, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => SH,
       GlitchData => SH_GlitchData,
       OutSignalName => "SH",
       OutTemp => SH_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_SH, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_SH, TRUE),
                 2 => (B1_ipd'last_event, tpd_B1_SH, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => NOP,
       GlitchData => NOP_GlitchData,
       OutSignalName => "NOP",
       OutTemp => NOP_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_NOP, TRUE),
                 1 => (B0_ipd'last_event, tpd_B0_NOP, TRUE),
                 2 => (B1_ipd'last_event, tpd_B1_NOP, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_RCD_VITAL of CCU_RCD is
   for VITAL
   end for;
end CFG_CCU_RCD_VITAL;


----- CELL CCU_RCD_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_RCD_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_B2_AS                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_AS                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B2_SH                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_SH                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B2_NOP                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_B1_NOP                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_B2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      B1                             :	in    STD_ULOGIC;
      B2                             :	in    STD_ULOGIC;
      AS                             :	out   STD_ULOGIC;
      SH                             :	out   STD_ULOGIC;
      NOP                            :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_RCD_LSB : entity is TRUE;
end CCU_RCD_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_RCD_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL B1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL B2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (B1_ipd, B1, tipd_B1);
   VitalWireDelay (B2_ipd, B2, tipd_B2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (B1_ipd, B2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 3) := (others => 'X');
   ALIAS AS_zd : STD_LOGIC is Results(1);
   ALIAS SH_zd : STD_LOGIC is Results(2);
   ALIAS NOP_zd : STD_LOGIC is Results(3);

   -- output glitch detection variables
   VARIABLE AS_GlitchData	: VitalGlitchDataType;
   VARIABLE SH_GlitchData	: VitalGlitchDataType;
   VARIABLE NOP_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      AS_zd := TO_X01(B2_ipd);
      SH_zd := ((NOT B1_ipd)) AND (B2_ipd);
      NOP_zd := ((NOT B1_ipd)) AND ((NOT B2_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => AS,
       GlitchData => AS_GlitchData,
       OutSignalName => "AS",
       OutTemp => AS_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_AS, TRUE),
                 1 => (B1_ipd'last_event, tpd_B1_AS, TRUE)),

       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => SH,
       GlitchData => SH_GlitchData,
       OutSignalName => "SH",
       OutTemp => SH_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_SH, TRUE),
                 1 => (B1_ipd'last_event, tpd_B1_SH, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => NOP,
       GlitchData => NOP_GlitchData,
       OutSignalName => "NOP",
       OutTemp => NOP_zd,
       Paths => (0 => (B2_ipd'last_event, tpd_B2_NOP, TRUE),
                 1 => (B1_ipd'last_event, tpd_B1_NOP, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_RCD_LSB_VITAL of CCU_RCD_LSB is
   for VITAL
   end for;
end CFG_CCU_RCD_LSB_VITAL;


----- CELL CCU_UCP -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UCP is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_SD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_S0                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_COUT                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOAD                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LOAD                           :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UCP : entity is TRUE;
end CCU_UCP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UCP is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LOAD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LOAD_ipd, LOAD, tipd_LOAD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SD_ipd, LOAD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (CIN_ipd) XOR ((((NOT LOAD_ipd)) AND (D_ipd)) OR ((LOAD_ipd) AND
         (SD_ipd)));
      COUT_zd := ((((NOT LOAD_ipd)) AND (D_ipd)) OR ((LOAD_ipd) AND
         (SD_ipd))) AND (CIN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (SD_ipd'last_event, tpd_SD_S0, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_S0, TRUE),
                 2 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 3 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (LOAD_ipd'last_event, tpd_LOAD_COUT, TRUE),
                 1 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE),
       		 3 => (SD_ipd'last_event, tpd_SD_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UCP_VITAL of CCU_UCP is
   for VITAL
   end for;
end CFG_CCU_UCP_VITAL;


----- CELL CCU_UDC -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UDC is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_UD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      UD                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UDC : entity is TRUE;
end CCU_UDC;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UDC is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL UD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (UD_ipd, UD, tipd_UD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, UD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := ((NOT UD_ipd)) XOR (D_ipd) XOR (CIN_ipd);
      COUT_zd :=
       ((CIN_ipd) AND (D_ipd)) OR (((NOT UD_ipd)) AND (D_ipd)) OR ((CIN_ipd)
         AND ((NOT UD_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (UD_ipd'last_event, tpd_UD_S0, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (UD_ipd'last_event, tpd_UD_COUT, TRUE),
                 2 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UDC_VITAL of CCU_UDC is
   for VITAL
   end for;
end CFG_CCU_UDC_VITAL;


----- CELL CCU_UDCP -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CCU_UDCP is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := False;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_S0                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_LOAD_COUT                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_UD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SD_S0                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_SD_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                   :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOAD                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_UD                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      SD                             :	in    STD_ULOGIC;
      LOAD                           :	in    STD_ULOGIC;
      UD                             :	in    STD_ULOGIC;
      CIN                            :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CCU_UDCP : entity is TRUE;
end CCU_UDCP;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CCU_UDCP is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL SD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL LOAD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL UD_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (SD_ipd, SD, tipd_SD);
   VitalWireDelay (LOAD_ipd, LOAD, tipd_LOAD);
   VitalWireDelay (UD_ipd, UD, tipd_UD);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, SD_ipd, LOAD_ipd, UD_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd :=
       (((CIN_ipd) XOR (NOT (UD_ipd)) XOR (D_ipd)) AND (NOT (LOAD_ipd))) OR
         ((SD_ipd) AND (LOAD_ipd));
      COUT_zd :=
       (((CIN_ipd) AND (D_ipd)) OR (((NOT UD_ipd)) AND (D_ipd)) OR (((NOT
         UD_ipd)) AND (CIN_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_S0, TRUE),
                 2 => (UD_ipd'last_event, tpd_UD_S0, TRUE),
                 3 => (SD_ipd'last_event, tpd_SD_S0, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (LOAD_ipd'last_event, tpd_LOAD_COUT, TRUE),
                 2 => (UD_ipd'last_event, tpd_UD_COUT, TRUE),
                 3 => (SD_ipd'last_event, tpd_SD_COUT, TRUE),
                 4 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CCU_UDCP_VITAL of CCU_UDCP is
   for VITAL
   end for;
end CFG_CCU_UDCP_VITAL;


----- CELL GCLKBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GCLKBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GCLKBUF : entity is TRUE;
end GCLKBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GCLKBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CI_ipd, CI, tipd_CI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (CI_ipd'last_event, tpd_CI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GCLKBUF_VITAL of GCLKBUF is
   for VITAL
   end for;
end CFG_GCLKBUF_VITAL;

----- CELL GCLKBUFI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity GCLKBUFI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GCLKBUFI : entity is TRUE;
end GCLKBUFI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GCLKBUFI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GCLKBUFI_VITAL of GCLKBUFI is
   for VITAL
   end for;
end CFG_GCLKBUFI_VITAL;

----- CELL GSRBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_SRI_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SRI                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      SRI                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUF : entity is TRUE;
end GSRBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GSRBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL SRI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (SRI_ipd, SRI, tipd_SRI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (SRI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(SRI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (SRI_ipd'last_event, tpd_SRI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GSRBUF_VITAL of GSRBUF is
   for VITAL
   end for;
end CFG_GSRBUF_VITAL;

----- CELL GSRBUFINV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUFINV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_SRI_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_SRI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      SRI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUFINV : entity is TRUE;
end GSRBUFINV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GSRBUFINV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL SRI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (SRI_ipd, SRI, tipd_SRI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (SRI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT SRI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (SRI_ipd'last_event, tpd_SRI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GSRBUFINV_VITAL of GSRBUFINV is
   for VITAL
   end for;
end CFG_GSRBUFINV_VITAL;

----- CELL GSRBUFI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUFI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUFI : entity is TRUE;
end GSRBUFI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GSRBUFI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GSRBUFI_VITAL of GSRBUFI is
   for VITAL
   end for;
end CFG_GSRBUFI_VITAL;

----- CELL GSRBUFIINV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSRBUFIINV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSRBUFIINV : entity is TRUE;
end GSRBUFIINV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GSRBUFIINV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GSRBUFIINV_VITAL of GSRBUFIINV is
   for VITAL
   end for;
end CFG_GSRBUFIINV_VITAL;

----- CELL SRBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SRBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CI                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SRBUF : entity is TRUE;
end SRBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of SRBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CI_ipd, CI, tipd_CI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(CI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (CI_ipd'last_event, tpd_CI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_SRBUF_VITAL of SRBUF is
   for VITAL
   end for;
end CFG_SRBUF_VITAL;

----- CELL SRBUFINV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SRBUFINV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_CI_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      CI                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SRBUFINV : entity is TRUE;
end SRBUFINV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of SRBUFINV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL CI_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (CI_ipd, CI, tipd_CI);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (CI_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT CI_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (CI_ipd'last_event, tpd_CI_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_SRBUFINV_VITAL of SRBUFINV is
   for VITAL
   end for;
end CFG_SRBUFINV_VITAL;


----- CELL SRBUFI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SRBUFI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SRBUFI : entity is TRUE;
end SRBUFI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of SRBUFI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_SRBUFI_VITAL of SRBUFI is
   for VITAL
   end for;
end CFG_SRBUFI_VITAL;

----- CELL SRBUFIINV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity SRBUFIINV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of SRBUFIINV : entity is TRUE;
end SRBUFIINV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of SRBUFIINV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_SRBUFIINV_VITAL of SRBUFIINV is
   for VITAL
   end for;
end CFG_SRBUFIINV_VITAL;


----- CELL CYAND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CYAND2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CYAND2 : entity is TRUE;
end CYAND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CYAND2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CYAND2_VITAL of CYAND2 is
   for VITAL
   end for;
end CFG_CYAND2_VITAL;


----- CELL CYXOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity CYXOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of CYXOR2 : entity is TRUE;
end CYXOR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of CYXOR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) XOR (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_CYXOR2_VITAL of CYXOR2 is
   for VITAL
   end for;
end CFG_CYXOR2_VITAL;


----- CELL DC_LSB -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity DC_LSB is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_S0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_S0                  :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_D_COUT                     :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_CIN_COUT                :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CIN                    :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      CIN                         :	in    STD_ULOGIC;
      S0                             :	out   STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of DC_LSB : entity is TRUE;
end DC_LSB;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of DC_LSB is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_ULOGIC := 'X';
   SIGNAL CIN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (D_ipd, D, tipd_D);
   VitalWireDelay (CIN_ipd, CIN, tipd_CIN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CIN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   ALIAS S0_zd : STD_LOGIC is Results(1);
   ALIAS COUT_zd : STD_LOGIC is Results(2);

   -- output glitch detection variables
   VARIABLE S0_GlitchData	: VitalGlitchDataType;
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      S0_zd := (CIN_ipd) XOR (D_ipd);
      COUT_zd := (CIN_ipd) AND (D_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => S0,
       GlitchData => S0_GlitchData,
       OutSignalName => "S0",
       OutTemp => S0_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_S0, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_S0, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (D_ipd'last_event, tpd_D_COUT, TRUE),
                 1 => (CIN_ipd'last_event, tpd_CIN_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_DC_LSB_VITAL of DC_LSB is
   for VITAL
   end for;
end CFG_DC_LSB_VITAL;

----- CELL GND -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GND is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True);

   port(
      X                              :	out   STD_ULOGIC := '0');
attribute VITAL_LEVEL0 of GND : entity is TRUE;
end GND;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GND is
   attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;


begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   --  empty
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   X <= '0';


end VITAL;

configuration CFG_GND_VITAL of GND is
   for VITAL
   end for;
end CFG_GND_VITAL;

----- CELL GSROR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity GSROR2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of GSROR2 : entity is TRUE;
end GSROR2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of GSROR2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) OR (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_GSROR2_VITAL of GSROR2 is
   for VITAL
   end for;
end CFG_GSROR2_VITAL;


----- CELL IBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity IBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of IBUF : entity is TRUE;
end IBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of IBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_IBUF_VITAL of IBUF is
   for VITAL
   end for;
end CFG_IBUF_VITAL;

----- CELL IBUFINV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity IBUFINV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of IBUFINV : entity is TRUE;
end IBUFINV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of IBUFINV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_IBUFINV_VITAL of IBUFINV is
   for VITAL
   end for;
end CFG_IBUFINV_VITAL;

----- VITAL model for cell LVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIN : entity is FALSE;
end LVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
-- -- use MACH.VTABLES.all;
architecture VITAL of LVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIN_VITAL of LVDSIN is 
        for VITAL
        end for; 
end CFG_LVDSIN_VITAL;

----- VITAL model for cell LVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity LVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSOUT : entity is FALSE;
end LVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
-- use MACH.VTABLES.all;
architecture VITAL of LVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSOUT_VITAL of LVDSOUT is 
        for VITAL
        end for; 
end CFG_LVDSOUT_VITAL;

----- VITAL model for cell LVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSTRI : entity is FALSE;
end LVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
--use MACH.VTABLES.all;
architecture VITAL of LVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_LVDSTRI_VITAL of LVDSTRI is 
        for VITAL
        end for; 
end CFG_LVDSTRI_VITAL;

----- VITAL model for cell LVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity LVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVDSIO : entity is FALSE;
end LVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
--use MACH.VTABLES.all;
architecture VITAL of LVDSIO is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVDSIO_VITAL of LVDSIO is 
        for VITAL
        end for; 
end CFG_LVDSIO_VITAL;

----- VITAL model for cell LVPECLIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVPECLIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLIN : entity is FALSE;
end LVPECLIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
-- -- use MACH.VTABLES.all;
architecture VITAL of LVPECLIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVPECLIN_VITAL of LVPECLIN is 
        for VITAL
        end for; 
end CFG_LVPECLIN_VITAL;

----- VITAL model for cell LVPECLOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity LVPECLOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLOUT : entity is FALSE;
end LVPECLOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
-- use MACH.VTABLES.all;
architecture VITAL of LVPECLOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_LVPECLOUT_VITAL of LVPECLOUT is 
        for VITAL
        end for; 
end CFG_LVPECLOUT_VITAL;

----- VITAL model for cell LVPECLTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LVPECLTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LVPECLTRI : entity is FALSE;
end LVPECLTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
--use MACH.VTABLES.all;
architecture VITAL of LVPECLTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_LVPECLTRI_VITAL of LVPECLTRI is 
        for VITAL
        end for; 
end CFG_LVPECLTRI_VITAL;

----- VITAL model for cell BLVDSIN -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSIN is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_P_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tpd_N_IN_O                      :	VitalDelayType01 := ( 0.00 ns, 0.00 ns);
      tipd_N_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_P_IN                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      N_IN                            :	in    STD_ULOGIC;
      P_IN                            :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIN : entity is FALSE;
end BLVDSIN;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
-- -- use MACH.VTABLES.all;
architecture VITAL of BLVDSIN is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL P_IN_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (P_IN_ipd, P_IN, tipd_P_IN);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (P_IN_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(P_IN_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IN_ipd'last_event, tpd_P_IN_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSIN_VITAL of BLVDSIN is 
        for VITAL
        end for; 
end CFG_BLVDSIN_VITAL;

----- VITAL model for cell BLVDSOUT -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library LAVA1 ;
use LAVA1.VLOGTOVITAL_TABLES.all;

-- entity declaration --
entity BLVDSOUT is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_I_P_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I                             :	in    STD_ULOGIC;
      P_OUT                             :	out   STD_ULOGIC;
      N_OUT                             :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSOUT : entity is FALSE;
end BLVDSOUT;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
-- use MACH.VTABLES.all;
architecture VITAL of BLVDSOUT is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (I_ipd'last_event, tpd_I_P_OUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSOUT_VITAL of BLVDSOUT is 
        for VITAL
        end for; 
end CFG_BLVDSOUT_VITAL;

----- VITAL model for cell BLVDSTRI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity BLVDSTRI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_OUT                    :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_OUT                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                            :	in    STD_ULOGIC;
      P_OUT                          :	out   STD_ULOGIC;
      N_OUT                          :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSTRI : entity is FALSE;
end BLVDSTRI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
--use MACH.VTABLES.all;
architecture VITAL of BLVDSTRI is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => I_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_OUT,
       GlitchData => O_GlitchData,
       OutSignalName => "P_OUT",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_OUT), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_OUT), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;
end VITAL;

configuration CFG_BLVDSTRI_VITAL of BLVDSTRI is 
        for VITAL
        end for; 
end CFG_BLVDSTRI_VITAL;

----- VITAL model for cell BLVDSIO -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

-- entity declaration --
entity BLVDSIO is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := True;
      MsgOn: Boolean := True;
      tpd_OE_P_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE_N_IO                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_I_P_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_I_N_IO                      :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_P_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_N_IO_O                       :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_I                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_OE                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_P_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tipd_N_IO                        :	VitalDelayType01 := (0.0 ns, 0.0 ns));

   port(
      I                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      P_IO                             :	inout STD_ULOGIC;
      N_IO                             :	inout STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of BLVDSIO : entity is FALSE;
end BLVDSIO;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library LAVA1;
--use MACH.VTABLES.all;
architecture VITAL of BLVDSIO is
   attribute VITAL_LEVEL1 of VITAL : architecture is FALSE;

   SIGNAL I_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';
   SIGNAL P_IO_ipd	 : STD_ULOGIC := 'X';
   SIGNAL N_IO_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I_ipd, I, tipd_I);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   VitalWireDelay (P_IO_ipd, P_IO, tipd_P_IO);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I_ipd, OE_ipd, P_IO_ipd)


   -- functionality results
--   VARIABLE Results : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
     VARIABLE IO_zd : std_ulogic ;
     VARIABLE O_zd : std_ulogic ;

   -- output glitch detection variables
   VARIABLE IO_GlitchData	: VitalGlitchDataType;
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      IO_zd := VitalBUFIF1 (I_ipd, OE_ipd);
      O_zd := VitalBUF(P_IO_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => P_IO,
       GlitchData => IO_GlitchData,
       OutSignalName => "P_IO",
       OutTemp => IO_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_P_IO), TRUE),
                 1 => (I_ipd'last_event, VitalExtendToFillDelay(tpd_I_P_IO), TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (P_IO_ipd'last_event, tpd_P_IO_O, TRUE)),
       Mode => VitalInertial,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;
end VITAL;

configuration CFG_BLVDSIO_VITAL of BLVDSIO is 
        for VITAL
        end for; 
end CFG_BLVDSIO_VITAL;

----- CELL INV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INV : entity is TRUE;
end INV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of INV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_INV_VITAL of INV is
   for VITAL
   end for;
end CFG_INV_VITAL;


----- CELL INVTH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INVTH is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_O                       :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTH : entity is TRUE;
end INVTH;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of INVTH is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => (NOT I0_ipd),
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;

end VITAL;

configuration CFG_INVTH_VITAL of INVTH is
   for VITAL
   end for;
end CFG_INVTH_VITAL;


----- CELL INVTL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity INVTL is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_OE_O                       :	VitalDelayType01z := (0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns, 0.010 ns);
      tpd_I0_O                       :	VitalDelayType01 := (0.010 ns, 0.010 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      OE                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of INVTL : entity is TRUE;
end INVTL;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of INVTL is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL OE_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (OE_ipd, OE, tipd_OE);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalBUFIF0 (data => (NOT I0_ipd),
              enable => OE_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01Z (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_O), TRUE),
                 1 => (I0_ipd'last_event, VitalExtendToFillDelay(tpd_I0_O), TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING,
       OutputMap => "UX01ZWLH-");

end process;

end VITAL;

configuration CFG_INVTL_VITAL of INVTL is
   for VITAL
   end for;
end CFG_INVTL_VITAL;


----- CELL LSB_CY -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LSB_CY is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LSB_CY : entity is TRUE;
end LSB_CY;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of LSB_CY is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS COUT_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      COUT_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LSB_CY_VITAL of LSB_CY is
   for VITAL
   end for;
end CFG_LSB_CY_VITAL;


----- CELL LSB_CYI -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity LSB_CYI is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_COUT                    :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      COUT                           :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of LSB_CYI : entity is TRUE;
end LSB_CYI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of LSB_CYI is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS COUT_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE COUT_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      COUT_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => COUT,
       GlitchData => COUT_GlitchData,
       OutSignalName => "COUT",
       OutTemp => COUT_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_COUT, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_LSB_CYI_VITAL of LSB_CYI is
   for VITAL
   end for;
end CFG_LSB_CYI_VITAL;

----- CELL MULTAND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MULTAND2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MULTAND2 : entity is TRUE;
end MULTAND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MULTAND2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (I1_ipd) AND (I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MULTAND2_VITAL of MULTAND2 is
   for VITAL
   end for;
end CFG_MULTAND2_VITAL;


----- CELL MUX2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX2 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX2 : entity is TRUE;
end MUX2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX2 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX2_VITAL of MUX2 is
   for VITAL
   end for;
end CFG_MUX2_VITAL;

----- CELL MUXL6C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUXL6C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUXL6C : entity is TRUE;
end MUXL6C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUXL6C is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUXL6C_VITAL of MUXL6C is
   for VITAL
   end for;
end CFG_MUXL6C_VITAL;


----- CELL MUX2A -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX2A is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX2A : entity is TRUE;
end MUX2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX2A is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((S0_ipd) AND (I1_ipd)) OR (((NOT S0_ipd)) AND ((NOT I0_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX2A_VITAL of MUX2A is
   for VITAL
   end for;
end CFG_MUX2A_VITAL;


----- CELL MUX2B -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX2B is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX2B : entity is TRUE;
end MUX2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX2B is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((S0_ipd) AND ((NOT I1_ipd))) OR (((NOT S0_ipd)) AND (I0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX2B_VITAL of MUX2B is
   for VITAL
   end for;
end CFG_MUX2B_VITAL;


----- CELL MUX4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX4 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX4 : entity is TRUE;
end MUX4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX4 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, S0_ipd, S1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I3_ipd, I2_ipd, I1_ipd, I0_ipd),
                  dselect => (S1_ipd, S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 5 => (S1_ipd'last_event, tpd_S1_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX4_VITAL of MUX4 is
   for VITAL
   end for;
end CFG_MUX4_VITAL;


----- CELL MUX8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX8 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      S2                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX8 : entity is TRUE;
end MUX8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX8 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S2_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   VitalWireDelay (S2_ipd, S2, tipd_S2);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd, S0_ipd, S1_ipd, S2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I7_ipd, I6_ipd, I5_ipd, I4_ipd, I3_ipd, I2_ipd, I1_ipd, I0_ipd),
                  dselect => (S2_ipd, S1_ipd, S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE),
                 8 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 9 => (S1_ipd'last_event, tpd_S1_O, TRUE),
                 10 => (S2_ipd'last_event, tpd_S2_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX8_VITAL of MUX8 is
   for VITAL
   end for;
end CFG_MUX8_VITAL;


----- CELL MUX8C -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX8C is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_MI_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_MI                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      MI                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      S2                             :	in    STD_ULOGIC;
      S3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX8C : entity is TRUE;
end MUX8C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX8C is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';
   SIGNAL MI_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   VitalWireDelay (MI_ipd, MI, tipd_MI);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   VitalWireDelay (S2_ipd, S2, tipd_S2);
   VitalWireDelay (S3_ipd, S3, tipd_S3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd, MI_ipd, S0_ipd, S1_ipd, S2_ipd, S3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((S3_ipd) AND (MI_ipd)) OR ((((S0_ipd) AND (I1_ipd) AND ((NOT
         S1_ipd)) AND ((NOT S2_ipd))) OR (((NOT S0_ipd)) AND (I0_ipd) AND
         ((NOT S1_ipd)) AND ((NOT S2_ipd))) OR (((NOT S0_ipd)) AND (I2_ipd)
         AND (S1_ipd) AND ((NOT S2_ipd))) OR ((S0_ipd) AND (I3_ipd) AND
         (S1_ipd) AND ((NOT S2_ipd))) OR (((NOT S0_ipd)) AND (I4_ipd) AND
         ((NOT S1_ipd)) AND (S2_ipd)) OR ((S0_ipd) AND (I5_ipd) AND ((NOT
         S1_ipd)) AND (S2_ipd)) OR (((NOT S0_ipd)) AND (I6_ipd) AND (S1_ipd)
         AND (S2_ipd)) OR ((S0_ipd) AND (I7_ipd) AND (S1_ipd) AND (S2_ipd)))
         AND ((NOT S3_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE),
                 8 => (MI_ipd'last_event, tpd_MI_O, TRUE),
                 9 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 10 => (S1_ipd'last_event, tpd_S1_O, TRUE),
                 11 => (S2_ipd'last_event, tpd_S2_O, TRUE),
                 12 => (S3_ipd'last_event, tpd_S3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX8C_VITAL of MUX8C is
   for VITAL
   end for;
end CFG_MUX8C_VITAL;


----- CELL MUX16 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUX16 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I4_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I5_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I6_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I7_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I8_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I9_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I10_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I11_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I12_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I13_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I14_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I15_O                      :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S2_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S3_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I8                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I9                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I12                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I13                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I14                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I15                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      I2                             :	in    STD_ULOGIC;
      I3                             :	in    STD_ULOGIC;
      I4                             :	in    STD_ULOGIC;
      I5                             :	in    STD_ULOGIC;
      I6                             :	in    STD_ULOGIC;
      I7                             :	in    STD_ULOGIC;
      I8                             :	in    STD_ULOGIC;
      I9                             :	in    STD_ULOGIC;
      I10                            :	in    STD_ULOGIC;
      I11                            :	in    STD_ULOGIC;
      I12                            :	in    STD_ULOGIC;
      I13                            :	in    STD_ULOGIC;
      I14                            :	in    STD_ULOGIC;
      I15                            :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      S1                             :	in    STD_ULOGIC;
      S2                             :	in    STD_ULOGIC;
      S3                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUX16 : entity is TRUE;
end MUX16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUX16 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I3_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I4_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I5_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I6_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I7_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I8_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I9_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I10_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I11_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I12_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I13_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I14_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I15_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S2_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S3_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (I2_ipd, I2, tipd_I2);
   VitalWireDelay (I3_ipd, I3, tipd_I3);
   VitalWireDelay (I4_ipd, I4, tipd_I4);
   VitalWireDelay (I5_ipd, I5, tipd_I5);
   VitalWireDelay (I6_ipd, I6, tipd_I6);
   VitalWireDelay (I7_ipd, I7, tipd_I7);
   VitalWireDelay (I8_ipd, I8, tipd_I8);
   VitalWireDelay (I9_ipd, I9, tipd_I9);
   VitalWireDelay (I10_ipd, I10, tipd_I10);
   VitalWireDelay (I11_ipd, I11, tipd_I11);
   VitalWireDelay (I12_ipd, I12, tipd_I12);
   VitalWireDelay (I13_ipd, I13, tipd_I13);
   VitalWireDelay (I14_ipd, I14, tipd_I14);
   VitalWireDelay (I15_ipd, I15, tipd_I15);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   VitalWireDelay (S1_ipd, S1, tipd_S1);
   VitalWireDelay (S2_ipd, S2, tipd_S2);
   VitalWireDelay (S3_ipd, S3, tipd_S3);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, I2_ipd, I3_ipd, I4_ipd, I5_ipd, I6_ipd, I7_ipd, I8_ipd, I9_ipd, I10_ipd, I11_ipd, I12_ipd, I13_ipd, I14_ipd, I15_ipd, S0_ipd, S1_ipd, S2_ipd, S3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd :=
       ((((S0_ipd) AND (I9_ipd) AND ((NOT S1_ipd)) AND ((NOT S2_ipd))) OR
         (((NOT S0_ipd)) AND (I8_ipd) AND ((NOT S1_ipd)) AND ((NOT S2_ipd)))
         OR (((NOT S0_ipd)) AND (I10_ipd) AND (S1_ipd) AND (S2_ipd)) OR
         ((S0_ipd) AND (I11_ipd) AND (S1_ipd) AND (S2_ipd)) OR (((NOT
         S0_ipd)) AND (I12_ipd) AND ((NOT S1_ipd)) AND (S2_ipd)) OR ((S0_ipd)
         AND (I13_ipd) AND ((NOT S1_ipd)) AND (S2_ipd)) OR (((NOT S0_ipd))
         AND (I14_ipd) AND (S1_ipd) AND (S2_ipd)) OR ((S0_ipd) AND (I15_ipd)
         AND (S1_ipd) AND (S2_ipd))) AND (S3_ipd)) OR ((((S0_ipd) AND
         (I1_ipd) AND ((NOT S1_ipd)) AND ((NOT S2_ipd))) OR (((NOT S0_ipd))
         AND (I0_ipd) AND ((NOT S1_ipd)) AND ((NOT S2_ipd))) OR (((NOT
         S0_ipd)) AND (I2_ipd) AND (S1_ipd) AND (S2_ipd)) OR ((S0_ipd) AND
         (I3_ipd) AND (S1_ipd) AND (S2_ipd)) OR (((NOT S0_ipd)) AND (I4_ipd)
         AND ((NOT S1_ipd)) AND (S2_ipd)) OR ((S0_ipd) AND (I5_ipd) AND ((NOT
         S1_ipd)) AND (S2_ipd)) OR (((NOT S0_ipd)) AND (I6_ipd) AND (S1_ipd)
         AND (S2_ipd)) OR ((S0_ipd) AND (I7_ipd) AND (S1_ipd) AND (S2_ipd)))
         AND ((NOT S3_ipd)));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (I2_ipd'last_event, tpd_I2_O, TRUE),
                 3 => (I3_ipd'last_event, tpd_I3_O, TRUE),
                 4 => (I4_ipd'last_event, tpd_I4_O, TRUE),
                 5 => (I5_ipd'last_event, tpd_I5_O, TRUE),
                 6 => (I6_ipd'last_event, tpd_I6_O, TRUE),
                 7 => (I7_ipd'last_event, tpd_I7_O, TRUE),
                 8 => (I8_ipd'last_event, tpd_I8_O, TRUE),
                 9 => (I9_ipd'last_event, tpd_I9_O, TRUE),
                 10 => (I10_ipd'last_event, tpd_I10_O, TRUE),
                 11 => (I11_ipd'last_event, tpd_I11_O, TRUE),
                 12 => (I12_ipd'last_event, tpd_I12_O, TRUE),
                 13 => (I13_ipd'last_event, tpd_I13_O, TRUE),
                 14 => (I14_ipd'last_event, tpd_I14_O, TRUE),
                 15 => (I15_ipd'last_event, tpd_I15_O, TRUE),
                 16 => (S0_ipd'last_event, tpd_S0_O, TRUE),
                 17 => (S1_ipd'last_event, tpd_S1_O, TRUE),
                 18 => (S2_ipd'last_event, tpd_S2_O, TRUE),
                 19 => (S3_ipd'last_event, tpd_S3_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUX16_VITAL of MUX16 is
   for VITAL
   end for;
end CFG_MUX16_VITAL;


----- CELL MUXL5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUXL5 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUXL5 : entity is TRUE;
end MUXL5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUXL5 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUXL5_VITAL of MUXL5 is
   for VITAL
   end for;
end CFG_MUXL5_VITAL;


----- CELL MUXL6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity MUXL6 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_I1_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_S0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      I1                             :	in    STD_ULOGIC;
      S0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of MUXL6 : entity is TRUE;
end MUXL6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of MUXL6 is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';
   SIGNAL I1_ipd	 : STD_ULOGIC := 'X';
   SIGNAL S0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   VitalWireDelay (I1_ipd, I1, tipd_I1);
   VitalWireDelay (S0_ipd, S0, tipd_S0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd, I1_ipd, S0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := VitalMUX
                 (data => (I1_ipd, I0_ipd),
                  dselect => (0 => S0_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE),
                 1 => (I1_ipd'last_event, tpd_I1_O, TRUE),
                 2 => (S0_ipd'last_event, tpd_S0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_MUXL6_VITAL of MUXL6 is
   for VITAL
   end for;
end CFG_MUXL6_VITAL;


----- CELL OBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OBUF is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OBUF : entity is TRUE;
end OBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of OBUF is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := TO_X01(I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_OBUF_VITAL of OBUF is
   for VITAL
   end for;
end CFG_OBUF_VITAL;

----- CELL OBUFINV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


-- entity declaration --
entity OBUFINV is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_I0_O                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_I0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      I0                             :	in    STD_ULOGIC;
      O                              :	out   STD_ULOGIC);
attribute VITAL_LEVEL0 of OBUFINV : entity is TRUE;
end OBUFINV;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of OBUFINV is
   attribute VITAL_LEVEL1 of VITAL : architecture is TRUE;

   SIGNAL I0_ipd	 : STD_ULOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   WireDelay : block
   begin
   VitalWireDelay (I0_ipd, I0, tipd_I0);
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (I0_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS O_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE O_GlitchData	: VitalGlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      O_zd := (NOT I0_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPathDelay01 (
       OutSignal => O,
       GlitchData => O_GlitchData,
       OutSignalName => "O",
       OutTemp => O_zd,
       Paths => (0 => (I0_ipd'last_event, tpd_I0_O, TRUE)),
       Mode => OnDetect,
       Xon => Xon,
       MsgOn => MsgOn,
       MsgSeverity => WARNING);

end process;

end VITAL;

configuration CFG_OBUFINV_VITAL of OBUFINV is
   for VITAL
   end for;
end CFG_OBUFINV_VITAL;

----- CELL RAM16X1D -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
use IEEE.VITAL_Timing.all; 
use IEEE.VITAL_Primitives.all;

library lava1;
use lava1.RAM_PACKAGE.all;

entity RAM16X1D is

  generic (
       TimingChecksOn: Boolean := TRUE;
       InstancePath:   STRING  := "*";
       Xon:  Boolean := True;
       MsgOn:  Boolean := False;

       tipd_AD0                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD1                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD2                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD3                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD0                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD1                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD2                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD3                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WDATA                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WE                           :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WCLK                         :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tpd_AD0_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD1_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD2_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD3_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_RDATA                    :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD0_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD1_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tpd_DPAD2_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD3_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_DPRDATA                  :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tsetup_WDATA_WCLK_noedge_posedge  :      VitalDelayType := 0.1 ns;
       thold_WDATA_WCLK_noedge_posedge   :      VitalDelayType := 0.0 ns;
       tsetup_WE_WCLK_noedge_posedge     :      VitalDelayType := 0.1 ns;
       thold_WE_WCLK_noedge_posedge      :      VitalDelayType := 0.0 ns;
       tsetup_AD0_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD0_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD1_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD1_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD2_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD2_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD3_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD3_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tpw_WCLK_posedge                  :      VitalDelayType := 2.0 ns;
       tpw_WCLK_negedge                  :      VitalDelayType := 2.0 ns;

       INIT                              :      bit_vector(15 downto 0) := X"FFFF"
  );

  port (WDATA   : in std_ulogic;
        WE      : in std_ulogic;
        WCLK    : in std_ulogic;
        AD0     : in std_ulogic;
        AD1     : in std_ulogic;
        AD2     : in std_ulogic;
        AD3     : in std_ulogic;
        DPAD0   : in std_ulogic;
        DPAD1   : in std_ulogic;
        DPAD2   : in std_ulogic;
        DPAD3   : in std_ulogic;

        RDATA   : out std_ulogic;
        DPRDATA : out std_ulogic
       ); 
attribute VITAL_LEVEL0 of RAM16X1D : entity is TRUE;

end RAM16X1D;

-----------------------------------------------------------------------------

architecture VITAL of RAM16X1D is

  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

  -- Local signals used to propagate input wire delay

    signal AD0_ipd    : std_ulogic := 'X';
    signal AD1_ipd    : std_ulogic := 'X';
    signal AD2_ipd    : std_ulogic := 'X';
    signal AD3_ipd    : std_ulogic := 'X';

    signal DPAD0_ipd  : std_ulogic := 'X';
    signal DPAD1_ipd  : std_ulogic := 'X';
    signal DPAD2_ipd  : std_ulogic := 'X';
    signal DPAD3_ipd  : std_ulogic := 'X';

    signal WDATA_ipd  : std_ulogic := 'X';
    signal WE_ipd     : std_ulogic := 'X';
    signal WCLK_ipd   : std_ulogic := 'X';
    signal MEM        : std_logic_vector( 15 downto 0 ) := To_StdLogicVector(INIT);
    signal WE_AD      : std_ulogic := 'X';
    signal AD         : std_ulogic_vector(3 downto 0);
    signal DPAD       : std_ulogic_vector(3 downto 0);
    signal WDATA_c    : std_ulogic := '0';

begin -- architecture

	AD <= AD3_ipd & AD2_ipd & AD1_ipd & AD0_ipd ;
	DPAD <= DPAD3_ipd & DPAD2_ipd & DPAD1_ipd & DPAD0_ipd ;

  ----------------------
  --  Wire Delay Section
  ----------------------
  WireDelay : block
  begin
    VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
    VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
    VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
    VitalWireDelay (AD3_ipd, AD3, tipd_AD3);

    VitalWireDelay (DPAD0_ipd, DPAD0, tipd_DPAD0);
    VitalWireDelay (DPAD1_ipd, DPAD1, tipd_DPAD1);
    VitalWireDelay (DPAD2_ipd, DPAD2, tipd_DPAD2);
    VitalWireDelay (DPAD3_ipd, DPAD3, tipd_DPAD3);

    VitalWireDelay (WDATA_ipd, WDATA, tipd_WDATA);
    VitalWireDelay (WE_ipd,    WE,    tipd_WE);
    VitalWireDelay (WCLK_ipd,  WCLK,  tipd_WCLK);
  end block;

process(WE_ipd,AD,WCLK_ipd,DPAD)
begin
if (WE_ipd = '1' and WCLK_ipd'event and WCLK_ipd='1' and AD = DPAD) then
	  WE_AD <= '1';
else
	  WE_AD <= '0';
end if;
end process;

process(WE_ipd, WCLK_ipd, WDATA_ipd)
begin
if (WCLK_ipd'event and WCLK_ipd='1') then
    if (WE_ipd = '1') then
	  WDATA_c <= WDATA_ipd;
    end if;
end if;
end process;


 VITALBehavior_Write : process

    -- Local variables used for functionality
    variable Index_A       : integer := 16;
    variable Index_B       : integer := 16;
    variable PrevData      : std_logic_vector(0 to 4) := (others => '0');
    variable WE_prev       : std_ulogic := 'X';
    variable WCLK_prev     : std_ulogic := 'X';
    variable WDATA_prev    : std_ulogic := 'X';
    variable Initial       : boolean := TRUE;

    -- Local variables used for timing checks
    variable Tviol_WDATA_WCLK_posedge  : std_ulogic := '0';
    variable Tviol_WE_WCLK_posedge     : std_ulogic := '0';
    variable Tviol_AD0_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD1_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD2_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD3_WCLK_posedge    : std_ulogic := '0';

    variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

    variable PViol_WCLK                : std_ulogic := '0';
    variable PInfo_WCLK                : VitalPeriodDataType := VitalPeriodDataInit;

    -- Local variables used for functionality
    variable OA_zd                     : std_ulogic := 'X';
    variable OB_zd                     : std_ulogic := 'X';
    variable WE_inverted               : std_ulogic := 'X';
    variable Violation                 : std_ulogic := '0';

  begin -- process

    if (Initial) then
        wait until ( (WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (WE_ipd  = '0' or WE_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1') );
        WCLK_prev   := WCLK_ipd;
        WE_prev     := WE_ipd;
        WDATA_prev  := WDATA_ipd;
        Index_A     := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        OA_zd       := MEM(Index_A);
        Initial     := FALSE;

    end if;
    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn ) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_posedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_posedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_posedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_posedge,
          HoldLow                 => thold_AD0_WCLK_noedge_posedge,
          HoldHigh                => thold_AD0_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_posedge,
          HoldLow                 => thold_AD1_WCLK_noedge_posedge,
          HoldHigh                => thold_AD1_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_posedge,
          HoldLow                 => thold_AD2_WCLK_noedge_posedge,
          HoldHigh                => thold_AD2_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_posedge,
          HoldLow                 => thold_AD3_WCLK_noedge_posedge,
          HoldHigh                => thold_AD3_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM16X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge or Tviol_WDATA_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index_A := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    OA_zd   := MEM(Index_A);

    VitalStateTable(Result => OA_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, OA_zd, WDATA_prev, WE_inverted, WCLK_ipd));

    OA_zd := Violation XOR OA_zd;

    --WE_prev       :=   WE_ipd;
    WE_prev       :=   WE_inverted;
    WCLK_prev     :=   WCLK_ipd;
    WDATA_prev    :=   WDATA_ipd;

    MEM(Index_A) <= OA_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, WDATA_ipd, WCLK_ipd, WE_ipd;

  end process VITALBehavior_Write;

  --------------------
  -- RAM16X1D Behavior
  --------------------
 VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, 
    DPAD0_ipd, DPAD1_ipd, DPAD2_ipd, DPAD3_ipd, MEM, WDATA_c, WE_ipd, WE_AD)

    Variable Index_A       :   integer  := 15 ;
    Variable Index_B       :   integer  := 15 ;
    Variable OA_zd         :   std_ulogic := 'X';
    Variable OA_zd1        :   std_ulogic := 'X';
    Variable OB_zd         :   std_ulogic := 'X';
    Variable OB_zd1        :   std_ulogic := 'X';
    Variable OA_GlitchData :   VitalGlitchDataType;
    Variable OB_GlitchData :   VitalGlitchDataType;

    begin -- process

    Index_A := ADDR4_TO_INT (ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    Index_B := ADDR4_TO_INT (ADDRESS => (DPAD3_ipd, DPAD2_ipd, DPAD1_ipd, DPAD0_ipd));

    OA_zd   := MEM(Index_A);
    OB_zd   := MEM(Index_B);

    OA_zd1 := VitalMUX2
		     (data0 => OA_zd, 
		      data1 => WDATA_c,
		      dselect => WE_ipd);

    OB_zd1 := VitalMUX2
		     (data0 => OB_zd, 
		      data1 => OA_zd,
		      dselect => WE_AD);

    VitalPathDelay01 (
     OutSignal => RDATA,
     GlitchData => OA_GlitchData,
     OutSignalName => "RDATA",
     OutTemp => OA_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
               1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
               2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
               3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
               4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);

     VitalPathDelay01 (
     OutSignal => DPRDATA,
     GlitchData => OB_GlitchData,
     OutSignalName => "DPRDATA",
     OutTemp => OB_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_DPRDATA, TRUE),
               1 => (DPAD0_ipd'last_event, tpd_DPAD0_DPRDATA, TRUE),
               2 => (DPAD1_ipd'last_event, tpd_DPAD1_DPRDATA, TRUE),
               3 => (DPAD2_ipd'last_event, tpd_DPAD2_DPRDATA, TRUE),
               4 => (DPAD3_ipd'last_event, tpd_DPAD3_DPRDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);
 end process VITALBehavior_Read;

end VITAL;
 
configuration CFG_RAM16X1D_VITAL of RAM16X1D is
   for VITAL
   end for;
end CFG_RAM16X1D_VITAL;


----- CELL RAM16X1D_1 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
use IEEE.VITAL_Timing.all; 
use IEEE.VITAL_Primitives.all;

library lava1;
use lava1.RAM_PACKAGE.all;

entity RAM16X1D_1 is

  generic (
       TimingChecksOn: Boolean := TRUE;
       InstancePath:   STRING  := "*";
       Xon:  Boolean := True;
       MsgOn:  Boolean := False;

       tipd_AD0                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD1                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD2                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD3                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD0                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD1                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD2                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD3                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WDATA                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WE                           :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WCLK                         :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tpd_AD0_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD1_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD2_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD3_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_RDATA                    :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD0_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD1_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tpd_DPAD2_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD3_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_DPRDATA                  :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tsetup_WDATA_WCLK_noedge_negedge  :      VitalDelayType := 0.1 ns;
       thold_WDATA_WCLK_noedge_negedge   :      VitalDelayType := 0.0 ns;
       tsetup_WE_WCLK_noedge_negedge     :      VitalDelayType := 0.1 ns;
       thold_WE_WCLK_noedge_negedge      :      VitalDelayType := 0.0 ns;
       tsetup_AD0_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD0_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD1_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD1_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD2_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD2_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD3_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD3_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tpw_WCLK_posedge                  :      VitalDelayType := 2.0 ns;
       tpw_WCLK_negedge                  :      VitalDelayType := 2.0 ns;

       INIT                              :      bit_vector(15 downto 0) := X"FFFF"
  );

  port (WDATA   : in std_ulogic;
        WE      : in std_ulogic;
        WCLK    : in std_ulogic;
        AD0     : in std_ulogic;
        AD1     : in std_ulogic;
        AD2     : in std_ulogic;
        AD3     : in std_ulogic;
        DPAD0   : in std_ulogic;
        DPAD1   : in std_ulogic;
        DPAD2   : in std_ulogic;
        DPAD3   : in std_ulogic;

        RDATA   : out std_ulogic;
        DPRDATA : out std_ulogic
       ); 
attribute VITAL_LEVEL0 of RAM16X1D_1 : entity is TRUE;

end RAM16X1D_1;

-----------------------------------------------------------------------------

architecture VITAL of RAM16X1D_1 is

  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

  -- Local signals used to propagate input wire delay

    signal AD0_ipd    : std_ulogic := 'X';
    signal AD1_ipd    : std_ulogic := 'X';
    signal AD2_ipd    : std_ulogic := 'X';
    signal AD3_ipd    : std_ulogic := 'X';

    signal DPAD0_ipd  : std_ulogic := 'X';
    signal DPAD1_ipd  : std_ulogic := 'X';
    signal DPAD2_ipd  : std_ulogic := 'X';
    signal DPAD3_ipd  : std_ulogic := 'X';

    signal WDATA_ipd  : std_ulogic := 'X';
    signal WE_ipd     : std_ulogic := 'X';
    signal WCLK_ipd   : std_ulogic := 'X';
    signal MEM        : std_logic_vector( 15 downto 0 ) := To_StdLogicVector(INIT);
    signal WE_AD      : std_ulogic := 'X';
    signal AD         : std_ulogic_vector(3 downto 0);
    signal DPAD         : std_ulogic_vector(3 downto 0);
    signal WDATA_c    : std_ulogic := '0';

begin -- architecture

	AD <= AD3_ipd & AD2_ipd & AD1_ipd & AD0_ipd ;
	DPAD <= DPAD3_ipd & DPAD2_ipd & DPAD1_ipd & DPAD0_ipd ;
  ----------------------
  --  Wire Delay Section
  ----------------------
  WireDelay : block
  begin
    VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
    VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
    VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
    VitalWireDelay (AD3_ipd, AD3, tipd_AD3);

    VitalWireDelay (DPAD0_ipd, DPAD0, tipd_DPAD0);
    VitalWireDelay (DPAD1_ipd, DPAD1, tipd_DPAD1);
    VitalWireDelay (DPAD2_ipd, DPAD2, tipd_DPAD2);
    VitalWireDelay (DPAD3_ipd, DPAD3, tipd_DPAD3);

    VitalWireDelay (WDATA_ipd, WDATA, tipd_WDATA);
    VitalWireDelay (WE_ipd,    WE,    tipd_WE);
    VitalWireDelay (WCLK_ipd,  WCLK,  tipd_WCLK);
  end block;


process(WE_ipd,AD,DPAD)
begin
if (WE_ipd = '1' and AD = DPAD) then
	  WE_AD <= '1';
else
	  WE_AD <= '0';
end if;
end process;

process(WE_ipd, WCLK_ipd, WDATA_ipd)
begin
if (WCLK_ipd'event and WCLK_ipd='1') then
    if (WE_ipd = '1') then
	  WDATA_c <= WDATA_ipd;
    end if;
end if;
end process;


 VITALBehavior_Write : process

    -- Local variables used for functionality
    variable Index_A       : integer := 16;
    variable Index_B       : integer := 16;
    variable PrevData      : std_logic_vector(0 to 4) := (others => '0');
    variable WE_prev       : std_ulogic := 'X';
    variable WCLK_prev     : std_ulogic := 'X';
    variable WDATA_prev    : std_ulogic := 'X';
    variable Initial       : boolean := TRUE;

    -- Local variables used for timing checks
    variable Tviol_WDATA_WCLK_posedge  : std_ulogic := '0';
    variable Tviol_WE_WCLK_posedge     : std_ulogic := '0';
    variable Tviol_AD0_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD1_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD2_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD3_WCLK_posedge    : std_ulogic := '0';

    variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

    variable PViol_WCLK                : std_ulogic := '0';
    variable PInfo_WCLK                : VitalPeriodDataType := VitalPeriodDataInit;

    -- Local variables used for functionality
    variable OA_zd                     : std_ulogic := 'X';
    variable OB_zd                     : std_ulogic := 'X';
    variable WE_inverted               : std_ulogic := 'X';
    variable WCLK_inverted             : std_ulogic := 'X';
    variable Violation                 : std_ulogic := '0';

  begin -- process

    if (Initial) then
        wait until ( (WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (WE_ipd  = '0' or WE_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1') );
        WCLK_prev   := WCLK_ipd;
        WE_prev     := WE_ipd;
        WDATA_prev  := WDATA_ipd;
        Index_A     := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        OA_zd       := MEM(Index_A);
        Initial     := FALSE;

    end if;
    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn ) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_negedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_negedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_negedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_negedge,
          SetupLow                => tsetup_WE_WCLK_noedge_negedge,
          HoldLow                 => thold_WE_WCLK_noedge_negedge,
          HoldHigh                => thold_WE_WCLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_negedge,
          HoldLow                 => thold_AD0_WCLK_noedge_negedge,
          HoldHigh                => thold_AD0_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_negedge,
          HoldLow                 => thold_AD1_WCLK_noedge_negedge,
          HoldHigh                => thold_AD1_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_negedge,
          HoldLow                 => thold_AD2_WCLK_noedge_negedge,
          HoldHigh                => thold_AD2_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_negedge,
          HoldLow                 => thold_AD3_WCLK_noedge_negedge,
          HoldHigh                => thold_AD3_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM16X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge or Tviol_WDATA_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index_A := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    WCLK_inverted := (NOT WCLK_ipd);
    OA_zd   := MEM(Index_A);

    VitalStateTable(Result => OA_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, OA_zd, WDATA_prev, WE_inverted, WCLK_inverted));

    OA_zd := Violation XOR OA_zd;

    --WE_prev       :=   WE_ipd;
    WE_prev       :=   WE_inverted;
--    WCLK_prev     :=   WCLK_ipd;
    WCLK_prev     :=   WCLK_inverted;
    WDATA_prev    :=   WDATA_ipd;

    MEM(Index_A) <= OA_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, WDATA_ipd, WCLK_ipd, WE_ipd;

  end process VITALBehavior_Write;

  --------------------
  -- RAM16X1D_1 Behavior
  --------------------
 VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, 
    DPAD0_ipd, DPAD1_ipd, DPAD2_ipd, DPAD3_ipd, MEM, WDATA_c, WE_ipd, WE_AD)

    Variable Index_A       :   integer  := 15 ;
    Variable Index_B       :   integer  := 15 ;
    Variable OA_zd         :   std_ulogic := 'X';
    Variable OA_zd1        :   std_ulogic := 'X';
    Variable OB_zd         :   std_ulogic := 'X';
    Variable OB_zd1        :   std_ulogic := 'X';
    Variable OA_GlitchData :   VitalGlitchDataType;
    Variable OB_GlitchData :   VitalGlitchDataType;

    begin -- process

    Index_A := ADDR4_TO_INT (ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    Index_B := ADDR4_TO_INT (ADDRESS => (DPAD3_ipd, DPAD2_ipd, DPAD1_ipd, DPAD0_ipd));

    OA_zd   := MEM(Index_A);
    OB_zd   := MEM(Index_B);

    OA_zd1 := VitalMUX2
		     (data0 => OA_zd, 
		      data1 => WDATA_c,
		      dselect => WE_ipd);

    OB_zd1 := VitalMUX2
		     (data0 => OB_zd, 
		      data1 => OA_zd,
		      dselect => WE_AD);

    VitalPathDelay01 (
     OutSignal => RDATA,
     GlitchData => OA_GlitchData,
     OutSignalName => "RDATA",
     OutTemp => OA_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
               1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
               2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
               3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
               4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);

     VitalPathDelay01 (
     OutSignal => DPRDATA,
     GlitchData => OB_GlitchData,
     OutSignalName => "DPRDATA",
     OutTemp => OB_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_DPRDATA, TRUE),
               1 => (DPAD0_ipd'last_event, tpd_DPAD0_DPRDATA, TRUE),
               2 => (DPAD1_ipd'last_event, tpd_DPAD1_DPRDATA, TRUE),
               3 => (DPAD2_ipd'last_event, tpd_DPAD2_DPRDATA, TRUE),
               4 => (DPAD3_ipd'last_event, tpd_DPAD3_DPRDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);
 end process VITALBehavior_Read;

end VITAL;
 
configuration CFG_RAM16X1D_1_VITAL of RAM16X1D_1 is
   for VITAL
   end for;
end CFG_RAM16X1D_1_VITAL;


----- CELL RAM16X1S -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


library lava1;
use lava1.RAM_PACKAGE.all;


-- entity declaration --
entity RAM16X1S is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_AD0_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD1_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD2_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD3_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_RDATA                   :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WE_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WDATA_WCLK_noedge_posedge :	VitalDelayType   := 0.1 ns;
      thold_WDATA_WCLK_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_AD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD2_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD3_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tpw_WCLK_posedge                 :	VitalDelayType   := 2.0 ns;
      tipd_WE                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WDATA                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD2                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD3                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT                             :	bit_vector := X"FFFF");

   port(
      WE                             :	in    STD_ULOGIC;
      WDATA                          :	in    STD_ULOGIC;
      WCLK                           :	in    STD_ULOGIC;
      AD0                            :	in    STD_ULOGIC;
      AD1                            :	in    STD_ULOGIC;
      AD2                            :	in    STD_ULOGIC;
      AD3                            :	in    STD_ULOGIC;
      RDATA                          :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAM16X1S : entity is TRUE;
end RAM16X1S;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAM16X1S is
  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

      signal AD0_ipd      : std_ulogic := 'X';
      signal AD1_ipd      : std_ulogic := 'X';
      signal AD2_ipd      : std_ulogic := 'X';
      signal AD3_ipd      : std_ulogic := 'X';

      signal WDATA_ipd    : std_ulogic := 'X';
      signal WE_ipd       : std_ulogic := 'X';
      signal WCLK_ipd     : std_ulogic := 'X';

      signal MEM          : std_logic_vector( 15 downto 0 ) := ( To_StdLogicVector(INIT)) ;

begin 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin
        VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
        VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
        VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
        VitalWireDelay (AD3_ipd, AD3, tipd_AD3);

        VitalWireDelay (WDATA_ipd,  WDATA, tipd_WDATA);
        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
      end block;

      --------------------
      -- RAM16X1S Write Behavior
      --------------------
      VITALBehavior_Write : process
        -- Local variables used for timing checks

        variable Tviol_WDATA_WCLK_posedge  : std_ulogic  := '0';
        variable Tviol_WE_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_AD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD3_WCLK_posedge    : std_ulogic  := '0';

        variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        variable Initial          : boolean := TRUE;
        variable Violation        : std_ulogic := '0';
        variable INIT_BITS        : std_logic_vector(15 downto 0) := To_StdLogicVector(INIT);
        variable Index            : integer := 16;
        variable PrevData         : std_logic_vector(0 to 4) := (others => '0');
        variable WE_prev          : std_ulogic := 'X';
        variable WCLK_prev        : std_ulogic := 'X';
        variable WDATA_prev       : std_ulogic := 'X';
        variable O_zd             : std_ulogic := 'X';
        variable O_GlitchData     : VitalGlitchDataType;
        variable WE_inverted      : std_ulogic := 'X';

        begin


        if (Initial) then
        wait until ((WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1'));
        WCLK_prev  := WCLK_ipd;
        WE_prev    := WE_ipd;
        WDATA_prev := WDATA_ipd;
        Index      := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
        Initial    := FALSE;
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_posedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_posedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_posedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_posedge,
          HoldLow                 => thold_AD0_WCLK_noedge_posedge,
          HoldHigh                => thold_AD0_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_posedge,
          HoldLow                 => thold_AD1_WCLK_noedge_posedge,
          HoldHigh                => thold_AD1_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_posedge,
          HoldLow                 => thold_AD2_WCLK_noedge_posedge,
          HoldHigh                => thold_AD2_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_posedge,
          HoldLow                 => thold_AD3_WCLK_noedge_posedge,
          HoldHigh                => thold_AD3_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM16X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge  or Tviol_WE_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    O_zd := MEM(Index);

    VitalStateTable(Result => O_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, O_zd, WDATA_prev, WE_inverted, WCLK_ipd));
      
    O_zd := Violation XOR O_zd;

    --WE_prev       := WE_ipd;
    WE_prev       := WE_inverted;
    WCLK_prev     := WCLK_ipd;
    WDATA_prev    := WDATA_ipd;

    MEM(Index) <= O_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, WDATA_ipd, WE_ipd, WCLK_ipd;

    end process VitalBehavior_Write;

    VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, MEM, WDATA_ipd, WE_ipd)
         Variable Index      : integer  := 15 ;
         variable O_zd      : std_ulogic := 'X';
         variable O_zd1      : std_ulogic := 'X';
         variable O_GlitchData : VitalGlitchDataType;
    begin

        Index      := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);

	O_zd1 := VitalMUX2
		     (data0 => O_zd, 
		      data1 => WDATA_ipd,
		      dselect => WE_ipd);

    VitalPathDelay01 (
      OutSignal => RDATA,
      GlitchData => O_GlitchData,
      OutSignalName => "RDATA",
      OutTemp => O_zd1,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
                1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
                2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
                3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
                4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

    end process VITALBehavior_Read;

end VITAL;

configuration CFG_RAM16X1S_VITAL of RAM16X1S is
   for VITAL
   end for;
end CFG_RAM16X1S_VITAL;


----- CELL RAM16X1S_1 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;


library lava1;
use lava1.RAM_PACKAGE.all;


-- entity declaration --
entity RAM16X1S_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_AD0_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD1_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD2_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD3_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_RDATA                   :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WE_WCLK_noedge_negedge    :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_negedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WDATA_WCLK_noedge_negedge :	VitalDelayType   := 0.1 ns;
      thold_WDATA_WCLK_noedge_negedge  :	VitalDelayType   := 0.0 ns;
      tsetup_AD0_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD0_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD1_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD1_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD2_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD2_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD3_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD3_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tpw_WCLK_negedge                 :	VitalDelayType   := 2.0 ns;
      tipd_WE                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WDATA                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD2                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD3                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT                             :	bit_vector := X"FFFF");

   port(
      WE                             :	in    STD_ULOGIC;
      WDATA                          :	in    STD_ULOGIC;
      WCLK                           :	in    STD_ULOGIC;
      AD0                            :	in    STD_ULOGIC;
      AD1                            :	in    STD_ULOGIC;
      AD2                            :	in    STD_ULOGIC;
      AD3                            :	in    STD_ULOGIC;
      RDATA                          :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAM16X1S_1 : entity is TRUE;
end RAM16X1S_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAM16X1S_1 is
  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

      signal AD0_ipd      : std_ulogic := 'X';
      signal AD1_ipd      : std_ulogic := 'X';
      signal AD2_ipd      : std_ulogic := 'X';
      signal AD3_ipd      : std_ulogic := 'X';

      signal WDATA_ipd    : std_ulogic := 'X';
      signal WE_ipd       : std_ulogic := 'X';
      signal WCLK_ipd     : std_ulogic := 'X';

      signal MEM          : std_logic_vector( 15 downto 0 ) := ( To_StdLogicVector(INIT)) ;

begin 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin
        VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
        VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
        VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
        VitalWireDelay (AD3_ipd, AD3, tipd_AD3);

        VitalWireDelay (WDATA_ipd,  WDATA, tipd_WDATA);
        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
      end block;

      --------------------
      -- RAM16X1S_1 Write Behavior
      --------------------
      VITALBehavior_Write : process
        -- Local variables used for timing checks

        variable Tviol_WDATA_WCLK_posedge  : std_ulogic  := '0';
        variable Tviol_WE_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_AD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD3_WCLK_posedge    : std_ulogic  := '0';

        variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        variable Initial          : boolean := TRUE;
        variable Violation        : std_ulogic := '0';
        variable INIT_BITS        : std_logic_vector(15 downto 0) := To_StdLogicVector(INIT);
        variable Index            : integer := 16;
        variable PrevData         : std_logic_vector(0 to 4) := (others => '0');
        variable WE_prev          : std_ulogic := 'X';
        variable WCLK_prev        : std_ulogic := 'X';
        variable WDATA_prev       : std_ulogic := 'X';
        variable O_zd             : std_ulogic := 'X';
        variable WE_inverted      : std_ulogic := 'X';
        variable WCLK_inverted    : std_ulogic := 'X';
        variable O_GlitchData     : VitalGlitchDataType;

        begin


        if (Initial) then
        wait until ((WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1'));
        WCLK_prev  := WCLK_ipd;
        WE_prev    := WE_ipd;
        WDATA_prev := WDATA_ipd;
        Index      := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
        Initial    := FALSE;
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_negedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_negedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_negedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_negedge,
          SetupLow                => tsetup_WE_WCLK_noedge_negedge,
          HoldLow                 => thold_WE_WCLK_noedge_negedge,
          HoldHigh                => thold_WE_WCLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_negedge,
          HoldLow                 => thold_AD0_WCLK_noedge_negedge,
          HoldHigh                => thold_AD0_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_negedge,
          HoldLow                 => thold_AD1_WCLK_noedge_negedge,
          HoldHigh                => thold_AD1_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_negedge,
          HoldLow                 => thold_AD2_WCLK_noedge_negedge,
          HoldHigh                => thold_AD2_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_negedge,
          HoldLow                 => thold_AD3_WCLK_noedge_negedge,
          HoldHigh                => thold_AD3_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_negedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM16X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge  or Tviol_WE_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    WCLK_inverted := (NOT WCLK_ipd);
    O_zd := MEM(Index);

    VitalStateTable(Result => O_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, O_zd, WDATA_prev, WE_inverted, WCLK_inverted));
      
    O_zd := Violation XOR O_zd;

--    WE_prev       := WE_ipd;
    WE_prev       := WE_inverted;
--    WCLK_prev     := WCLK_ipd;
    WCLK_prev     := WCLK_inverted;
    WDATA_prev    := WDATA_ipd;

    MEM(Index) <= O_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, WDATA_ipd, WE_ipd, WCLK_ipd;

    end process VitalBehavior_Write;

    VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, MEM, WDATA_ipd, WE_ipd)
         Variable Index      : integer  := 15 ;
         variable O_zd       : std_ulogic := 'X';
         variable O_zd1      : std_ulogic := 'X';
         variable O_GlitchData : VitalGlitchDataType;
    begin

        Index      := ADDR4_TO_INT(ADDRESS => (AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);

	O_zd1 := VitalMUX2
		     (data0 => O_zd, 
		      data1 => WDATA_ipd,
		      dselect => WE_ipd);

    VitalPathDelay01 (
      OutSignal => RDATA,
      GlitchData => O_GlitchData,
      OutSignalName => "RDATA",
      OutTemp => O_zd1,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
                1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
                2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
                3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
                4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

    end process VITALBehavior_Read;

end VITAL;

configuration CFG_RAM16X1S_1_VITAL of RAM16X1S_1 is
   for VITAL
   end for;
end CFG_RAM16X1S_1_VITAL;


----- CELL RAM32X1D -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
use IEEE.VITAL_Timing.all; 
use IEEE.VITAL_Primitives.all;

library lava1;
use lava1.RAM_PACKAGE.all;

entity RAM32X1D is

  generic (
       TimingChecksOn: Boolean := TRUE;
       InstancePath:   STRING  := "*";
       Xon:  Boolean := True;
       MsgOn:  Boolean := False;

       tipd_AD0                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD1                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD2                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD3                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD4                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD0                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD1                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD2                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD3                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD4                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WDATA                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WE                           :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WCLK                         :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tpd_AD0_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD1_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD2_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD3_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD4_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_RDATA                    :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD0_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD1_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tpd_DPAD2_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD3_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD4_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_DPRDATA                  :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tsetup_WDATA_WCLK_noedge_posedge  :      VitalDelayType := 0.1 ns;
       thold_WDATA_WCLK_noedge_posedge   :      VitalDelayType := 0.0 ns;
       tsetup_WE_WCLK_noedge_posedge     :      VitalDelayType := 0.1 ns;
       thold_WE_WCLK_noedge_posedge      :      VitalDelayType := 0.0 ns;
       tsetup_AD0_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD0_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD1_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD1_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD2_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD2_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD3_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD3_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD4_WCLK_noedge_posedge    :      VitalDelayType := 0.1 ns;
       thold_AD4_WCLK_noedge_posedge     :      VitalDelayType := 0.0 ns;
       tpw_WCLK_posedge                  :      VitalDelayType := 2.0 ns;
       tpw_WCLK_negedge                  :      VitalDelayType := 2.0 ns;

       INIT                              :      bit_vector := X"FFFFFFFF"
  );

  port (WDATA   : in std_ulogic;
        WE      : in std_ulogic;
        WCLK    : in std_ulogic;
        AD0     : in std_ulogic;
        AD1     : in std_ulogic;
        AD2     : in std_ulogic;
        AD3     : in std_ulogic;
        AD4     : in std_ulogic;
        DPAD0   : in std_ulogic;
        DPAD1   : in std_ulogic;
        DPAD2   : in std_ulogic;
        DPAD3   : in std_ulogic;
        DPAD4   : in std_ulogic;

        RDATA   : out std_ulogic;
        DPRDATA : out std_ulogic
       ); 
attribute VITAL_LEVEL0 of RAM32X1D : entity is TRUE;

end RAM32X1D;

-----------------------------------------------------------------------------

architecture VITAL of RAM32X1D is

  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

  -- Local signals used to propagate input wire delay

    signal AD0_ipd    : std_ulogic := 'X';
    signal AD1_ipd    : std_ulogic := 'X';
    signal AD2_ipd    : std_ulogic := 'X';
    signal AD3_ipd    : std_ulogic := 'X';
    signal AD4_ipd    : std_ulogic := 'X';

    signal DPAD0_ipd  : std_ulogic := 'X';
    signal DPAD1_ipd  : std_ulogic := 'X';
    signal DPAD2_ipd  : std_ulogic := 'X';
    signal DPAD3_ipd  : std_ulogic := 'X';
    signal DPAD4_ipd  : std_ulogic := 'X';

    signal WDATA_ipd  : std_ulogic := 'X';
    signal WE_ipd     : std_ulogic := 'X';
    signal WCLK_ipd   : std_ulogic := 'X';
    signal MEM        : std_logic_vector( 31 downto 0 ) := To_StdLogicVector(INIT);
    signal WE_AD      : std_ulogic := 'X';
    signal AD         : std_ulogic_vector(4 downto 0);
    signal DPAD         : std_ulogic_vector(4 downto 0);
    signal WDATA_c    : std_ulogic := '0';

begin -- architecture

	AD <= AD4_ipd & AD3_ipd & AD2_ipd & AD1_ipd & AD0_ipd ;
	DPAD <= DPAD4_ipd & DPAD3_ipd & DPAD2_ipd & DPAD1_ipd & DPAD0_ipd ;

  ----------------------
  --  Wire Delay Section
  ----------------------
  WireDelay : block
  begin
    VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
    VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
    VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
    VitalWireDelay (AD3_ipd, AD3, tipd_AD3);
    VitalWireDelay (AD4_ipd, AD4, tipd_AD4);

    VitalWireDelay (DPAD0_ipd, DPAD0, tipd_DPAD0);
    VitalWireDelay (DPAD1_ipd, DPAD1, tipd_DPAD1);
    VitalWireDelay (DPAD2_ipd, DPAD2, tipd_DPAD2);
    VitalWireDelay (DPAD3_ipd, DPAD3, tipd_DPAD3);
    VitalWireDelay (DPAD4_ipd, DPAD4, tipd_DPAD4);

    VitalWireDelay (WDATA_ipd, WDATA, tipd_WDATA);
    VitalWireDelay (WE_ipd,    WE,    tipd_WE);
    VitalWireDelay (WCLK_ipd,  WCLK,  tipd_WCLK);
  end block;

process(WE_ipd,AD,DPAD)
begin
if (WE_ipd = '1' and AD = DPAD) then
	  WE_AD <= '1';
else
	  WE_AD <= '0';
end if;
end process;

process(WE_ipd, WCLK_ipd, WDATA_ipd)
begin
if (WCLK_ipd'event and WCLK_ipd='1') then
    if (WE_ipd = '1') then
	  WDATA_c <= WDATA_ipd;
    end if;
end if;
end process;

 VITALBehavior_Write : process

    -- Local variables used for functionality
    variable Index_A       : integer := 32;
    variable Index_B       : integer := 32;
    variable PrevData      : std_logic_vector(0 to 5) := (others => '0');
    variable WE_prev       : std_ulogic := 'X';
    variable WCLK_prev     : std_ulogic := 'X';
    variable WDATA_prev    : std_ulogic := 'X';
    variable Initial       : boolean := TRUE;

    -- Local variables used for timing checks
    variable Tviol_WDATA_WCLK_posedge  : std_ulogic := '0';
    variable Tviol_WE_WCLK_posedge     : std_ulogic := '0';
    variable Tviol_AD0_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD1_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD2_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD3_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD4_WCLK_posedge    : std_ulogic := '0';

    variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

    variable PViol_WCLK                : std_ulogic := '0';
    variable PInfo_WCLK                : VitalPeriodDataType := VitalPeriodDataInit;

    -- Local variables used for functionality
    variable OA_zd                     : std_ulogic := 'X';
    variable OB_zd                     : std_ulogic := 'X';
    variable WE_inverted               : std_ulogic := 'X';
    variable Violation                 : std_ulogic := '0';

  begin -- process

    if (Initial) then
        wait until ( (WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (WE_ipd  = '0' or WE_ipd = '1') and
                    (AD4_ipd = '0' or AD4_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1') );
        WCLK_prev   := WCLK_ipd;
        WE_prev     := WE_ipd;
        WDATA_prev  := WDATA_ipd;
        Index_A     := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        OA_zd       := MEM(Index_A);
        Initial     := FALSE;

    end if;
    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn ) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_posedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_posedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_posedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_posedge,
          HoldLow                 => thold_AD0_WCLK_noedge_posedge,
          HoldHigh                => thold_AD0_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_posedge,
          HoldLow                 => thold_AD1_WCLK_noedge_posedge,
          HoldHigh                => thold_AD1_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_posedge,
          HoldLow                 => thold_AD2_WCLK_noedge_posedge,
          HoldHigh                => thold_AD2_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_posedge,
          HoldLow                 => thold_AD3_WCLK_noedge_posedge,
          HoldHigh                => thold_AD3_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD4_WCLK_noedge_posedge,
          HoldLow                 => thold_AD4_WCLK_noedge_posedge,
          HoldHigh                => thold_AD4_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM32X1D",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge or Tviol_WDATA_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Tviol_AD4_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index_A := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    OA_zd   := MEM(Index_A);

    VitalStateTable(Result => OA_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, OA_zd, WDATA_prev, WE_inverted, WCLK_ipd));

    OA_zd := Violation XOR OA_zd;

--    WE_prev       :=   WE_ipd;
    WE_prev       :=   WE_inverted;
    WCLK_prev     :=   WCLK_ipd;
    WDATA_prev    :=   WDATA_ipd;

    MEM(Index_A) <= OA_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, WDATA_ipd, WCLK_ipd, WE_ipd;

  end process VITALBehavior_Write;

  --------------------
  -- RAM32X1D Behavior
  --------------------
 VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd,
    DPAD0_ipd, DPAD1_ipd, DPAD2_ipd, DPAD3_ipd, DPAD4_ipd, MEM, WDATA_c, WE_ipd, WE_AD)

    Variable Index_A       :   integer  := 31 ;
    Variable Index_B       :   integer  := 31 ;
    Variable OA_zd         :   std_ulogic := 'X';
    Variable OA_zd1        :   std_ulogic := 'X';
    Variable OB_zd         :   std_ulogic := 'X';
    Variable OB_zd1        :   std_ulogic := 'X';
    Variable OA_GlitchData :   VitalGlitchDataType;
    Variable OB_GlitchData :   VitalGlitchDataType;

    begin -- process

    Index_A := ADDR5_TO_INT (ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    Index_B := ADDR5_TO_INT (ADDRESS => (DPAD4_ipd, DPAD3_ipd, DPAD2_ipd, DPAD1_ipd, DPAD0_ipd));

    OA_zd   := MEM(Index_A);
    OB_zd   := MEM(Index_B);

    OA_zd1 := VitalMUX2
		     (data0 => OA_zd, 
		      data1 => WDATA_c,
		      dselect => WE_ipd);

    OB_zd1 := VitalMUX2
		     (data0 => OB_zd, 
		      data1 => OA_zd,
		      dselect => WE_AD);

    VitalPathDelay01 (
     OutSignal => RDATA,
     GlitchData => OA_GlitchData,
     OutSignalName => "RDATA",
     OutTemp => OA_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
               1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
               2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
               3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
               4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE),
               5 => (AD4_ipd'last_event, tpd_AD4_RDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);

     VitalPathDelay01 (
     OutSignal => DPRDATA,
     GlitchData => OB_GlitchData,
     OutSignalName => "DPRDATA",
     OutTemp => OB_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_DPRDATA, TRUE),
               1 => (DPAD0_ipd'last_event, tpd_DPAD0_DPRDATA, TRUE),
               2 => (DPAD1_ipd'last_event, tpd_DPAD1_DPRDATA, TRUE),
               3 => (DPAD2_ipd'last_event, tpd_DPAD2_DPRDATA, TRUE),
               4 => (DPAD3_ipd'last_event, tpd_DPAD3_DPRDATA, TRUE),
               5 => (DPAD4_ipd'last_event, tpd_DPAD4_DPRDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);
 end process VITALBehavior_Read;

end VITAL;
 
configuration CFG_RAM32X1D_VITAL of RAM32X1D is
   for VITAL
   end for;
end CFG_RAM32X1D_VITAL;


----- CELL RAM32X1D_1 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_UNSIGNED.all;
use IEEE.VITAL_Timing.all; 
use IEEE.VITAL_Primitives.all;

library lava1;
use lava1.RAM_PACKAGE.all;

entity RAM32X1D_1 is

  generic (
       TimingChecksOn: Boolean := TRUE;
       InstancePath:   STRING  := "*";
       Xon:  Boolean := True;
       MsgOn:  Boolean := False;

       tipd_AD0                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD1                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD2                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD3                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_AD4                          :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD0                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD1                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD2                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD3                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_DPAD4                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WDATA                        :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WE                           :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tipd_WCLK                         :      VitalDelayType01 := ( 0.0 ns,  0.0 ns);
       tpd_AD0_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD1_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD2_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD3_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_AD4_RDATA                     :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_RDATA                    :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD0_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD1_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tpd_DPAD2_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD3_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_DPAD4_DPRDATA                 :      VitalDelayType01 := (0.0 ns, 0.0 ns);
       tpd_WCLK_DPRDATA                  :      VitalDelayType01 := (0.0 ns, 0.0 ns); 
       tsetup_WDATA_WCLK_noedge_negedge  :      VitalDelayType := 0.1 ns;
       thold_WDATA_WCLK_noedge_negedge   :      VitalDelayType := 0.0 ns;
       tsetup_WE_WCLK_noedge_negedge     :      VitalDelayType := 0.1 ns;
       thold_WE_WCLK_noedge_negedge      :      VitalDelayType := 0.0 ns;
       tsetup_AD0_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD0_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD1_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD1_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD2_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD2_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD3_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD3_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tsetup_AD4_WCLK_noedge_negedge    :      VitalDelayType := 0.1 ns;
       thold_AD4_WCLK_noedge_negedge     :      VitalDelayType := 0.0 ns;
       tpw_WCLK_posedge                  :      VitalDelayType := 2.0 ns;
       tpw_WCLK_negedge                  :      VitalDelayType := 2.0 ns;

       INIT                              :      bit_vector := X"FFFFFFFF"
  );

  port (WDATA   : in std_ulogic;
        WE      : in std_ulogic;
        WCLK    : in std_ulogic;
        AD0     : in std_ulogic;
        AD1     : in std_ulogic;
        AD2     : in std_ulogic;
        AD3     : in std_ulogic;
        AD4     : in std_ulogic;
        DPAD0   : in std_ulogic;
        DPAD1   : in std_ulogic;
        DPAD2   : in std_ulogic;
        DPAD3   : in std_ulogic;
        DPAD4   : in std_ulogic;

        RDATA   : out std_ulogic;
        DPRDATA : out std_ulogic
       ); 
attribute VITAL_LEVEL0 of RAM32X1D_1 : entity is TRUE;

end RAM32X1D_1;

-----------------------------------------------------------------------------

architecture VITAL of RAM32X1D_1 is

  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

  -- Local signals used to propagate input wire delay

    signal AD0_ipd    : std_ulogic := 'X';
    signal AD1_ipd    : std_ulogic := 'X';
    signal AD2_ipd    : std_ulogic := 'X';
    signal AD3_ipd    : std_ulogic := 'X';
    signal AD4_ipd    : std_ulogic := 'X';

    signal DPAD0_ipd  : std_ulogic := 'X';
    signal DPAD1_ipd  : std_ulogic := 'X';
    signal DPAD2_ipd  : std_ulogic := 'X';
    signal DPAD3_ipd  : std_ulogic := 'X';
    signal DPAD4_ipd  : std_ulogic := 'X';

    signal WDATA_ipd  : std_ulogic := 'X';
    signal WE_ipd     : std_ulogic := 'X';
    signal WCLK_ipd   : std_ulogic := 'X';
    signal MEM        : std_logic_vector( 31 downto 0 ) := To_StdLogicVector(INIT);
    signal WE_AD      : std_ulogic := 'X';
    signal AD         : std_ulogic_vector(4 downto 0);
    signal DPAD         : std_ulogic_vector(4 downto 0);
    signal WDATA_c    : std_ulogic := '0';

begin -- architecture

	AD <= AD4_ipd & AD3_ipd & AD2_ipd & AD1_ipd & AD0_ipd ;
	DPAD <= DPAD4_ipd & DPAD3_ipd & DPAD2_ipd & DPAD1_ipd & DPAD0_ipd ;

  ----------------------
  --  Wire Delay Section
  ----------------------
  WireDelay : block
  begin
    VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
    VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
    VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
    VitalWireDelay (AD3_ipd, AD3, tipd_AD3);
    VitalWireDelay (AD4_ipd, AD4, tipd_AD4);

    VitalWireDelay (DPAD0_ipd, DPAD0, tipd_DPAD0);
    VitalWireDelay (DPAD1_ipd, DPAD1, tipd_DPAD1);
    VitalWireDelay (DPAD2_ipd, DPAD2, tipd_DPAD2);
    VitalWireDelay (DPAD3_ipd, DPAD3, tipd_DPAD3);
    VitalWireDelay (DPAD4_ipd, DPAD4, tipd_DPAD4);

    VitalWireDelay (WDATA_ipd, WDATA, tipd_WDATA);
    VitalWireDelay (WE_ipd,    WE,    tipd_WE);
    VitalWireDelay (WCLK_ipd,  WCLK,  tipd_WCLK);
  end block;

process(WE_ipd,AD,DPAD)
begin
if (WE_ipd = '1' and AD = DPAD) then
	  WE_AD <= '1';
else
	  WE_AD <= '0';
end if;
end process;

process(WE_ipd, WCLK_ipd, WDATA_ipd)
begin
if (WCLK_ipd'event and WCLK_ipd='1') then
    if (WE_ipd = '1') then
	  WDATA_c <= WDATA_ipd;
    end if;
end if;
end process;

 VITALBehavior_Write : process

    -- Local variables used for functionality
    variable Index_A       : integer := 32;
    variable Index_B       : integer := 32;
    variable PrevData      : std_logic_vector(0 to 5) := (others => '0');
    variable WE_prev       : std_ulogic := 'X';
    variable WCLK_prev     : std_ulogic := 'X';
    variable WDATA_prev    : std_ulogic := 'X';
    variable Initial       : boolean := TRUE;

    -- Local variables used for timing checks
    variable Tviol_WDATA_WCLK_posedge  : std_ulogic := '0';
    variable Tviol_WE_WCLK_posedge     : std_ulogic := '0';
    variable Tviol_AD0_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD1_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD2_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD3_WCLK_posedge    : std_ulogic := '0';
    variable Tviol_AD4_WCLK_posedge    : std_ulogic := '0';

    variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_AD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

    variable PViol_WCLK                : std_ulogic := '0';
    variable PInfo_WCLK                : VitalPeriodDataType := VitalPeriodDataInit;

    -- Local variables used for functionality
    variable OA_zd                     : std_ulogic := 'X';
    variable OB_zd                     : std_ulogic := 'X';
    variable WE_inverted               : std_ulogic := 'X';
    variable WCLK_inverted             : std_ulogic := 'X';
    variable Violation                 : std_ulogic := '0';

  begin -- process

    if (Initial) then
        wait until ( (WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (WE_ipd  = '0' or WE_ipd = '1') and
                    (AD4_ipd = '0' or AD4_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1') );
        WCLK_prev   := WCLK_ipd;
        WE_prev     := WE_ipd;
        WDATA_prev  := WDATA_ipd;
        Index_A     := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        OA_zd       := MEM(Index_A);
        Initial     := FALSE;

    end if;
    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn ) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_negedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_negedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_negedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_negedge,
          SetupLow                => tsetup_WE_WCLK_noedge_negedge,
          HoldLow                 => thold_WE_WCLK_noedge_negedge,
          HoldHigh                => thold_WE_WCLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_negedge,
          HoldLow                 => thold_AD0_WCLK_noedge_negedge,
          HoldHigh                => thold_AD0_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_negedge,
          HoldLow                 => thold_AD1_WCLK_noedge_negedge,
          HoldHigh                => thold_AD1_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_negedge,
          HoldLow                 => thold_AD2_WCLK_noedge_negedge,
          HoldHigh                => thold_AD2_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_negedge,
          HoldLow                 => thold_AD3_WCLK_noedge_negedge,
          HoldHigh                => thold_AD3_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD4_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD4_WCLK_noedge_negedge,
          HoldLow                 => thold_AD4_WCLK_noedge_negedge,
          HoldHigh                => thold_AD4_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM32X1D_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge or Tviol_WDATA_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Tviol_AD4_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index_A := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    WCLK_inverted := (NOT WCLK_ipd);
    OA_zd   := MEM(Index_A);

    VitalStateTable(Result => OA_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, OA_zd, WDATA_prev, WE_inverted, WCLK_inverted));

    OA_zd := Violation XOR OA_zd;

--    WE_prev       :=   WE_ipd;
    WE_prev       :=   WE_inverted;
    WCLK_prev     :=   WCLK_inverted;
    WDATA_prev    :=   WDATA_ipd;

    MEM(Index_A) <= OA_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, WDATA_ipd, WCLK_ipd, WE_ipd;

  end process VITALBehavior_Write;

  --------------------
  -- RAM32X1D_1 Behavior
  --------------------
 VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd,
    DPAD0_ipd, DPAD1_ipd, DPAD2_ipd, DPAD3_ipd, DPAD4_ipd, MEM, WDATA_c, WE_ipd, WE_AD)

    Variable Index_A       :   integer  := 31 ;
    Variable Index_B       :   integer  := 31 ;
    Variable OA_zd         :   std_ulogic := 'X';
    Variable OA_zd1        :   std_ulogic := 'X';
    Variable OB_zd         :   std_ulogic := 'X';
    Variable OB_zd1        :   std_ulogic := 'X';
    Variable OA_GlitchData :   VitalGlitchDataType;
    Variable OB_GlitchData :   VitalGlitchDataType;

    begin -- process

    Index_A := ADDR5_TO_INT (ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    Index_B := ADDR5_TO_INT (ADDRESS => (DPAD4_ipd, DPAD3_ipd, DPAD2_ipd, DPAD1_ipd, DPAD0_ipd));

    OA_zd   := MEM(Index_A);
    OB_zd   := MEM(Index_B);

    OA_zd1 := VitalMUX2
		     (data0 => OA_zd, 
		      data1 => WDATA_c,
		      dselect => WE_ipd);

    OB_zd1 := VitalMUX2
		     (data0 => OB_zd, 
		      data1 => OA_zd,
		      dselect => WE_AD);

    VitalPathDelay01 (
     OutSignal => RDATA,
     GlitchData => OA_GlitchData,
     OutSignalName => "RDATA",
     OutTemp => OA_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
               1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
               2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
               3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
               4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE),
               5 => (AD4_ipd'last_event, tpd_AD4_RDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);

     VitalPathDelay01 (
     OutSignal => DPRDATA,
     GlitchData => OB_GlitchData,
     OutSignalName => "DPRDATA",
     OutTemp => OB_zd1,
     Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_DPRDATA, TRUE),
               1 => (DPAD0_ipd'last_event, tpd_DPAD0_DPRDATA, TRUE),
               2 => (DPAD1_ipd'last_event, tpd_DPAD1_DPRDATA, TRUE),
               3 => (DPAD2_ipd'last_event, tpd_DPAD2_DPRDATA, TRUE),
               4 => (DPAD3_ipd'last_event, tpd_DPAD3_DPRDATA, TRUE),
               5 => (DPAD4_ipd'last_event, tpd_DPAD4_DPRDATA, TRUE)),
     Mode => OnEvent,
     Xon => Xon,
     MsgOn => MsgOn,
     MsgSeverity => WARNING);
 end process VITALBehavior_Read;

end VITAL;
 
configuration CFG_RAM32X1D_1_VITAL of RAM32X1D_1 is
   for VITAL
   end for;
end CFG_RAM32X1D_1_VITAL;


----- CELL RAM32X1S -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lava1;
use lava1.RAM_PACKAGE.all;

-- entity declaration --
entity RAM32X1S is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_AD0_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD1_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD2_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD3_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD4_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_RDATA                   :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WE_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WDATA_WCLK_noedge_posedge :	VitalDelayType   := 0.1 ns;
      thold_WDATA_WCLK_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_AD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD2_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD3_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD4_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tpw_WCLK_posedge                 :	VitalDelayType   := 2.0 ns;
      tipd_WE                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WDATA                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD2                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD3                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD4                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT                             :	bit_vector := X"FFFFFFFF");

   port(
      WE                             :	in    STD_ULOGIC;
      WDATA                          :	in    STD_ULOGIC;
      WCLK                           :	in    STD_ULOGIC;
      AD0                            :	in    STD_ULOGIC;
      AD1                            :	in    STD_ULOGIC;
      AD2                            :	in    STD_ULOGIC;
      AD3                            :	in    STD_ULOGIC;
      AD4                            :	in    STD_ULOGIC;
      RDATA                          :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAM32X1S : entity is TRUE;
end RAM32X1S;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAM32X1S is
  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

      signal AD0_ipd      : std_ulogic := 'X';
      signal AD1_ipd      : std_ulogic := 'X';
      signal AD2_ipd      : std_ulogic := 'X';
      signal AD3_ipd      : std_ulogic := 'X';
      signal AD4_ipd      : std_ulogic := 'X';

      signal WDATA_ipd    : std_ulogic := 'X';
      signal WE_ipd       : std_ulogic := 'X';
      signal WCLK_ipd     : std_ulogic := 'X';

      signal MEM          : std_logic_vector( 31 downto 0 ) := ( To_StdLogicVector(INIT)) ;

begin 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin
        VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
        VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
        VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
        VitalWireDelay (AD3_ipd, AD3, tipd_AD3);
        VitalWireDelay (AD4_ipd, AD4, tipd_AD4);

        VitalWireDelay (WDATA_ipd,  WDATA, tipd_WDATA);
        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
      end block;

      --------------------
      -- RAM32X1S Write Behavior
      --------------------
      VITALBehavior_Write : process
        -- Local variables used for timing checks

        variable Tviol_WDATA_WCLK_posedge  : std_ulogic  := '0';
        variable Tviol_WE_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_AD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD4_WCLK_posedge    : std_ulogic  := '0';

        variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        variable Initial          : boolean := TRUE;
        variable Violation        : std_ulogic := '0';
        variable INIT_BITS        : std_logic_vector(31 downto 0) := To_StdLogicVector(INIT);
        variable Index            : integer := 32;
        variable PrevData         : std_logic_vector(0 to 4) := (others => '0');
        variable WE_prev          : std_ulogic := 'X';
        variable WCLK_prev        : std_ulogic := 'X';
        variable WDATA_prev       : std_ulogic := 'X';
        variable O_zd             : std_ulogic := 'X';
        variable O_GlitchData     : VitalGlitchDataType;
        variable WE_inverted      : std_ulogic := 'X';

        begin


        if (Initial) then
        wait until ((WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (AD4_ipd = '0' or AD4_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1'));
        WCLK_prev  := WCLK_ipd;
        WE_prev    := WE_ipd;
        WDATA_prev := WDATA_ipd;
        Index      := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
        Initial    := FALSE;
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_posedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_posedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_posedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_posedge,
          HoldLow                 => thold_AD0_WCLK_noedge_posedge,
          HoldHigh                => thold_AD0_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_posedge,
          HoldLow                 => thold_AD1_WCLK_noedge_posedge,
          HoldHigh                => thold_AD1_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_posedge,
          HoldLow                 => thold_AD2_WCLK_noedge_posedge,
          HoldHigh                => thold_AD2_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_posedge,
          HoldLow                 => thold_AD3_WCLK_noedge_posedge,
          HoldHigh                => thold_AD3_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD4_WCLK_posedge,
          TimingData              => Tmkr_AD4_WCLK_posedge,
          TestSignal              => AD4_ipd,
          TestSignalName          => "AD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD4_WCLK_noedge_posedge,
          HoldLow                 => thold_AD4_WCLK_noedge_posedge,
          HoldHigh                => thold_AD4_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM32X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge  or Tviol_WE_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Tviol_AD4_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    O_zd := MEM(Index);

    VitalStateTable(Result => O_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, O_zd, WDATA_prev, WE_inverted, WCLK_ipd));
      
    O_zd := Violation XOR O_zd;

--    WE_prev       := WE_ipd;
    WE_prev       := WE_inverted;
    WCLK_prev     := WCLK_ipd;
    WDATA_prev    := WDATA_ipd;

    MEM(Index) <= O_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, WDATA_ipd, WE_ipd, WCLK_ipd;

    end process VitalBehavior_Write;

    VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, MEM, WDATA_ipd, WE_ipd)
         Variable Index        : integer  := 31 ;
         variable O_zd         : std_ulogic := 'X';
         variable O_zd1        : std_ulogic := 'X';
         variable O_GlitchData : VitalGlitchDataType;
    begin

        Index      := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);

	O_zd1 := VitalMUX2
		     (data0 => O_zd, 
		      data1 => WDATA_ipd,
		      dselect => WE_ipd);

    VitalPathDelay01 (
      OutSignal => RDATA,
      GlitchData => O_GlitchData,
      OutSignalName => "RDATA",
      OutTemp => O_zd1,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
                1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
                2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
                3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
                4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE),
                5 => (AD4_ipd'last_event, tpd_AD4_RDATA, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

    end process VITALBehavior_Read;

end VITAL;

configuration CFG_RAM32X1S_VITAL of RAM32X1S is
   for VITAL
   end for;
end CFG_RAM32X1S_VITAL;

----- CELL RAM32X1S_1 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lava1;
use lava1.RAM_PACKAGE.all;

-- entity declaration --
entity RAM32X1S_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_AD0_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD1_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD2_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD3_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD4_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_RDATA                   :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WE_WCLK_noedge_negedge    :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_negedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WDATA_WCLK_noedge_negedge :	VitalDelayType   := 0.1 ns;
      thold_WDATA_WCLK_noedge_negedge  :	VitalDelayType   := 0.0 ns;
      tsetup_AD0_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD0_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD1_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD1_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD2_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD2_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD3_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD3_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD4_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD4_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tpw_WCLK_negedge                 :	VitalDelayType   := 2.0 ns;
      tipd_WE                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WDATA                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD2                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD3                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD4                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT                             :	bit_vector := X"FFFFFFFF");

   port(
      WE                             :	in    STD_ULOGIC;
      WDATA                          :	in    STD_ULOGIC;
      WCLK                           :	in    STD_ULOGIC;
      AD0                            :	in    STD_ULOGIC;
      AD1                            :	in    STD_ULOGIC;
      AD2                            :	in    STD_ULOGIC;
      AD3                            :	in    STD_ULOGIC;
      AD4                            :	in    STD_ULOGIC;
      RDATA                          :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAM32X1S_1 : entity is TRUE;
end RAM32X1S_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAM32X1S_1 is
  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

      signal AD0_ipd      : std_ulogic := 'X';
      signal AD1_ipd      : std_ulogic := 'X';
      signal AD2_ipd      : std_ulogic := 'X';
      signal AD3_ipd      : std_ulogic := 'X';
      signal AD4_ipd      : std_ulogic := 'X';

      signal WDATA_ipd    : std_ulogic := 'X';
      signal WE_ipd       : std_ulogic := 'X';
      signal WCLK_ipd     : std_ulogic := 'X';

      signal MEM          : std_logic_vector( 31 downto 0 ) := ( To_StdLogicVector(INIT)) ;

begin 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin
        VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
        VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
        VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
        VitalWireDelay (AD3_ipd, AD3, tipd_AD3);
        VitalWireDelay (AD4_ipd, AD4, tipd_AD4);

        VitalWireDelay (WDATA_ipd,  WDATA, tipd_WDATA);
        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
      end block;

      --------------------
      -- RAM32X1S_1 Write Behavior
      --------------------
      VITALBehavior_Write : process
        -- Local variables used for timing checks

        variable Tviol_WDATA_WCLK_posedge  : std_ulogic  := '0';
        variable Tviol_WE_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_AD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD4_WCLK_posedge    : std_ulogic  := '0';

        variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        variable Initial          : boolean := TRUE;
        variable Violation        : std_ulogic := '0';
        variable INIT_BITS        : std_logic_vector(31 downto 0) := To_StdLogicVector(INIT);
        variable Index            : integer := 32;
        variable PrevData         : std_logic_vector(0 to 4) := (others => '0');
        variable WE_prev          : std_ulogic := 'X';
        variable WCLK_prev        : std_ulogic := 'X';
        variable WDATA_prev       : std_ulogic := 'X';
        variable O_zd             : std_ulogic := 'X';
        variable WE_inverted      : std_ulogic := 'X';
        variable WCLK_inverted    : std_ulogic := 'X';
        variable O_GlitchData     : VitalGlitchDataType;

        begin


        if (Initial) then
        wait until ((WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (AD4_ipd = '0' or AD4_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1'));
        WCLK_prev  := WCLK_ipd;
        WE_prev    := WE_ipd;
        WDATA_prev := WDATA_ipd;
        Index      := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
        Initial    := FALSE;
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_negedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_negedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_negedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_negedge,
          SetupLow                => tsetup_WE_WCLK_noedge_negedge,
          HoldLow                 => thold_WE_WCLK_noedge_negedge,
          HoldHigh                => thold_WE_WCLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_negedge,
          HoldLow                 => thold_AD0_WCLK_noedge_negedge,
          HoldHigh                => thold_AD0_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_negedge,
          HoldLow                 => thold_AD1_WCLK_noedge_negedge,
          HoldHigh                => thold_AD1_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_negedge,
          HoldLow                 => thold_AD2_WCLK_noedge_negedge,
          HoldHigh                => thold_AD2_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_negedge,
          HoldLow                 => thold_AD3_WCLK_noedge_negedge,
          HoldHigh                => thold_AD3_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD4_WCLK_posedge,
          TimingData              => Tmkr_AD4_WCLK_posedge,
          TestSignal              => AD4_ipd,
          TestSignalName          => "AD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD4_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD4_WCLK_noedge_negedge,
          HoldLow                 => thold_AD4_WCLK_noedge_negedge,
          HoldHigh                => thold_AD4_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_negedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM32X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge  or Tviol_WE_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Tviol_AD4_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    WCLK_inverted := (NOT WCLK_ipd);
    O_zd := MEM(Index);

    VitalStateTable(Result => O_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, O_zd, WDATA_prev, WE_inverted, WCLK_inverted));
      
    O_zd := Violation XOR O_zd;

--    WE_prev       := WE_ipd;
    WE_prev       := WE_inverted;
    WCLK_prev     := WCLK_inverted;
    WDATA_prev    := WDATA_ipd;

    MEM(Index) <= O_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, WDATA_ipd, WE_ipd, WCLK_ipd;

    end process VitalBehavior_Write;

    VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, MEM, WDATA_ipd,WE_ipd)
         Variable Index        : integer  := 31 ;
         variable O_zd         : std_ulogic := 'X';
         variable O_zd1        : std_ulogic := 'X';
         variable O_GlitchData : VitalGlitchDataType;
    begin

        Index      := ADDR5_TO_INT(ADDRESS => (AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
	O_zd1 := VitalMUX2
		     (data0 => O_zd, 
		      data1 => WDATA_ipd,
		      dselect => WE_ipd);

    VitalPathDelay01 (
      OutSignal => RDATA,
      GlitchData => O_GlitchData,
      OutSignalName => "RDATA",
      OutTemp => O_zd1,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
                1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
                2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
                3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
                4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE),
                5 => (AD4_ipd'last_event, tpd_AD4_RDATA, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

    end process VITALBehavior_Read;

end VITAL;

configuration CFG_RAM32X1S_1_VITAL of RAM32X1S_1 is
   for VITAL
   end for;
end CFG_RAM32X1S_1_VITAL;


----- CELL RAM64X1S -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lava1;
use lava1.RAM_PACKAGE.all;

-- entity declaration --
entity RAM64X1S is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_AD0_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD1_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD2_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD3_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD4_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD5_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_RDATA                   :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WE_WCLK_noedge_posedge    :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WDATA_WCLK_noedge_posedge :	VitalDelayType   := 0.1 ns;
      thold_WDATA_WCLK_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_AD0_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD0_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD1_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD1_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD2_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD2_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD3_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD3_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD4_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD4_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD5_WCLK_noedge_posedge   :	VitalDelayType   := 0.1 ns;
      thold_AD5_WCLK_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tpw_WCLK_posedge                 :	VitalDelayType   := 2.0 ns;
      tipd_WE                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WDATA                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD2                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD3                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD4                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD5                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT                             :	bit_vector := X"FFFFFFFFFFFFFFFF");

   port(
      WE                             :	in    STD_ULOGIC;
      WDATA                          :	in    STD_ULOGIC;
      WCLK                           :	in    STD_ULOGIC;
      AD0                            :	in    STD_ULOGIC;
      AD1                            :	in    STD_ULOGIC;
      AD2                            :	in    STD_ULOGIC;
      AD3                            :	in    STD_ULOGIC;
      AD4                            :	in    STD_ULOGIC;
      AD5                            :	in    STD_ULOGIC;
      RDATA                          :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAM64X1S : entity is TRUE;
end RAM64X1S;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAM64X1S is
  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

      signal AD0_ipd      : std_ulogic := 'X';
      signal AD1_ipd      : std_ulogic := 'X';
      signal AD2_ipd      : std_ulogic := 'X';
      signal AD3_ipd      : std_ulogic := 'X';
      signal AD4_ipd      : std_ulogic := 'X';
      signal AD5_ipd      : std_ulogic := 'X';

      signal WDATA_ipd    : std_ulogic := 'X';
      signal WE_ipd       : std_ulogic := 'X';
      signal WCLK_ipd     : std_ulogic := 'X';

      signal MEM          : std_logic_vector( 63 downto 0 ) := ( To_StdLogicVector(INIT)) ;

begin 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin
        VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
        VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
        VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
        VitalWireDelay (AD3_ipd, AD3, tipd_AD3);
        VitalWireDelay (AD4_ipd, AD4, tipd_AD4);
        VitalWireDelay (AD5_ipd, AD5, tipd_AD5);

        VitalWireDelay (WDATA_ipd,  WDATA, tipd_WDATA);
        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
      end block;

      --------------------
      -- RAM64X1S Write Behavior
      --------------------
      VITALBehavior_Write : process
        -- Local variables used for timing checks

        variable Tviol_WDATA_WCLK_posedge  : std_ulogic  := '0';
        variable Tviol_WE_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_AD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD5_WCLK_posedge    : std_ulogic  := '0';

        variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        variable Initial          : boolean := TRUE;
        variable Violation        : std_ulogic := '0';
        variable INIT_BITS        : std_logic_vector(63 downto 0) := To_StdLogicVector(INIT);
        variable Index            : integer := 64;
        variable PrevData         : std_logic_vector(0 to 4) := (others => '0');
        variable WE_prev          : std_ulogic := 'X';
        variable WCLK_prev        : std_ulogic := 'X';
        variable WDATA_prev       : std_ulogic := 'X';
        variable O_zd             : std_ulogic := 'X';
        variable O_GlitchData     : VitalGlitchDataType;
        variable WE_inverted      : std_ulogic := 'X';

        begin


        if (Initial) then
        wait until ((WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (AD5_ipd = '0' or AD5_ipd = '1') and
                    (AD4_ipd = '0' or AD4_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1'));
        WCLK_prev  := WCLK_ipd;
        WE_prev    := WE_ipd;
        WDATA_prev := WDATA_ipd;
        Index      := ADDR6_TO_INT(ADDRESS => (AD5_ipd, AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
        Initial    := FALSE;
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_posedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_posedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_posedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_posedge,
          SetupLow                => tsetup_WE_WCLK_noedge_posedge,
          HoldLow                 => thold_WE_WCLK_noedge_posedge,
          HoldHigh                => thold_WE_WCLK_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_posedge,
          HoldLow                 => thold_AD0_WCLK_noedge_posedge,
          HoldHigh                => thold_AD0_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_posedge,
          HoldLow                 => thold_AD1_WCLK_noedge_posedge,
          HoldHigh                => thold_AD1_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_posedge,
          HoldLow                 => thold_AD2_WCLK_noedge_posedge,
          HoldHigh                => thold_AD2_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_posedge,
          HoldLow                 => thold_AD3_WCLK_noedge_posedge,
          HoldHigh                => thold_AD3_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD4_WCLK_posedge,
          TimingData              => Tmkr_AD4_WCLK_posedge,
          TestSignal              => AD4_ipd,
          TestSignalName          => "AD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD4_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD4_WCLK_noedge_posedge,
          HoldLow                 => thold_AD4_WCLK_noedge_posedge,
          HoldHigh                => thold_AD4_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD5_WCLK_posedge,
          TimingData              => Tmkr_AD5_WCLK_posedge,
          TestSignal              => AD5_ipd,
          TestSignalName          => "AD5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD5_WCLK_noedge_posedge,
          SetupLow                => tsetup_AD5_WCLK_noedge_posedge,
          HoldLow                 => thold_AD5_WCLK_noedge_posedge,
          HoldHigh                => thold_AD5_WCLK_noedge_posedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_posedge,
          PulseWidthLow           => tpw_WCLK_posedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM64X1S",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge  or Tviol_WE_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Tviol_AD4_WCLK_posedge or Tviol_AD5_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index := ADDR6_TO_INT(ADDRESS => (AD5_ipd, AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    O_zd := MEM(Index);

    VitalStateTable(Result => O_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, O_zd, WDATA_prev, WE_inverted, WCLK_ipd));
      
    O_zd := Violation XOR O_zd;

--    WE_prev       := WE_ipd;
    WE_prev       := WE_inverted;
    WCLK_prev     := WCLK_ipd;
    WDATA_prev    := WDATA_ipd;

    MEM(Index) <= O_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, AD5_ipd, WDATA_ipd, WE_ipd, WCLK_ipd;

    end process VitalBehavior_Write;

    VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, AD5_ipd, MEM, WDATA_ipd, WE_ipd)
         Variable Index        : integer  := 63 ;
         variable O_zd         : std_ulogic := 'X';
         variable O_zd1         : std_ulogic := 'X';
         variable O_GlitchData : VitalGlitchDataType;
    begin

        Index      := ADDR6_TO_INT(ADDRESS => (AD5_ipd, AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
	O_zd1 := VitalMUX2
		     (data0 => O_zd, 
		      data1 => WDATA_ipd,
		      dselect => WE_ipd);

    VitalPathDelay01 (
      OutSignal => RDATA,
      GlitchData => O_GlitchData,
      OutSignalName => "RDATA",
      OutTemp => O_zd1,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
                1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
                2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
                3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
                4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE),
                5 => (AD4_ipd'last_event, tpd_AD4_RDATA, TRUE),
                6 => (AD5_ipd'last_event, tpd_AD5_RDATA, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

    end process VITALBehavior_Read;

end VITAL;

configuration CFG_RAM64X1S_VITAL of RAM64X1S is
   for VITAL
   end for;
end CFG_RAM64X1S_VITAL;


----- CELL RAM64X1S_1 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library lava1;
use lava1.RAM_PACKAGE.all;

-- entity declaration --
entity RAM64X1S_1 is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_AD0_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD1_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD2_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD3_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD4_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_AD5_RDATA                    :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tpd_WCLK_RDATA                   :	VitalDelayType01 := (0.0 ns, 0.0 ns);
      tsetup_WE_WCLK_noedge_negedge    :	VitalDelayType   := 0.1 ns;
      thold_WE_WCLK_noedge_negedge     :	VitalDelayType   := 0.0 ns;
      tsetup_WDATA_WCLK_noedge_negedge :	VitalDelayType   := 0.1 ns;
      thold_WDATA_WCLK_noedge_negedge  :	VitalDelayType   := 0.0 ns;
      tsetup_AD0_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD0_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD1_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD1_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD2_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD2_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD3_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD3_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD4_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD4_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tsetup_AD5_WCLK_noedge_negedge   :	VitalDelayType   := 0.1 ns;
      thold_AD5_WCLK_noedge_negedge    :	VitalDelayType   := 0.0 ns;
      tpw_WCLK_negedge                 :	VitalDelayType   := 2.0 ns;
      tipd_WE                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WDATA                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WCLK                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD2                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD3                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD4                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_AD5                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT                             :	bit_vector := X"FFFFFFFFFFFFFFFF");

   port(
      WE                             :	in    STD_ULOGIC;
      WDATA                          :	in    STD_ULOGIC;
      WCLK                           :	in    STD_ULOGIC;
      AD0                            :	in    STD_ULOGIC;
      AD1                            :	in    STD_ULOGIC;
      AD2                            :	in    STD_ULOGIC;
      AD3                            :	in    STD_ULOGIC;
      AD4                            :	in    STD_ULOGIC;
      AD5                            :	in    STD_ULOGIC;
      RDATA                          :	out   STD_ULOGIC);

attribute VITAL_LEVEL0 of RAM64X1S_1 : entity is TRUE;
end RAM64X1S_1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAM64X1S_1 is
  attribute VITAL_LEVEL0 of VITAL : architecture is TRUE;

      signal AD0_ipd      : std_ulogic := 'X';
      signal AD1_ipd      : std_ulogic := 'X';
      signal AD2_ipd      : std_ulogic := 'X';
      signal AD3_ipd      : std_ulogic := 'X';
      signal AD4_ipd      : std_ulogic := 'X';
      signal AD5_ipd      : std_ulogic := 'X';

      signal WDATA_ipd    : std_ulogic := 'X';
      signal WE_ipd       : std_ulogic := 'X';
      signal WCLK_ipd     : std_ulogic := 'X';

      signal MEM          : std_logic_vector( 63 downto 0 ) := ( To_StdLogicVector(INIT)) ;

begin 

  ----------------------
  --  Wire Delay Section
  ----------------------
      WireDelay : block
      begin
        VitalWireDelay (AD0_ipd, AD0, tipd_AD0);
        VitalWireDelay (AD1_ipd, AD1, tipd_AD1);
        VitalWireDelay (AD2_ipd, AD2, tipd_AD2);
        VitalWireDelay (AD3_ipd, AD3, tipd_AD3);
        VitalWireDelay (AD4_ipd, AD4, tipd_AD4);
        VitalWireDelay (AD5_ipd, AD5, tipd_AD5);

        VitalWireDelay (WDATA_ipd,  WDATA, tipd_WDATA);
        VitalWireDelay (WE_ipd, WE, tipd_WE);
        VitalWireDelay (WCLK_ipd, WCLK, tipd_WCLK);
      end block;

      --------------------
      -- RAM64X1S_1 Write Behavior
      --------------------
      VITALBehavior_Write : process
        -- Local variables used for timing checks

        variable Tviol_WDATA_WCLK_posedge  : std_ulogic  := '0';
        variable Tviol_WE_WCLK_posedge     : std_ulogic  := '0';
        variable Tviol_AD0_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD1_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD2_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD3_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD4_WCLK_posedge    : std_ulogic  := '0';
        variable Tviol_AD5_WCLK_posedge    : std_ulogic  := '0';

        variable Tmkr_WDATA_WCLK_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WE_WCLK_posedge      : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD0_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD1_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD2_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD3_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD4_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_AD5_WCLK_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_WCLK       : std_ulogic := '0';
        variable PInfo_WCLK       : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        variable Initial          : boolean := TRUE;
        variable Violation        : std_ulogic := '0';
        variable INIT_BITS        : std_logic_vector(63 downto 0) := To_StdLogicVector(INIT);
        variable Index            : integer := 64;
        variable PrevData         : std_logic_vector(0 to 4) := (others => '0');
        variable WE_prev          : std_ulogic := 'X';
        variable WCLK_prev        : std_ulogic := 'X';
        variable WDATA_prev       : std_ulogic := 'X';
        variable O_zd             : std_ulogic := 'X';
        variable WE_inverted      : std_ulogic := 'X';
        variable WCLK_inverted    : std_ulogic := 'X';
        variable O_GlitchData     : VitalGlitchDataType;

        begin


        if (Initial) then
        wait until ((WCLK_ipd = '0' or WCLK_ipd = '1') and
                    (AD5_ipd = '0' or AD5_ipd = '1') and
                    (AD4_ipd = '0' or AD4_ipd = '1') and
                    (AD3_ipd = '0' or AD3_ipd = '1') and
                    (AD2_ipd = '0' or AD2_ipd = '1') and
                    (AD1_ipd = '0' or AD1_ipd = '1') and
                    (AD0_ipd = '0' or AD0_ipd = '1'));
        WCLK_prev  := WCLK_ipd;
        WE_prev    := WE_ipd;
        WDATA_prev := WDATA_ipd;
        Index      := ADDR6_TO_INT(ADDRESS => (AD5_ipd, AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
        Initial    := FALSE;
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WDATA_WCLK_posedge,
          TimingData              => Tmkr_WDATA_WCLK_posedge,
          TestSignal              => WDATA_ipd,
          TestSignalName          => "WDATA",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WDATA_WCLK_noedge_negedge,
          SetupLow                => tsetup_WDATA_WCLK_noedge_negedge,
          HoldLow                 => thold_WDATA_WCLK_noedge_negedge,
          HoldHigh                => thold_WDATA_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WE_WCLK_posedge,
          TimingData              => Tmkr_WE_WCLK_posedge,
          TestSignal              => WE_ipd,
          TestSignalName          => "WE",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WE_WCLK_noedge_negedge,
          SetupLow                => tsetup_WE_WCLK_noedge_negedge,
          HoldLow                 => thold_WE_WCLK_noedge_negedge,
          HoldHigh                => thold_WE_WCLK_noedge_negedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD0_WCLK_posedge,
          TimingData              => Tmkr_AD0_WCLK_posedge,
          TestSignal              => AD0_ipd,
          TestSignalName          => "AD0",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD0_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD0_WCLK_noedge_negedge,
          HoldLow                 => thold_AD0_WCLK_noedge_negedge,
          HoldHigh                => thold_AD0_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD1_WCLK_posedge,
          TimingData              => Tmkr_AD1_WCLK_posedge,
          TestSignal              => AD1_ipd,
          TestSignalName          => "AD1",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD1_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD1_WCLK_noedge_negedge,
          HoldLow                 => thold_AD1_WCLK_noedge_negedge,
          HoldHigh                => thold_AD1_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD2_WCLK_posedge,
          TimingData              => Tmkr_AD2_WCLK_posedge,
          TestSignal              => AD2_ipd,
          TestSignalName          => "AD2",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD2_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD2_WCLK_noedge_negedge,
          HoldLow                 => thold_AD2_WCLK_noedge_negedge,
          HoldHigh                => thold_AD2_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD3_WCLK_posedge,
          TimingData              => Tmkr_AD3_WCLK_posedge,
          TestSignal              => AD3_ipd,
          TestSignalName          => "AD3",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD3_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD3_WCLK_noedge_negedge,
          HoldLow                 => thold_AD3_WCLK_noedge_negedge,
          HoldHigh                => thold_AD3_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD4_WCLK_posedge,
          TimingData              => Tmkr_AD4_WCLK_posedge,
          TestSignal              => AD4_ipd,
          TestSignalName          => "AD4",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD4_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD4_WCLK_noedge_negedge,
          HoldLow                 => thold_AD4_WCLK_noedge_negedge,
          HoldHigh                => thold_AD4_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_AD5_WCLK_posedge,
          TimingData              => Tmkr_AD5_WCLK_posedge,
          TestSignal              => AD5_ipd,
          TestSignalName          => "AD5",
          TestDelay               => 0 ns,
          RefSignal               => WCLK_ipd,
          RefSignalName           => "WCLK",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_AD5_WCLK_noedge_negedge,
          SetupLow                => tsetup_AD5_WCLK_noedge_negedge,
          HoldLow                 => thold_AD5_WCLK_noedge_negedge,
          HoldHigh                => thold_AD5_WCLK_noedge_negedge,
          CheckEnabled            => TO_X01(WE_ipd) /= '1',
          RefTransition           => 'F',
          HeaderMsg               => InstancePath & "/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalPeriodPulseCheck (
          Violation               => Pviol_WCLK,
          PeriodData              => PInfo_WCLK,
          TestSignal              => WCLK_ipd,
          TestSignalName          => "WCLK",
          TestDelay               => 0 ns,
          Period                  => 0 ns,
          PulseWidthHigh          => tpw_WCLK_negedge,
          PulseWidthLow           => tpw_WCLK_negedge,
          CheckEnabled            => TRUE,
          HeaderMsg               => InstancePath &"/RAM64X1S_1",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

    end if;

    Violation := Tviol_WDATA_WCLK_posedge  or Tviol_WE_WCLK_posedge or 
                 Tviol_AD0_WCLK_posedge or Tviol_AD1_WCLK_posedge or 
                 Tviol_AD2_WCLK_posedge or Tviol_AD3_WCLK_posedge or 
                 Tviol_AD4_WCLK_posedge or Tviol_AD5_WCLK_posedge or 
                 Pviol_WCLK;

    -------------------------
    --  Functionality Section
    -------------------------
    Index := ADDR6_TO_INT(ADDRESS => (AD5_ipd, AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
    WE_inverted := (NOT WE_ipd);
    WCLK_inverted := (NOT WCLK_ipd);
    O_zd := MEM(Index);

    VitalStateTable(Result => O_zd,
                    PreviousDataIn => PrevData,
                    StateTable => RAMS_RDATA_tab,
                    DataIn => (WCLK_prev, O_zd, WDATA_prev, WE_inverted, WCLK_inverted));
      
    O_zd := Violation XOR O_zd;

--    WE_prev       := WE_ipd;
    WE_prev       := WE_inverted;
    WCLK_prev     := WCLK_inverted;
    WDATA_prev    := WDATA_ipd;

    MEM(Index) <= O_zd;

    wait on AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, AD5_ipd, WDATA_ipd, WE_ipd, WCLK_ipd;

    end process VitalBehavior_Write;

    VITALBehavior_Read : process(AD0_ipd, AD1_ipd, AD2_ipd, AD3_ipd, AD4_ipd, AD5_ipd, MEM, WDATA_ipd, WE_ipd)
         Variable Index        : integer  := 63 ;
         variable O_zd         : std_ulogic := 'X';
         variable O_zd1         : std_ulogic := 'X';
         variable O_GlitchData : VitalGlitchDataType;
    begin

        Index      := ADDR6_TO_INT(ADDRESS => (AD5_ipd, AD4_ipd, AD3_ipd, AD2_ipd, AD1_ipd, AD0_ipd));
        O_zd       := MEM(Index);
	O_zd1 := VitalMUX2
		     (data0 => O_zd, 
		      data1 => WDATA_ipd,
		      dselect => WE_ipd);

    VitalPathDelay01 (
      OutSignal => RDATA,
      GlitchData => O_GlitchData,
      OutSignalName => "RDATA",
      OutTemp => O_zd1,
      Paths => (0 => (WCLK_ipd'last_event, tpd_WCLK_RDATA, TRUE),
                1 => (AD0_ipd'last_event, tpd_AD0_RDATA, TRUE),
                2 => (AD1_ipd'last_event, tpd_AD1_RDATA, TRUE),
                3 => (AD2_ipd'last_event, tpd_AD2_RDATA, TRUE),
                4 => (AD3_ipd'last_event, tpd_AD3_RDATA, TRUE),
                5 => (AD4_ipd'last_event, tpd_AD4_RDATA, TRUE),
                6 => (AD5_ipd'last_event, tpd_AD5_RDATA, TRUE)),
      Mode => OnEvent,
      Xon => Xon,
      MsgOn => MsgOn,
      MsgSeverity => WARNING);

    end process VITALBehavior_Read;

end VITAL;

configuration CFG_RAM64X1S_1_VITAL of RAM64X1S_1 is
   for VITAL
   end for;
end CFG_RAM64X1S_1_VITAL;

----- CELL RAMB256X18DSR -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;

library LAVA1;
use LAVA1.RAM_PACKAGE.all;

-- entity declaration --
entity RAMB256X18DSR is
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_RWCLK0_DA0                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA1                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA2                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA3                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA4                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA5                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA6                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA7                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA8                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA9                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA10                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA11                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA12                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA13                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA14                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_DA15                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_EDA0                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK0_EDA1                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB0                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB1                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB2                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB3                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB4                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB5                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB6                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB7                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB8                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB9                   :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB10                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB11                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB12                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB13                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB14                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_DB15                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_EDB0                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_RWCLK1_EDB1                  :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);

      tpd_OE0_DA0                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA1                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA2                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA3                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA4                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA5                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA6                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA7                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA8                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA9                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA10                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA11                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA12                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA13                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA14                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_DA15                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_EDA0                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE0_EDA1                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);

      tpd_OE1_DB0                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB1                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB2                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB3                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB4                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB5                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB6                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB7                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB8                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB9                      :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB10                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB11                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB12                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB13                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB14                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_DB15                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_EDB0                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);
      tpd_OE1_EDB1                     :	VitalDelayType01Z := (0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns, 0.0 ns);

      tsetup_WEN0_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      thold_WEN0_RWCLK0_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_WEN1_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      thold_WEN1_RWCLK1_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      tsetup_CE0_RWCLK0_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      thold_CE0_RWCLK0_noedge_posedge     :	VitalDelayType   := 0.0 ns;
      tsetup_CE1_RWCLK1_noedge_posedge    :	VitalDelayType   := 0.0 ns;
      thold_CE1_RWCLK1_noedge_posedge     :	VitalDelayType   := 0.0 ns;

      tsetup_ADDA0_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA0_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA1_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA1_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA2_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA2_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA3_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA3_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA4_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA4_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA5_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA5_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA6_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA6_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDA7_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDA7_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;

      tsetup_DA0_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA0_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA1_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA1_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA2_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA2_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA3_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA3_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA4_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA4_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA5_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA5_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA6_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA6_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA7_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA7_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA8_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA8_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA9_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DA9_RWCLK0_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DA10_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DA10_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DA11_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DA11_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DA12_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DA12_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DA13_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DA13_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DA14_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DA14_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DA15_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DA15_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_EDA0_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_EDA0_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_EDA1_RWCLK0_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_EDA1_RWCLK0_noedge_posedge  :	VitalDelayType   := 0.0 ns;

      tsetup_ADDB0_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB0_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB1_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB1_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB2_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB2_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB3_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB3_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB4_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB4_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB5_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB5_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB6_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB6_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_ADDB7_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_ADDB7_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;

      tsetup_DB0_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB0_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB1_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB1_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB2_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB2_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB3_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB3_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB4_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB4_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB5_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB5_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB6_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB6_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB7_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB7_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB8_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB8_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB9_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      thold_DB9_RWCLK1_noedge_posedge   :	VitalDelayType   := 0.0 ns;
      tsetup_DB10_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DB10_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DB11_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DB11_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DB12_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DB12_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DB13_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DB13_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DB14_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DB14_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_DB15_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_DB15_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_EDB0_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_EDB0_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;
      tsetup_EDB1_RWCLK1_noedge_posedge :	VitalDelayType   := 0.0 ns;
      thold_EDB1_RWCLK1_noedge_posedge  :	VitalDelayType   := 0.0 ns;


      tpw_RWCLK0_posedge                :	VitalDelayType   := 2.0 ns;
      tpw_RWCLK1_posedge                :	VitalDelayType   := 2.0 ns;

      tipd_WEN0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_WEN1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RWCLK0                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_RWCLK1                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_CE0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_CE1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_OE0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_ADDA0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDA7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_ADDB0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB4                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB5                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB6                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_ADDB7                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_DA0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA14                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DA15                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_EDA0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_EDA1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tipd_DB0                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB1                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB2                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB3                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB4                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB5                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB6                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB7                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB8                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB9                          :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB10                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB11                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB12                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB13                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB14                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DB15                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_EDB0                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_EDB1                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      INIT01                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT02                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT03                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT04                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT05                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT06                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT07                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT08                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT09                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT0A                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT0B                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT0C                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT0D                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT0E                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT0F                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT10                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT11                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
      INIT12                           :	bit_vector := X"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");

   port(
      WEN0                           :	in    STD_ULOGIC;
      WEN1                           :	in    STD_ULOGIC;
      RWCLK0                         :	in    STD_ULOGIC;
      RWCLK1                         :	in    STD_ULOGIC;
      CE0                            :	in    STD_ULOGIC;
      CE1                            :	in    STD_ULOGIC;
      OE0                            :	in    STD_ULOGIC;
      OE1                            :	in    STD_ULOGIC;
      ADDA0                          :	in    STD_ULOGIC;
      ADDA1                          :	in    STD_ULOGIC;
      ADDA2                          :	in    STD_ULOGIC;
      ADDA3                          :	in    STD_ULOGIC;
      ADDA4                          :	in    STD_ULOGIC;
      ADDA5                          :	in    STD_ULOGIC;
      ADDA6                          :	in    STD_ULOGIC;
      ADDA7                          :	in    STD_ULOGIC;
      ADDB0                          :	in    STD_ULOGIC;
      ADDB1                          :	in    STD_ULOGIC;
      ADDB2                          :	in    STD_ULOGIC;
      ADDB3                          :	in    STD_ULOGIC;
      ADDB4                          :	in    STD_ULOGIC;
      ADDB5                          :	in    STD_ULOGIC;
      ADDB6                          :	in    STD_ULOGIC;
      ADDB7                          :	in    STD_ULOGIC;
      DA0                            :	inout STD_ULOGIC;
      DA1                            :	inout STD_ULOGIC;
      DA2                            :	inout STD_ULOGIC;
      DA3                            :	inout STD_ULOGIC;
      DA4                            :	inout STD_ULOGIC;
      DA5                            :	inout STD_ULOGIC;
      DA6                            :	inout STD_ULOGIC;
      DA7                            :	inout STD_ULOGIC;
      DA8                            :	inout STD_ULOGIC;
      DA9                            :	inout STD_ULOGIC;
      DA10                           :	inout STD_ULOGIC;
      DA11                           :	inout STD_ULOGIC;
      DA12                           :	inout STD_ULOGIC;
      DA13                           :	inout STD_ULOGIC;
      DA14                           :	inout STD_ULOGIC;
      DA15                           :	inout STD_ULOGIC;
      EDA0                           :	inout STD_ULOGIC;
      EDA1                           :	inout STD_ULOGIC;
      DB0                            :	inout STD_ULOGIC;
      DB1                            :	inout STD_ULOGIC;
      DB2                            :	inout STD_ULOGIC;
      DB3                            :	inout STD_ULOGIC;
      DB4                            :	inout STD_ULOGIC;
      DB5                            :	inout STD_ULOGIC;
      DB6                            :	inout STD_ULOGIC;
      DB7                            :	inout STD_ULOGIC;
      DB8                            :	inout STD_ULOGIC;
      DB9                            :	inout STD_ULOGIC;
      DB10                           :	inout STD_ULOGIC;
      DB11                           :	inout STD_ULOGIC;
      DB12                           :	inout STD_ULOGIC;
      DB13                           :	inout STD_ULOGIC;
      DB14                           :	inout STD_ULOGIC;
      DB15                           :	inout STD_ULOGIC;
      EDB0                           :	inout STD_ULOGIC;
      EDB1                           :	inout STD_ULOGIC);
attribute VITAL_LEVEL0 of RAMB256X18DSR : entity is TRUE;
end RAMB256X18DSR;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
architecture VITAL of RAMB256X18DSR is
   ATTRIBUTE VITAL_LEVEL1 of VITAL   : ARCHITECTURE is FALSE;


      SIGNAL WEN0_ipd                :   std_logic :='X';
      SIGNAL WEN1_ipd                :   std_logic :='X';
      SIGNAL RWCLK0_ipd              :   std_logic :='X';
      SIGNAL RWCLK1_ipd              :   std_logic :='X';
      SIGNAL CE0_ipd                 :   std_logic :='X';
      SIGNAL CE1_ipd                 :   std_logic :='X';
      SIGNAL OE0_ipd                 :   std_logic :='X';
      SIGNAL OE1_ipd                 :   std_logic :='X';
      SIGNAL ADDA0_ipd               :   std_logic :='X';
      SIGNAL ADDA1_ipd               :   std_logic :='X';
      SIGNAL ADDA2_ipd               :   std_logic :='X';
      SIGNAL ADDA3_ipd               :   std_logic :='X';
      SIGNAL ADDA4_ipd               :   std_logic :='X';
      SIGNAL ADDA5_ipd               :   std_logic :='X';
      SIGNAL ADDA6_ipd               :   std_logic :='X';
      SIGNAL ADDA7_ipd               :   std_logic :='X';
      SIGNAL ADDB0_ipd               :   std_logic :='X';
      SIGNAL ADDB1_ipd               :   std_logic :='X';
      SIGNAL ADDB2_ipd               :   std_logic :='X';
      SIGNAL ADDB3_ipd               :   std_logic :='X';
      SIGNAL ADDB4_ipd               :   std_logic :='X';
      SIGNAL ADDB5_ipd               :   std_logic :='X';
      SIGNAL ADDB6_ipd               :   std_logic :='X';
      SIGNAL ADDB7_ipd               :   std_logic :='X';
      SIGNAL DA0_ipd                 :   std_logic :='X';
      SIGNAL DA1_ipd                 :   std_logic :='X';
      SIGNAL DA2_ipd                 :   std_logic :='X';
      SIGNAL DA3_ipd                 :   std_logic :='X';
      SIGNAL DA4_ipd                 :   std_logic :='X';
      SIGNAL DA5_ipd                 :   std_logic :='X';
      SIGNAL DA6_ipd                 :   std_logic :='X';
      SIGNAL DA7_ipd                 :   std_logic :='X';
      SIGNAL DA8_ipd                 :   std_logic :='X';
      SIGNAL DA9_ipd                 :   std_logic :='X';
      SIGNAL DA10_ipd                :   std_logic :='X';
      SIGNAL DA11_ipd                :   std_logic :='X';
      SIGNAL DA12_ipd                :   std_logic :='X';
      SIGNAL DA13_ipd                :   std_logic :='X';
      SIGNAL DA14_ipd                :   std_logic :='X';
      SIGNAL DA15_ipd                :   std_logic :='X';
      SIGNAL EDA0_ipd                :   std_logic :='X';
      SIGNAL EDA1_ipd                :   std_logic :='X';
      SIGNAL DB0_ipd                 :   std_logic :='X';
      SIGNAL DB1_ipd                 :   std_logic :='X';
      SIGNAL DB2_ipd                 :   std_logic :='X';
      SIGNAL DB3_ipd                 :   std_logic :='X';
      SIGNAL DB4_ipd                 :   std_logic :='X';
      SIGNAL DB5_ipd                 :   std_logic :='X';
      SIGNAL DB6_ipd                 :   std_logic :='X';
      SIGNAL DB7_ipd                 :   std_logic :='X';
      SIGNAL DB8_ipd                 :   std_logic :='X';
      SIGNAL DB9_ipd                 :   std_logic :='X';
      SIGNAL DB10_ipd                :   std_logic :='X';
      SIGNAL DB11_ipd                :   std_logic :='X';
      SIGNAL DB12_ipd                :   std_logic :='X';
      SIGNAL DB13_ipd                :   std_logic :='X';
      SIGNAL DB14_ipd                :   std_logic :='X';
      SIGNAL DB15_ipd                :   std_logic :='X';
      SIGNAL EDB0_ipd                :   std_logic :='X';
      SIGNAL EDB1_ipd                :   std_logic :='X';

      SIGNAL data_out_a              :   std_logic_vector(17 downto 0) := z_data_18;
      SIGNAL data_out_b              :   std_logic_vector(17 downto 0) := z_data_18;

      SIGNAL rd_add_a                :   std_logic_vector(7 downto 0);
      SIGNAL rd_add_b                :   std_logic_vector(7 downto 0);

      SIGNAL rd_clk0                 :   std_logic  := 'X';
      SIGNAL rd_clk1                 :   std_logic  := 'X';

      SIGNAL wr_clk0                 :   std_logic  := 'X';
      SIGNAL wr_clk1                 :   std_logic  := 'X';

      SIGNAL wr_add_a                :   std_logic_vector(7 downto 0);
      SIGNAL wr_add_b                :   std_logic_vector(7 downto 0);

      SIGNAL din_a                   :   std_logic_vector(17 downto 0);
      SIGNAL din_b                   :   std_logic_vector(17 downto 0);

      constant init01_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT01)) ;
      constant init02_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT02)) ;
      constant init03_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT03)) ;
      constant init04_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT04)) ;
      constant init05_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT05)) ;
      constant init06_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT06)) ;
      constant init07_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT07)) ;
      constant init08_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT08)) ;
      constant init09_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT09)) ;
      constant init0A_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT0A)) ;
      constant init0B_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT0B)) ;
      constant init0C_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT0C)) ;
      constant init0D_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT0D)) ;
      constant init0E_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT0E)) ;
      constant init0F_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT0F)) ;
      constant init10_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT10)) ;
      constant init11_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT11)) ;
      constant init12_sig              :   std_logic_vector(255 downto 0 ) := ( To_StdLogicVector(INIT12)) ;

      signal memory_array            :   memory_array_typ_256  := FillInit256(init12_sig & init11_sig & 
                                         init10_sig & init0F_sig & init0E_sig & init0D_sig & 
                                         init0C_sig & init0B_sig & init0A_sig & init09_sig & 
                                         init08_sig & init07_sig & init06_sig & init05_sig & 
                                         init04_sig & init03_sig & init02_sig & init01_sig);

begin

  ---------------------------------------------------------------------
  -- INPUT PATH DELAYs
  ---------------------------------------------------------------------
  WIREDELAY : BLOCK
  BEGIN

	VitalWireDelay (WEN0_ipd,     WEN0,       tipd_WEN0);
	VitalWireDelay (WEN1_ipd,     WEN1,       tipd_WEN1);
	VitalWireDelay (RWCLK0_ipd,   RWCLK0,     tipd_RWCLK0);
	VitalWireDelay (RWCLK1_ipd,   RWCLK1,     tipd_RWCLK1);
	VitalWireDelay (CE0_ipd,      CE0,        tipd_CE0);
	VitalWireDelay (CE1_ipd,      CE1,        tipd_CE1);
	VitalWireDelay (OE0_ipd,      OE0,        tipd_OE0);
	VitalWireDelay (OE1_ipd,      OE1,        tipd_OE1);

	VitalWireDelay (ADDA0_ipd,    ADDA0,      tipd_ADDA0);
	VitalWireDelay (ADDA1_ipd,    ADDA1,      tipd_ADDA1);
	VitalWireDelay (ADDA2_ipd,    ADDA2,      tipd_ADDA2);
	VitalWireDelay (ADDA3_ipd,    ADDA3,      tipd_ADDA3);
	VitalWireDelay (ADDA4_ipd,    ADDA4,      tipd_ADDA4);
	VitalWireDelay (ADDA5_ipd,    ADDA5,      tipd_ADDA5);
	VitalWireDelay (ADDA6_ipd,    ADDA6,      tipd_ADDA6);
	VitalWireDelay (ADDA7_ipd,    ADDA7,      tipd_ADDA7);

	VitalWireDelay (ADDB0_ipd,    ADDB0,      tipd_ADDB0);
	VitalWireDelay (ADDB1_ipd,    ADDB1,      tipd_ADDB1);
	VitalWireDelay (ADDB2_ipd,    ADDB2,      tipd_ADDB2);
	VitalWireDelay (ADDB3_ipd,    ADDB3,      tipd_ADDB3);
	VitalWireDelay (ADDB4_ipd,    ADDB4,      tipd_ADDB4);
	VitalWireDelay (ADDB5_ipd,    ADDB5,      tipd_ADDB5);
	VitalWireDelay (ADDB6_ipd,    ADDB6,      tipd_ADDB6);
	VitalWireDelay (ADDB7_ipd,    ADDB7,      tipd_ADDB7);

	VitalWireDelay (DA0_ipd,      DA0,        tipd_DA0);
	VitalWireDelay (DA1_ipd,      DA1,        tipd_DA1);
	VitalWireDelay (DA2_ipd,      DA2,        tipd_DA2);
	VitalWireDelay (DA3_ipd,      DA3,        tipd_DA3);
	VitalWireDelay (DA4_ipd,      DA4,        tipd_DA4);
	VitalWireDelay (DA5_ipd,      DA5,        tipd_DA5);
	VitalWireDelay (DA6_ipd,      DA6,        tipd_DA6);
	VitalWireDelay (DA7_ipd,      DA7,        tipd_DA7);
	VitalWireDelay (DA8_ipd,      DA8,        tipd_DA8);
	VitalWireDelay (DA9_ipd,      DA9,        tipd_DA9);
	VitalWireDelay (DA10_ipd,     DA10,       tipd_DA10);
	VitalWireDelay (DA11_ipd,     DA11,       tipd_DA11);
	VitalWireDelay (DA12_ipd,     DA12,       tipd_DA12);
	VitalWireDelay (DA13_ipd,     DA13,       tipd_DA13);
	VitalWireDelay (DA14_ipd,     DA14,       tipd_DA14);
	VitalWireDelay (DA15_ipd,     DA15,       tipd_DA15);
	VitalWireDelay (EDA0_ipd,     EDA0,       tipd_EDA0);
	VitalWireDelay (EDA1_ipd,     EDA1,       tipd_EDA1);

	VitalWireDelay (DB0_ipd,      DB0,        tipd_DB0);
	VitalWireDelay (DB1_ipd,      DB1,        tipd_DB1);
	VitalWireDelay (DB2_ipd,      DB2,        tipd_DB2);
	VitalWireDelay (DB3_ipd,      DB3,        tipd_DB3);
	VitalWireDelay (DB4_ipd,      DB4,        tipd_DB4);
	VitalWireDelay (DB5_ipd,      DB5,        tipd_DB5);
	VitalWireDelay (DB6_ipd,      DB6,        tipd_DB6);
	VitalWireDelay (DB7_ipd,      DB7,        tipd_DB7);
	VitalWireDelay (DB8_ipd,      DB8,        tipd_DB8);
	VitalWireDelay (DB9_ipd,      DB9,        tipd_DB9);
	VitalWireDelay (DB10_ipd,     DB10,       tipd_DB10);
	VitalWireDelay (DB11_ipd,     DB11,       tipd_DB11);
	VitalWireDelay (DB12_ipd,     DB12,       tipd_DB12);
	VitalWireDelay (DB13_ipd,     DB13,       tipd_DB13);
	VitalWireDelay (DB14_ipd,     DB14,       tipd_DB14);
	VitalWireDelay (DB15_ipd,     DB15,       tipd_DB15);
	VitalWireDelay (EDB0_ipd,     EDB0,       tipd_EDB0);
	VitalWireDelay (EDB1_ipd,     EDB1,       tipd_EDB1);
      END BLOCK;


  ---------------------------------------------------------------------
  -- Wrapper Section
  ---------------------------------------------------------------------

   wrapper_read_add_a : process(OE0_ipd, 
                                ADDA0_ipd, 
                                ADDA1_ipd, 
                                ADDA2_ipd, 
                                ADDA3_ipd, 
                                ADDA4_ipd, 
                                ADDA5_ipd, 
                                ADDA6_ipd, 
                                ADDA7_ipd, 
                                WEN0_ipd)

   begin

   if ( OE0_ipd = '1' and WEN0_ipd = '1') then
        rd_add_a(7) <= ADDA7_ipd;
        rd_add_a(6) <= ADDA6_ipd;
        rd_add_a(5) <= ADDA5_ipd;
        rd_add_a(4) <= ADDA4_ipd;
        rd_add_a(3) <= ADDA3_ipd;
        rd_add_a(2) <= ADDA2_ipd;
        rd_add_a(1) <= ADDA1_ipd;
        rd_add_a(0) <= ADDA0_ipd;
   else
	rd_add_a <= x_add_8;
   end if;
   end process wrapper_read_add_a;

   wrapper_read_add_b : process(OE1_ipd, 
                                ADDB0_ipd, 
                                ADDB1_ipd, 
                                ADDB2_ipd, 
                                ADDB3_ipd, 
                                ADDB4_ipd, 
                                ADDB5_ipd, 
                                ADDB6_ipd, 
                                ADDB7_ipd, 
                                WEN1_ipd)

   begin

   if ( OE1_ipd = '1' and WEN1_ipd = '1') then
        rd_add_b(7) <= ADDB7_ipd;
        rd_add_b(6) <= ADDB6_ipd;
        rd_add_b(5) <= ADDB5_ipd;
        rd_add_b(4) <= ADDB4_ipd;
        rd_add_b(3) <= ADDB3_ipd;
        rd_add_b(2) <= ADDB2_ipd;
        rd_add_b(1) <= ADDB1_ipd;
        rd_add_b(0) <= ADDB0_ipd;
   else
	rd_add_b <= x_add_8;
   end if;
   end process wrapper_read_add_b;


   wrapper_read_clk_a : 
   --process(OE0_ipd, RWCLK0_ipd, CE0_ipd, WEN0_ipd) --071804
   process (RWCLK0_ipd)   --071804
   begin
    if rising_edge(RWCLK0_ipd) then  --071804
       if (OE0_ipd = '1' and WEN0_ipd = '1' and CE0_ipd ='0') then
	    rd_clk0 <= RWCLK0_ipd;
       end if;
    else
	rd_clk0 <= '0';
    end if;
   end process;

   wrapper_read_clk_b : 
   --process(OE1_ipd, RWCLK1_ipd, CE1_ipd,WEN1_ipd) --071804
   process (RWCLK1_ipd)  --071804

   begin
    if rising_edge(RWCLK1_ipd) then --071804
       if (OE1_ipd = '1' and WEN1_ipd = '1' and CE1_ipd ='0') then
	    rd_clk1 <= RWCLK1_ipd;
       end if;
    else
	rd_clk1 <= '0';
    end if;
   end process;

--   wrapper_write_clk_a : process(WEN0_ipd, RWCLK0_ipd, CE0_ipd)
   -- wrapper_write_clk_a : process(WEN0_ipd, RWCLK0_ipd) --071804
   wrapper_write_clk_a : process(RWCLK0_ipd) --071804

   begin
--    if (WEN0_ipd = '0' and CE0_ipd = '0' ) then
    if rising_edge (RWCLK0_ipd) then  --071804
      --if (WEN0_ipd = '0' and CE0_ipd = '0' ) then --ct112304
      if (WEN0_ipd = '0'  ) then --ct061605
	  wr_clk0 <= RWCLK0_ipd;
      end if;
    else
	wr_clk0 <= '0';
    end if;
   end process;

--   wrapper_write_clk_b : process(WEN1_ipd, RWCLK1_ipd, CE1_ipd)
   -- wrapper_write_clk_b : process(WEN1_ipd, RWCLK1_ipd) --071804
   wrapper_write_clk_b : process( RWCLK1_ipd) --071804

   begin
--    if (WEN1_ipd = '0'and CE1_ipd = '0') then
    if rising_edge (RWCLK1_ipd) then--071804
      --if (WEN1_ipd = '0'and CE1_ipd = '0') then --ct112304
      if (WEN1_ipd = '0'  ) then --ct061605
	  wr_clk1 <= RWCLK1_ipd;
      end if;
    else
	wr_clk1 <= '0';
    end if;
   end process;

   write_address_a : process(
                            ADDA7_ipd,
                            ADDA6_ipd,
                            ADDA5_ipd,
                            ADDA4_ipd,
                            ADDA3_ipd,
                            ADDA2_ipd,
                            ADDA1_ipd,
                            ADDA0_ipd
                            )

    begin
        wr_add_a(7) <= ADDA7_ipd;
        wr_add_a(6) <= ADDA6_ipd;
        wr_add_a(5) <= ADDA5_ipd;
        wr_add_a(4) <= ADDA4_ipd;
        wr_add_a(3) <= ADDA3_ipd;
        wr_add_a(2) <= ADDA2_ipd;
        wr_add_a(1) <= ADDA1_ipd;
        wr_add_a(0) <= ADDA0_ipd;
   end process;

   write_address_b : process(
                            ADDB7_ipd,
                            ADDB6_ipd,
                            ADDB5_ipd,
                            ADDB4_ipd,
                            ADDB3_ipd,
                            ADDB2_ipd,
                            ADDB1_ipd,
                            ADDB0_ipd
                            )

    begin
        wr_add_b(7) <= ADDB7_ipd;
        wr_add_b(6) <= ADDB6_ipd;
        wr_add_b(5) <= ADDB5_ipd;
        wr_add_b(4) <= ADDB4_ipd;
        wr_add_b(3) <= ADDB3_ipd;
        wr_add_b(2) <= ADDB2_ipd;
        wr_add_b(1) <= ADDB1_ipd;
        wr_add_b(0) <= ADDB0_ipd;
   end process;

   wrapper_write_data_a : process(WEN0_ipd, 
                                  EDA1_ipd, 
                                  EDA0_ipd, 
                                  DA15_ipd, 
                                  DA14_ipd, 
                                  DA13_ipd, 
                                  DA12_ipd, 
                                  DA11_ipd, 
                                  DA10_ipd, 
                                  DA9_ipd, 
                                  DA8_ipd, 
                                  DA7_ipd, 
                                  DA6_ipd, 
                                  DA5_ipd, 
                                  DA4_ipd, 
                                  DA3_ipd, 
                                  DA2_ipd, 
                                  DA1_ipd, 
                                  DA0_ipd)

   begin
    if (WEN0_ipd = '0') then
        din_a(17) <= EDA1_ipd;
        din_a(16) <= EDA0_ipd;
        din_a(15) <= DA15_ipd;
        din_a(14) <= DA14_ipd;
        din_a(13) <= DA13_ipd;
        din_a(12) <= DA12_ipd;
        din_a(11) <= DA11_ipd;
        din_a(10) <= DA10_ipd;
        din_a(9)  <= DA9_ipd;
        din_a(8)  <= DA8_ipd;
        din_a(7)  <= DA7_ipd;
        din_a(6)  <= DA6_ipd;
        din_a(5)  <= DA5_ipd;
        din_a(4)  <= DA4_ipd;
        din_a(3)  <= DA3_ipd;
        din_a(2)  <= DA2_ipd;
        din_a(1)  <= DA1_ipd;
        din_a(0)  <= DA0_ipd;
    else
	din_a <= x_data_18;
    end if;
   end process;

   wrapper_write_data_b : process(WEN1_ipd, 
                                  EDA1_ipd, 
                                  EDA0_ipd, 
                                  DB15_ipd, 
                                  DB14_ipd, 
                                  DB13_ipd, 
                                  DB12_ipd, 
                                  DB11_ipd, 
                                  DB10_ipd, 
                                  DB9_ipd, 
                                  DB8_ipd, 
                                  DB7_ipd, 
                                  DB6_ipd, 
                                  DB5_ipd, 
                                  DB4_ipd, 
                                  DB3_ipd, 
                                  DB2_ipd, 
                                  DB1_ipd, 
                                  DB0_ipd)

   begin
    if (WEN1_ipd = '0') then
        din_b(17) <= EDB1_ipd;
        din_b(16) <= EDB0_ipd;
        din_b(15) <= DB15_ipd;
        din_b(14) <= DB14_ipd;
        din_b(13) <= DB13_ipd;
        din_b(12) <= DB12_ipd;
        din_b(11) <= DB11_ipd;
        din_b(10) <= DB10_ipd;
        din_b(9)  <= DB9_ipd;
        din_b(8)  <= DB8_ipd;
        din_b(7)  <= DB7_ipd;
        din_b(6)  <= DB6_ipd;
        din_b(5)  <= DB5_ipd;
        din_b(4)  <= DB4_ipd;
        din_b(3)  <= DB3_ipd;
        din_b(2)  <= DB2_ipd;
        din_b(1)  <= DB1_ipd;
        din_b(0)  <= DB0_ipd;
    else
	din_b <= x_data_18;
    end if;
   end process;

      --------------------
      -- RAMB256X18DSR Write Behavior
      --------------------
      VITALBehavior_Write : Process (
                            memory_array,
                            wr_clk0, wr_clk1,
                            rd_clk0, rd_clk1,
                            din_a, din_b,
                            rd_add_a, rd_add_b,
                            wr_add_a, wr_add_b)
  
                

        -- Local variables used for timing checks
  
        variable tempaddr_a                  : integer     := 0;
        variable tempaddr_b                  : integer     := 0;
	variable rd_address_a                : integer     := 0; 
	variable rd_address_b                : integer     := 0;

        variable Tviol_WEN0_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_WEN1_RWCLK1_posedge   : std_ulogic  := '0';

        variable Tviol_CE0_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_CE1_RWCLK1_posedge    : std_ulogic  := '0';

        variable Tviol_ADDA0_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA1_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA2_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA3_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA4_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA5_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA6_RWCLK0_posedge  : std_ulogic  := '0';
        variable Tviol_ADDA7_RWCLK0_posedge  : std_ulogic  := '0';

        variable Tviol_ADDB0_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB1_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB2_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB3_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB4_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB5_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB6_RWCLK1_posedge  : std_ulogic  := '0';
        variable Tviol_ADDB7_RWCLK1_posedge  : std_ulogic  := '0';

        variable Tviol_DA0_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA1_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA2_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA3_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA4_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA5_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA6_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA7_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA8_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA9_RWCLK0_posedge    : std_ulogic  := '0';
        variable Tviol_DA10_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_DA11_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_DA12_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_DA13_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_DA14_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_DA15_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_EDA0_RWCLK0_posedge   : std_ulogic  := '0';
        variable Tviol_EDA1_RWCLK0_posedge   : std_ulogic  := '0';

        variable Tviol_DB0_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB1_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB2_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB3_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB4_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB5_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB6_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB7_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB8_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB9_RWCLK1_posedge    : std_ulogic  := '0';
        variable Tviol_DB10_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_DB11_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_DB12_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_DB13_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_DB14_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_DB15_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_EDB0_RWCLK1_posedge   : std_ulogic  := '0';
        variable Tviol_EDB1_RWCLK1_posedge   : std_ulogic  := '0';

        variable Tmkr_WEN0_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_WEN1_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_CE0_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_CE1_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_ADDA0_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA1_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA2_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA3_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA4_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA5_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA6_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDA7_RWCLK0_posedge   : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_ADDB0_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB1_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB2_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB3_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB4_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB5_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB6_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_ADDB7_RWCLK1_posedge   : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_DA0_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA1_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA2_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA3_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA4_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA5_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA6_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA7_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA8_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA9_RWCLK0_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA10_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA11_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA12_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA13_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA14_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DA15_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_EDA0_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_EDA1_RWCLK0_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable Tmkr_DB0_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB1_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB2_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB3_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB4_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB5_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB6_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB7_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB8_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB9_RWCLK1_posedge     : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB10_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB11_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB12_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB13_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB14_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_DB15_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_EDB0_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;
        variable Tmkr_EDB1_RWCLK1_posedge    : VitalTimingDataType := VitalTimingDataInit;

        variable PViol_RWCLK0                : std_ulogic := '0';
        variable PInfo_RWCLK0                : VitalPeriodDataType := VitalPeriodDataInit;

        variable PViol_RWCLK1                : std_ulogic := '0';
        variable PInfo_RWCLK1                : VitalPeriodDataType := VitalPeriodDataInit;

        -- Local variables used for functionality

        begin

    ------------------------
    --  Timing Check Section
    ------------------------
    if (TimingChecksOn) then

         VitalSetupHoldCheck (
          Violation               => Tviol_WEN0_RWCLK0_posedge,
          TimingData              => Tmkr_WEN0_RWCLK0_posedge,
          TestSignal              => WEN0_ipd,
          TestSignalName          => "WEN0",
          TestDelay               => 0.1 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0.1 ns,
          SetupHigh               => tsetup_WEN0_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_WEN0_RWCLK0_noedge_posedge,
          HoldLow                 => thold_WEN0_RWCLK0_noedge_posedge,
          HoldHigh                => thold_WEN0_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_WEN1_RWCLK1_posedge,
          TimingData              => Tmkr_WEN1_RWCLK1_posedge,
          TestSignal              => WEN1_ipd,
          TestSignalName          => "WEN1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_WEN1_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_WEN1_RWCLK1_noedge_posedge,
          HoldLow                 => thold_WEN1_RWCLK1_noedge_posedge,
          HoldHigh                => thold_WEN1_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE0_RWCLK0_posedge,
          TimingData              => Tmkr_CE0_RWCLK0_posedge,
          TestSignal              => CE0_ipd,
          TestSignalName          => "CE0",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_CE0_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_CE0_RWCLK0_noedge_posedge,
          HoldLow                 => thold_CE0_RWCLK0_noedge_posedge,
          HoldHigh                => thold_CE0_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_CE1_RWCLK1_posedge,
          TimingData              => Tmkr_CE1_RWCLK1_posedge,
          TestSignal              => CE1_ipd,
          TestSignalName          => "CE1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_CE1_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_CE1_RWCLK1_noedge_posedge,
          HoldLow                 => thold_CE1_RWCLK1_noedge_posedge,
          HoldHigh                => thold_CE1_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA0_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA0_RWCLK0_posedge,
          TestSignal              => ADDA0_ipd,
          TestSignalName          => "ADDA0",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA0_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA0_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA0_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA0_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA1_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA1_RWCLK0_posedge,
          TestSignal              => ADDA1_ipd,
          TestSignalName          => "ADDA1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA1_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA1_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA1_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA1_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA2_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA2_RWCLK0_posedge,
          TestSignal              => ADDA2_ipd,
          TestSignalName          => "ADDA2",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA2_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA2_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA2_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA2_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA3_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA3_RWCLK0_posedge,
          TestSignal              => ADDA3_ipd,
          TestSignalName          => "ADDA3",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA3_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA3_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA3_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA3_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA4_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA4_RWCLK0_posedge,
          TestSignal              => ADDA4_ipd,
          TestSignalName          => "ADDA4",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA4_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA4_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA4_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA4_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA5_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA5_RWCLK0_posedge,
          TestSignal              => ADDA5_ipd,
          TestSignalName          => "ADDA5",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA5_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA5_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA5_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA5_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);


         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA6_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA6_RWCLK0_posedge,
          TestSignal              => ADDA6_ipd,
          TestSignalName          => "ADDA6",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA6_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA6_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA6_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA6_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDA7_RWCLK0_posedge,
          TimingData              => Tmkr_ADDA7_RWCLK0_posedge,
          TestSignal              => ADDA7_ipd,
          TestSignalName          => "ADDA7",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDA7_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_ADDA7_RWCLK0_noedge_posedge,
          HoldLow                 => thold_ADDA7_RWCLK0_noedge_posedge,
          HoldHigh                => thold_ADDA7_RWCLK0_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB0_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB0_RWCLK1_posedge,
          TestSignal              => ADDB0_ipd,
          TestSignalName          => "ADDB0",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB0_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB0_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB0_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB0_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB1_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB1_RWCLK1_posedge,
          TestSignal              => ADDB1_ipd,
          TestSignalName          => "ADDB1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB1_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB1_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB1_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB1_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB2_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB2_RWCLK1_posedge,
          TestSignal              => ADDB2_ipd,
          TestSignalName          => "ADDB2",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB2_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB2_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB2_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB2_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB3_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB3_RWCLK1_posedge,
          TestSignal              => ADDB3_ipd,
          TestSignalName          => "ADDB3",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB3_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB3_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB3_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB3_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB4_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB4_RWCLK1_posedge,
          TestSignal              => ADDB4_ipd,
          TestSignalName          => "ADDB4",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB4_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB4_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB4_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB4_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB5_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB5_RWCLK1_posedge,
          TestSignal              => ADDB5_ipd,
          TestSignalName          => "ADDB5",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB5_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB5_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB5_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB5_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB6_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB6_RWCLK1_posedge,
          TestSignal              => ADDB6_ipd,
          TestSignalName          => "ADDB6",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB6_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB6_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB6_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB6_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_ADDB7_RWCLK1_posedge,
          TimingData              => Tmkr_ADDB7_RWCLK1_posedge,
          TestSignal              => ADDB7_ipd,
          TestSignalName          => "ADDB7",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_ADDB7_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_ADDB7_RWCLK1_noedge_posedge,
          HoldLow                 => thold_ADDB7_RWCLK1_noedge_posedge,
          HoldHigh                => thold_ADDB7_RWCLK1_noedge_posedge,
          CheckEnabled            => TRUE,
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA0_RWCLK0_posedge,
          TimingData              => Tmkr_DA0_RWCLK0_posedge,
          TestSignal              => DA0_ipd,
          TestSignalName          => "DA0",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA0_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA0_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA0_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA0_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA1_RWCLK0_posedge,
          TimingData              => Tmkr_DA1_RWCLK0_posedge,
          TestSignal              => DA1_ipd,
          TestSignalName          => "DA1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA1_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA1_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA1_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA1_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA2_RWCLK0_posedge,
          TimingData              => Tmkr_DA2_RWCLK0_posedge,
          TestSignal              => DA2_ipd,
          TestSignalName          => "DA2",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA2_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA2_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA2_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA2_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA3_RWCLK0_posedge,
          TimingData              => Tmkr_DA3_RWCLK0_posedge,
          TestSignal              => DA3_ipd,
          TestSignalName          => "DA3",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA3_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA3_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA3_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA3_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA4_RWCLK0_posedge,
          TimingData              => Tmkr_DA4_RWCLK0_posedge,
          TestSignal              => DA4_ipd,
          TestSignalName          => "DA4",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA4_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA4_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA4_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA4_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA5_RWCLK0_posedge,
          TimingData              => Tmkr_DA5_RWCLK0_posedge,
          TestSignal              => DA5_ipd,
          TestSignalName          => "DA5",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA5_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA5_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA5_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA5_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA6_RWCLK0_posedge,
          TimingData              => Tmkr_DA6_RWCLK0_posedge,
          TestSignal              => DA6_ipd,
          TestSignalName          => "DA6",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA6_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA6_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA6_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA6_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA7_RWCLK0_posedge,
          TimingData              => Tmkr_DA7_RWCLK0_posedge,
          TestSignal              => DA7_ipd,
          TestSignalName          => "DA7",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA7_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA7_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA7_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA7_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA8_RWCLK0_posedge,
          TimingData              => Tmkr_DA8_RWCLK0_posedge,
          TestSignal              => DA8_ipd,
          TestSignalName          => "DA8",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA8_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA8_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA8_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA8_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA9_RWCLK0_posedge,
          TimingData              => Tmkr_DA9_RWCLK0_posedge,
          TestSignal              => DA9_ipd,
          TestSignalName          => "DA9",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA9_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA9_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA9_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA9_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA10_RWCLK0_posedge,
          TimingData              => Tmkr_DA10_RWCLK0_posedge,
          TestSignal              => DA10_ipd,
          TestSignalName          => "DA10",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA10_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA10_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA10_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA10_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA11_RWCLK0_posedge,
          TimingData              => Tmkr_DA11_RWCLK0_posedge,
          TestSignal              => DA11_ipd,
          TestSignalName          => "DA11",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA11_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA11_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA11_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA11_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA12_RWCLK0_posedge,
          TimingData              => Tmkr_DA12_RWCLK0_posedge,
          TestSignal              => DA12_ipd,
          TestSignalName          => "DA12",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA12_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA12_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA12_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA12_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA13_RWCLK0_posedge,
          TimingData              => Tmkr_DA13_RWCLK0_posedge,
          TestSignal              => DA13_ipd,
          TestSignalName          => "DA13",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA13_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA13_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA13_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA13_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA14_RWCLK0_posedge,
          TimingData              => Tmkr_DA14_RWCLK0_posedge,
          TestSignal              => DA14_ipd,
          TestSignalName          => "DA14",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA14_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA14_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA14_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA14_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DA15_RWCLK0_posedge,
          TimingData              => Tmkr_DA15_RWCLK0_posedge,
          TestSignal              => DA15_ipd,
          TestSignalName          => "DA15",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DA15_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_DA15_RWCLK0_noedge_posedge,
          HoldLow                 => thold_DA5_RWCLK0_noedge_posedge,
          HoldHigh                => thold_DA5_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_EDA0_RWCLK0_posedge,
          TimingData              => Tmkr_EDA0_RWCLK0_posedge,
          TestSignal              => EDA0_ipd,
          TestSignalName          => "EDA0",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_EDA0_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_EDA0_RWCLK0_noedge_posedge,
          HoldLow                 => thold_EDA0_RWCLK0_noedge_posedge,
          HoldHigh                => thold_EDA0_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_EDA1_RWCLK0_posedge,
          TimingData              => Tmkr_EDA1_RWCLK0_posedge,
          TestSignal              => EDA1_ipd,
          TestSignalName          => "EDA1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK0",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_EDA1_RWCLK0_noedge_posedge,
          SetupLow                => tsetup_EDA1_RWCLK0_noedge_posedge,
          HoldLow                 => thold_EDA1_RWCLK0_noedge_posedge,
          HoldHigh                => thold_EDA1_RWCLK0_noedge_posedge,
          CheckEnabled            => TO_X01(WEN0_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DB0_RWCLK1_posedge,
          TimingData              => Tmkr_DB0_RWCLK1_posedge,
          TestSignal              => DB0_ipd,
          TestSignalName          => "DB0",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DB0_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_DB0_RWCLK1_noedge_posedge,
          HoldLow                 => thold_DB0_RWCLK1_noedge_posedge,
          HoldHigh                => thold_DB0_RWCLK1_noedge_posedge,
          CheckEnabled            => TO_X01(WEN1_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DB1_RWCLK1_posedge,
          TimingData              => Tmkr_DB1_RWCLK1_posedge,
          TestSignal              => DB1_ipd,
          TestSignalName          => "DB1",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DB1_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_DB1_RWCLK1_noedge_posedge,
          HoldLow                 => thold_DB1_RWCLK1_noedge_posedge,
          HoldHigh                => thold_DB1_RWCLK1_noedge_posedge,
          CheckEnabled            => TO_X01(WEN1_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DB2_RWCLK1_posedge,
          TimingData              => Tmkr_DB2_RWCLK1_posedge,
          TestSignal              => DB2_ipd,
          TestSignalName          => "DB2",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK0_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => tsetup_DB2_RWCLK1_noedge_posedge,
          SetupLow                => tsetup_DB2_RWCLK1_noedge_posedge,
          HoldLow                 => thold_DB2_RWCLK1_noedge_posedge,
          HoldHigh                => thold_DB2_RWCLK1_noedge_posedge,
          CheckEnabled            => TO_X01(WEN1_ipd) /= '1',
          RefTransition           => 'R',
          HeaderMsg               => InstancePath & "/RAMB256X18DSR",
          Xon                     => Xon,
          MsgOn                   => MsgOn,
          MsgSeverity             => WARNING);

         VitalSetupHoldCheck (
          Violation               => Tviol_DB3_RWCLK1_posedge,
          TimingData              => Tmkr_DB3_RWCLK1_posedge,
          TestSignal              => DB3_ipd,
          TestSignalName          => "DB3",
          TestDelay               => 0 ns,
          RefSignal               => RWCLK1_ipd,
          RefSignalName           => "RWCLK1",
          RefDelay                => 0 ns,
          SetupHigh               => 